/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.board.Move;

public class KillerMoves {
    private static final KillerMoves INSTANCE = new KillerMoves();
    private final int NUM_ENTRIES = 1000;
    private Move[] killer1 = new Move[1000];
    private Move[] killer2 = new Move[1000];

    private KillerMoves() {
    }

    public void addKiller(int ply, Move killerMove) {
        assert (killerMove != null);
        assert (killerMove.captured() == null);
        if (!killerMove.equals(this.killer1[ply])) {
            if (!killerMove.equals(this.killer2[ply])) {
                this.killer2[ply] = this.killer1[ply];
                this.killer1[ply] = killerMove;
            } else {
                Move tmp = this.killer1[ply];
                this.killer1[ply] = this.killer2[ply];
                this.killer2[ply] = tmp;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < 1000; ++i) {
            this.killer1[i] = null;
            this.killer2[i] = null;
        }
    }

    public Move getKiller1(int ply) {
        return this.killer1[ply];
    }

    public Move getKiller2(int ply) {
        return this.killer2[ply];
    }

    public static KillerMoves getInstance() {
        return INSTANCE;
    }
}

