/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.exceptions.IllegalMoveException;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.utils.PieceFactory;
import java.util.List;

public final class MoveParser {
    private String strMove;
    private Board board;

    private Move getCastlingMove() {
        if (this.strMove.equalsIgnoreCase("O-O") || this.strMove.equals("0-0")) {
            if (this.board.getPlayerToMove().equals((Object)Color.WHITE)) {
                return new Move(Square.valueOf(File.FILE_E, Rank.RANK_1), Square.valueOf(File.FILE_G, Rank.RANK_1));
            }
            return new Move(Square.valueOf(File.FILE_E, Rank.RANK_8), Square.valueOf(File.FILE_G, Rank.RANK_8));
        }
        if (this.strMove.equalsIgnoreCase("O-O-O") || this.strMove.equals("0-0-0")) {
            if (this.board.getPlayerToMove().equals((Object)Color.WHITE)) {
                return new Move(Square.valueOf(File.FILE_E, Rank.RANK_1), Square.valueOf(File.FILE_C, Rank.RANK_1));
            }
            return new Move(Square.valueOf(File.FILE_E, Rank.RANK_8), Square.valueOf(File.FILE_C, Rank.RANK_8));
        }
        return null;
    }

    private Square getDestinationSquare() throws ParseException {
        Square dst = null;
        if (this.strMove.length() < 2) {
            throw new ParseException("couldn't translate destination (too short).");
        }
        File dstFile = File.file(this.strMove.substring(this.strMove.length() - 2, this.strMove.length() - 1));
        Rank dstRank = Rank.rank(this.strMove.substring(this.strMove.length() - 1, this.strMove.length()));
        dst = Square.valueOf(dstFile, dstRank);
        this.strMove = this.strMove.substring(0, this.strMove.length() - 2);
        return dst;
    }

    private Move getMatchingMove(File srcFile, Rank srcRank, Square dstSquare, Piece piece, Piece promo) throws IllegalMoveException {
        Move move = null;
        int nMatches = 0;
        List<Move> legalMoves = MoveGen.genLegalMoves(this.board);
        for (Move legalMove : legalMoves) {
            if (!this.isMatchToMove(srcFile, srcRank, dstSquare, piece, promo, legalMove)) continue;
            ++nMatches;
            move = legalMove;
        }
        if (nMatches != 1) {
            throw new IllegalMoveException("matches: " + nMatches);
        }
        return move;
    }

    private Piece getMovingPiece() {
        Piece piece = null;
        char p = this.strMove.charAt(0);
        if (this.isPieceChar(p) && String.valueOf(p).equals(String.valueOf(p).toUpperCase())) {
            boolean wtm = this.board.getPlayerToMove().equals((Object)Color.WHITE);
            piece = PieceFactory.getPiece(p, wtm);
            this.strMove = this.strMove.substring(1);
        }
        return piece;
    }

    private Move getPawnPush(Square dst, Piece promotion) throws ParseException {
        boolean wtm = this.board.getPlayerToMove().equals((Object)Color.WHITE);
        if (wtm) {
            if (dst.rank().equals((Object)Rank.RANK_8) && promotion == null) {
                throw new ParseException("white pawn promotion with no promotion piece.");
            }
            Square sq = Square.valueOf(dst.file(), dst.rank().south());
            if (Pawn.WHITE_PAWN.equals(this.board.getPiece(sq))) {
                return new Move(sq, dst, null, promotion);
            }
            sq = Square.valueOf(dst.file(), dst.rank().south().south());
            if (Pawn.WHITE_PAWN.equals(this.board.getPiece(sq))) {
                return new Move(sq, dst);
            }
        } else {
            if (dst.rank().equals((Object)Rank.RANK_1) && promotion == null) {
                throw new ParseException("black pawn promotion with no promotion piece.");
            }
            Square sq = Square.valueOf(dst.file(), dst.rank().north());
            if (Pawn.BLACK_PAWN.equals(this.board.getPiece(sq))) {
                return new Move(sq, dst, null, promotion);
            }
            sq = Square.valueOf(dst.file(), dst.rank().north().north());
            if (Pawn.BLACK_PAWN.equals(this.board.getPiece(sq))) {
                return new Move(sq, dst);
            }
        }
        throw new ParseException("length==0 and no source is set.");
    }

    private Piece getPromotionPiece() {
        Piece promo = null;
        char p = this.strMove.charAt(this.strMove.length() - 1);
        if (this.isPieceChar(p)) {
            boolean wtm = this.board.getPlayerToMove().equals((Object)Color.WHITE);
            promo = PieceFactory.getPiece(p, wtm);
            this.strMove = this.strMove.substring(0, this.strMove.length() - 1);
        }
        return promo;
    }

    private boolean isLegalMove(Move move) {
        List<Move> moves = MoveGen.genLegalMoves(this.board);
        return moves.contains(move);
    }

    private boolean isMatchToMove(File srcFile, Rank srcRank, Square dstSquare, Piece piece, Piece promo, Move legalMove) {
        if (srcFile != null && !srcFile.equals((Object)legalMove.from().file())) {
            return false;
        }
        if (srcRank != null && !srcRank.equals((Object)legalMove.from().rank())) {
            return false;
        }
        if (!dstSquare.equals(legalMove.to())) {
            return false;
        }
        if (!piece.equals(this.board.getPiece(legalMove.from()))) {
            return false;
        }
        return !(promo == null ? legalMove.promotion() != null : !promo.equals(legalMove.promotion()));
    }

    private boolean isPieceChar(char p) {
        Piece piece = PieceFactory.getPiece(p);
        return piece != null;
    }

    public synchronized Move parseMove(String strMove, Board board) throws ParseException, IllegalMoveException {
        this.board = board;
        this.strMove = strMove;
        Move move = this.parsePseudoMove();
        if (!this.isLegalMove(move)) {
            throw new IllegalMoveException(move.toString());
        }
        return move;
    }

    private Move parsePseudoMove() throws ParseException, IllegalMoveException {
        this.strMove = this.strMove.trim();
        this.strMove = this.strMove.replace("#", "");
        this.strMove = this.strMove.replace("+", "");
        this.strMove = this.strMove.replace("=", "");
        Move castlingMove = this.getCastlingMove();
        if (castlingMove != null) {
            return castlingMove;
        }
        Piece promotion = this.getPromotionPiece();
        Square dst = this.getDestinationSquare();
        if (this.strMove.length() == 0) {
            return this.getPawnPush(dst, promotion);
        }
        Piece piece = this.getMovingPiece();
        this.strMove = this.strMove.replace("x", "");
        File srcFile = this.setSourceFile();
        Rank srcRank = this.setSourceRank();
        piece = this.setPieceIfNotSet(piece, srcFile, srcRank);
        return this.getMatchingMove(srcFile, srcRank, dst, piece, promotion);
    }

    private Piece setPieceIfNotSet(Piece piece, File srcFile, Rank srcRank) {
        Piece myPiece = piece;
        if (myPiece == null) {
            if (srcFile != null && srcRank != null) {
                Square srcSq = Square.valueOf(srcFile, srcRank);
                myPiece = this.board.getPiece(srcSq);
            } else {
                boolean wtm = this.board.getPlayerToMove().equals((Object)Color.WHITE);
                myPiece = wtm ? Pawn.WHITE_PAWN : Pawn.BLACK_PAWN;
            }
        }
        return myPiece;
    }

    private File setSourceFile() {
        char p;
        File file = null;
        if (this.strMove.length() > 0 && (p = this.strMove.charAt(0)) >= 'a' && p <= 'h') {
            file = File.file(String.valueOf(p));
            this.strMove = this.strMove.substring(1);
        }
        return file;
    }

    private Rank setSourceRank() {
        char p;
        Rank rank = null;
        if (this.strMove.length() > 0 && (p = this.strMove.charAt(0)) >= '1' && p <= '8') {
            rank = Rank.rank(String.valueOf(p));
            this.strMove = this.strMove.substring(0, this.strMove.length() - 1);
        }
        return rank;
    }
}

