/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.hash;

import com.jamesswafford.chess4j.hash.PawnTranspositionTableEntry;
import eu.usrv.yamcore.auxiliary.LogHelper;

public class PawnTranspositionTable {
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");
    private static int numEntries;
    private static int mask;
    private PawnTranspositionTableEntry[] table = new PawnTranspositionTableEntry[numEntries];
    private long numProbes = 0L;
    private long numHits = 0L;
    private long numCollisions = 0L;
    private static final PawnTranspositionTable INSTANCE;

    private PawnTranspositionTable() {
        mLog.debug((Object)("# pawn transposition table initialized with  " + numEntries + " entries."));
    }

    public void clear() {
        this.clearStats();
        for (int i = 0; i < numEntries; ++i) {
            this.table[i] = null;
        }
    }

    public void clearStats() {
        this.numProbes = 0L;
        this.numHits = 0L;
        this.numCollisions = 0L;
    }

    private int getMaskedKey(long zobristKey) {
        int iKey = (int)zobristKey & mask;
        return iKey;
    }

    public PawnTranspositionTableEntry probe(long zobristKey) {
        ++this.numProbes;
        PawnTranspositionTableEntry te = this.table[this.getMaskedKey(zobristKey)];
        if (te != null) {
            if (te.getZobristKey() != zobristKey) {
                ++this.numCollisions;
                return null;
            }
            ++this.numHits;
        }
        return te;
    }

    public void store(long zobristKey, int score) {
        PawnTranspositionTableEntry te;
        this.table[this.getMaskedKey((long)zobristKey)] = te = new PawnTranspositionTableEntry(zobristKey, score);
    }

    public static PawnTranspositionTable getInstance() {
        return INSTANCE;
    }

    public long getNumProbes() {
        return this.numProbes;
    }

    public long getNumHits() {
        return this.numHits;
    }

    public long getNumCollisions() {
        return this.numCollisions;
    }

    static {
        mask = 1048575;
        numEntries = mask + 1;
        assert ((numEntries & mask) == 0);
        INSTANCE = new PawnTranspositionTable();
    }
}

