/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.eval;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Magic;
import com.jamesswafford.chess4j.board.squares.East;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.hash.PawnTranspositionTable;
import com.jamesswafford.chess4j.hash.PawnTranspositionTableEntry;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.King;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import com.jamesswafford.chess4j.utils.OrderedPair;
import com.jamesswafford.chess4j.utils.PawnUtils;
import java.util.HashMap;
import java.util.Map;

public final class Eval {
    public static final int QUEEN_VAL = 900;
    public static final int ROOK_VAL = 500;
    public static final int KNIGHT_VAL = 300;
    public static final int BISHOP_VAL = 320;
    public static final int PAWN_VAL = 100;
    public static final int ALL_NONPAWN_PIECES_VAL = 3140;
    public static final int ROOK_ON_7TH = 50;
    public static final int CONNECTED_MAJORS_ON_7TH = 80;
    public static final int ROOK_OPEN_FILE = 25;
    public static final int ROOK_HALF_OPEN_FILE = 15;
    public static final int PASSED_PAWN = 20;
    public static final int ISOLATED_PAWN = -20;
    public static final int DOUBLED_PAWN = -10;
    public static final int KING_SAFETY_PAWN_ONE_AWAY = -10;
    public static final int KING_SAFETY_PAWN_TWO_AWAY = -20;
    public static final int KING_SAFETY_PAWN_FAR_AWAY = -30;
    public static final int KING_SAFETY_MIDDLE_OPEN_FILE = -50;
    private static Map<Class<?>, Integer> pieceValMap = new HashMap();
    public static final int[] BISHOP_PST;
    public static final int[] KNIGHT_PST;
    public static final int[] PAWN_PST;
    public static final int[] ROOK_PST;
    public static final int[] KING_PST;
    public static final int[] KING_ENDGAME_PST;
    public static final int[] QUEEN_PST;

    private Eval() {
    }

    public static int eval(Board board) {
        OrderedPair<Integer, Integer> matNPScore = Eval.getNonPawnMaterialScore(board);
        OrderedPair<Integer, Integer> matPScore = Eval.getPawnMaterialScore(board);
        int score = matNPScore.getE1() - matNPScore.getE2() + matPScore.getE1() - matPScore.getE2();
        assert ((board.getPlayerToMove().equals((Object)Color.WHITE) ? score : -score) == Eval.evalMaterial(board));
        score += Eval.evalPawns(board);
        score += Eval.evalKnights(board);
        score += Eval.evalBishops(board);
        score += Eval.evalRooks(board);
        score += Eval.evalQueens(board);
        return board.getPlayerToMove().equals((Object)Color.WHITE) ? score : -(score += Eval.evalKings(board, matNPScore));
    }

    private static int evalBishops(Board board) {
        Square bishopSq;
        long bishopsMap;
        int bishopSqVal;
        int score = 0;
        for (bishopsMap = board.getWhiteBishops(); bishopsMap != 0L; bishopsMap ^= Bitboard.squares[bishopSqVal]) {
            bishopSqVal = Bitboard.msb(bishopsMap);
            bishopSq = Square.valueOf(bishopSqVal);
            score += Eval.evalBishop(true, bishopSq);
        }
        for (bishopsMap = board.getBlackBishops(); bishopsMap != 0L; bishopsMap ^= Bitboard.squares[bishopSqVal]) {
            bishopSqVal = Bitboard.lsb(bishopsMap);
            bishopSq = Square.valueOf(bishopSqVal);
            score -= Eval.evalBishop(false, bishopSq);
        }
        return score;
    }

    private static int evalBishop(boolean isWhite, Square sq) {
        return BISHOP_PST[isWhite ? sq.value() : sq.flipVertical().value()];
    }

    private static int evalKnights(Board board) {
        Square knightSq;
        long knightsMap;
        int knightSqVal;
        int score = 0;
        for (knightsMap = board.getWhiteKnights(); knightsMap != 0L; knightsMap ^= Bitboard.squares[knightSqVal]) {
            knightSqVal = Bitboard.msb(knightsMap);
            knightSq = Square.valueOf(knightSqVal);
            score += Eval.evalKnight(true, knightSq);
        }
        for (knightsMap = board.getBlackKnights(); knightsMap != 0L; knightsMap ^= Bitboard.squares[knightSqVal]) {
            knightSqVal = Bitboard.lsb(knightsMap);
            knightSq = Square.valueOf(knightSqVal);
            score -= Eval.evalKnight(false, knightSq);
        }
        return score;
    }

    private static int evalKnight(boolean isWhite, Square sq) {
        return KNIGHT_PST[isWhite ? sq.value() : sq.flipVertical().value()];
    }

    private static int evalPawns(Board board) {
        PawnTranspositionTableEntry pte = PawnTranspositionTable.getInstance().probe(board.getPawnKey());
        if (pte != null) {
            assert (pte.getScore() == Eval.evalPawnsNoHash(board));
            return pte.getScore();
        }
        int score = Eval.evalPawnsNoHash(board);
        PawnTranspositionTable.getInstance().store(board.getPawnKey(), score);
        return score;
    }

    private static int evalPawnsNoHash(Board board) {
        Square pawnSq;
        long pawnsMap;
        int pawnSqVal;
        int score = 0;
        for (pawnsMap = board.getWhitePawns(); pawnsMap != 0L; pawnsMap ^= Bitboard.squares[pawnSqVal]) {
            pawnSqVal = Bitboard.msb(pawnsMap);
            pawnSq = Square.valueOf(pawnSqVal);
            score += Eval.evalPawn(board, true, pawnSq);
        }
        for (pawnsMap = board.getBlackPawns(); pawnsMap != 0L; pawnsMap ^= Bitboard.squares[pawnSqVal]) {
            pawnSqVal = Bitboard.lsb(pawnsMap);
            pawnSq = Square.valueOf(pawnSqVal);
            score -= Eval.evalPawn(board, false, pawnSq);
        }
        return score;
    }

    private static int evalPawn(Board board, boolean isWhite, Square sq) {
        int score = 0;
        score += PAWN_PST[isWhite ? sq.value() : sq.flipVertical().value()];
        if (PawnUtils.isPassedPawn(board, sq, isWhite)) {
            score += 20;
        }
        if (PawnUtils.isIsolated(board, sq, isWhite)) {
            score -= 20;
        }
        if (PawnUtils.isDoubled(board, sq, isWhite)) {
            score -= 10;
        }
        return score;
    }

    private static int evalConnectedMajorOn7th(Board board, boolean isWhite, Square sq) {
        int score = 0;
        long rookMoves = Magic.getRookMoves(board, sq.value(), Bitboard.rays[sq.value()][East.getInstance().value()]);
        if (isWhite) {
            if ((rookMoves & (board.getWhiteRooks() | board.getWhiteQueens())) != 0L) {
                score += 80;
            }
        } else if ((rookMoves & (board.getBlackRooks() | board.getBlackQueens())) != 0L) {
            score += 80;
        }
        return score;
    }

    private static int evalMajorOn7th(Board board, boolean isWhite, Square sq) {
        int score = 0;
        if (isWhite) {
            if (sq.rank() == Rank.RANK_7 && board.getKingSquare(Color.BLACK).rank() == Rank.RANK_8) {
                score += 50;
                score += Eval.evalConnectedMajorOn7th(board, isWhite, sq);
            }
        } else if (sq.rank() == Rank.RANK_2 && board.getKingSquare(Color.WHITE).rank() == Rank.RANK_1) {
            score += 50;
            score += Eval.evalConnectedMajorOn7th(board, isWhite, sq);
        }
        return score;
    }

    private static int evalRookOpenFile(Board board, boolean isWhite, Square sq) {
        long enemies;
        long friends;
        int score = 0;
        if (isWhite) {
            friends = board.getWhitePawns();
            enemies = board.getBlackPawns();
        } else {
            friends = board.getBlackPawns();
            enemies = board.getWhitePawns();
        }
        long fileMask = Bitboard.files[sq.file().getValue()] ^ Bitboard.squares[sq.value()];
        if ((fileMask & friends) == 0L) {
            score = (fileMask & enemies) != 0L ? (score += 15) : (score += 25);
        }
        return score;
    }

    private static int evalRooks(Board board) {
        Square rookSq;
        long rooksMap;
        int rookSqVal;
        int score = 0;
        for (rooksMap = board.getWhiteRooks(); rooksMap != 0L; rooksMap ^= Bitboard.squares[rookSqVal]) {
            rookSqVal = Bitboard.msb(rooksMap);
            rookSq = Square.valueOf(rookSqVal);
            score += Eval.evalRook(board, true, rookSq);
        }
        for (rooksMap = board.getBlackRooks(); rooksMap != 0L; rooksMap ^= Bitboard.squares[rookSqVal]) {
            rookSqVal = Bitboard.lsb(rooksMap);
            rookSq = Square.valueOf(rookSqVal);
            score -= Eval.evalRook(board, false, rookSq);
        }
        return score;
    }

    private static int evalRook(Board board, boolean isWhite, Square sq) {
        int score = ROOK_PST[isWhite ? sq.value() : sq.flipVertical().value()];
        score += Eval.evalMajorOn7th(board, isWhite, sq);
        return score += Eval.evalRookOpenFile(board, isWhite, sq);
    }

    private static int evalKings(Board b, OrderedPair<Integer, Integer> matNPScore) {
        int score = 0;
        int ENDGAME_THRESHOLD = 1100;
        Square whiteKingSq = b.getKingSquare(Color.WHITE);
        Square blackKingSq = b.getKingSquare(Color.BLACK);
        if (matNPScore.getE2() >= 1100) {
            score += KING_PST[whiteKingSq.value()];
            score += Eval.scale(Eval.evalKingSafety(true, b), matNPScore.getE2());
        } else {
            score += KING_ENDGAME_PST[whiteKingSq.value()];
        }
        if (matNPScore.getE1() >= 1100) {
            score -= KING_PST[blackKingSq.flipVertical().value()];
            score -= Eval.scale(Eval.evalKingSafety(false, b), matNPScore.getE1());
        } else {
            score -= KING_ENDGAME_PST[blackKingSq.flipVertical().value()];
        }
        return score;
    }

    private static int evalKingSafety(boolean isWhite, Board board) {
        int score = 0;
        if (isWhite) {
            Square kingSq = board.getKingSquare(Color.WHITE);
            if (kingSq.file().eastOf(File.FILE_E)) {
                if (board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 5) : (board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 10) : (score -= 15));
                }
            } else if (kingSq.file().westOf(File.FILE_D)) {
                if (board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_2)) != Pawn.WHITE_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_3)) == Pawn.WHITE_PAWN ? (score -= 5) : (board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_4)) == Pawn.WHITE_PAWN ? (score -= 10) : (score -= 15));
                }
            } else if (((board.getWhitePawns() | board.getBlackPawns()) & Bitboard.files[kingSq.file().getValue()]) == 0L) {
                score -= 50;
            }
        } else {
            Square kingSq = board.getKingSquare(Color.BLACK);
            if (kingSq.file().eastOf(File.FILE_E)) {
                if (board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_F, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_G, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 5) : (board.getPiece(Square.valueOf(File.FILE_H, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 10) : (score -= 15));
                }
            } else if (kingSq.file().westOf(File.FILE_D)) {
                if (board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_C, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 10) : (board.getPiece(Square.valueOf(File.FILE_B, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 20) : (score -= 30));
                }
                if (board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_7)) != Pawn.BLACK_PAWN) {
                    score = board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_6)) == Pawn.BLACK_PAWN ? (score -= 5) : (board.getPiece(Square.valueOf(File.FILE_A, Rank.RANK_5)) == Pawn.BLACK_PAWN ? (score -= 10) : (score -= 15));
                }
            } else if (((board.getWhitePawns() | board.getBlackPawns()) & Bitboard.files[kingSq.file().getValue()]) == 0L) {
                score -= 50;
            }
        }
        return score;
    }

    private static int evalQueens(Board board) {
        Square queenSq;
        long queensMap;
        int queenSqVal;
        int score = 0;
        for (queensMap = board.getWhiteQueens(); queensMap != 0L; queensMap ^= Bitboard.squares[queenSqVal]) {
            queenSqVal = Bitboard.msb(queensMap);
            queenSq = Square.valueOf(queenSqVal);
            score += Eval.evalQueen(board, true, queenSq);
        }
        for (queensMap = board.getBlackQueens(); queensMap != 0L; queensMap ^= Bitboard.squares[queenSqVal]) {
            queenSqVal = Bitboard.lsb(queensMap);
            queenSq = Square.valueOf(queenSqVal);
            score -= Eval.evalQueen(board, false, queenSq);
        }
        return score;
    }

    private static int evalQueen(Board board, boolean isWhite, Square sq) {
        int score = QUEEN_PST[isWhite ? sq.value() : sq.flipVertical().value()];
        return score += Eval.evalMajorOn7th(board, isWhite, sq);
    }

    public static int getPieceValue(Piece piece) {
        return pieceValMap.get(piece.getClass());
    }

    public static OrderedPair<Integer, Integer> getPawnMaterialScore(Board board) {
        return new OrderedPair<Integer, Integer>(board.getNumPieces(Pawn.WHITE_PAWN) * 100, board.getNumPieces(Pawn.BLACK_PAWN) * 100);
    }

    public static OrderedPair<Integer, Integer> getNonPawnMaterialScore(Board board) {
        int wScore = board.getNumPieces(Queen.WHITE_QUEEN) * 900 + board.getNumPieces(Rook.WHITE_ROOK) * 500 + board.getNumPieces(Knight.WHITE_KNIGHT) * 300 + board.getNumPieces(Bishop.WHITE_BISHOP) * 320;
        int bScore = board.getNumPieces(Queen.BLACK_QUEEN) * 900 + board.getNumPieces(Rook.BLACK_ROOK) * 500 + board.getNumPieces(Knight.BLACK_KNIGHT) * 300 + board.getNumPieces(Bishop.BLACK_BISHOP) * 320;
        return new OrderedPair<Integer, Integer>(wScore, bScore);
    }

    public static int evalMaterial(Board board) {
        int score = 0;
        for (Square sq : Square.allSquares()) {
            Piece p = board.getPiece(sq);
            if (p == null) continue;
            if (p.isWhite()) {
                score += Eval.getPieceValue(p);
                continue;
            }
            score -= Eval.getPieceValue(p);
        }
        return board.getPlayerToMove().equals((Object)Color.WHITE) ? score : -score;
    }

    public static int scale(int score, int material) {
        return score * material / 3140;
    }

    static {
        pieceValMap.put(King.class, Integer.MAX_VALUE);
        pieceValMap.put(Queen.class, 900);
        pieceValMap.put(Rook.class, 500);
        pieceValMap.put(Bishop.class, 320);
        pieceValMap.put(Knight.class, 300);
        pieceValMap.put(Pawn.class, 100);
        BISHOP_PST = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 0, 0, 7, 15, 15, 15, 15, 7, 0, 0, 7, 15, 20, 20, 15, 7, 0, 0, 7, 15, 20, 20, 15, 7, 0, 0, 7, 15, 15, 15, 15, 7, 0, 0, 7, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        KNIGHT_PST = new int[]{-5, -5, -5, -5, -5, -5, -5, -5, -5, 0, 10, 10, 10, 10, 0, -5, -5, 0, 15, 20, 20, 15, 0, -5, -5, 5, 10, 15, 15, 10, 5, -5, -5, 5, 10, 15, 15, 10, 5, -5, -5, 0, 8, 0, 0, 8, 0, -5, -5, 0, 0, 5, 5, 0, 0, -5, -10, -10, -5, -5, -5, -5, -10, -10};
        PAWN_PST = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 30, 30, 30, 30, 30, 30, 30, 30, 14, 14, 14, 18, 18, 14, 14, 14, 7, 7, 7, 10, 10, 7, 7, 7, 5, 5, 5, 7, 7, 5, 5, 5, 3, 3, 3, 5, 5, 3, 3, 3, 0, 0, 0, -3, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ROOK_PST = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0};
        KING_PST = new int[]{-30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -20, -20, -20, -20, -20, -20, -20, -20, -10, -10, -10, -10, -10, -10, -10, -10, 0, 10, 20, -25, 0, -25, 20, 0};
        KING_ENDGAME_PST = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 10, 20, 20, 20, 20, 10, 0, 0, 10, 20, 25, 25, 20, 10, 0, 0, 10, 20, 25, 25, 20, 10, 0, 0, 10, 20, 20, 20, 20, 10, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        QUEEN_PST = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 1, 1, 1, 0, -1, -1, 0, 1, 2, 2, 1, 0, -1, -1, 0, 1, 2, 2, 1, 0, -1, -1, 0, 1, 1, 1, 1, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

