/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board.squares;

import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.Rank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Square {
    public static final int NUM_SQUARES = 64;
    private static final List<Square> SQUARES;
    private static final Map<File, List<Square>> FILE_SQUARES;
    private static final Map<Rank, List<Square>> RANK_SQUARES;
    private final Rank rank;
    private final File file;
    private static Square[][] squares_arr;

    private Square(File file, Rank rank) {
        this.file = file;
        this.rank = rank;
    }

    public Rank rank() {
        return this.rank;
    }

    public File file() {
        return this.file;
    }

    public String toString() {
        return this.file.getLabel() + this.rank.getLabel();
    }

    public boolean isLight() {
        int f;
        int r = this.rank.getValue();
        return r % 2 == (f = this.file.getValue()) % 2;
    }

    public int value() {
        return this.rank.getValue() * 8 + this.file.getValue();
    }

    public static Square valueOf(File file, Rank rank) {
        if (file == null || rank == null) {
            return null;
        }
        return squares_arr[file.getValue()][rank.getValue()];
    }

    public static Square valueOf(int sq) {
        return squares_arr[sq & 7][sq / 8];
    }

    public static List<Square> allSquares() {
        return Collections.unmodifiableList(SQUARES);
    }

    public Square flipVertical() {
        return Square.valueOf(this.file, this.rank.flip());
    }

    public Square flipHorizontal() {
        return Square.valueOf(this.file.flip(), this.rank);
    }

    public static List<Square> fileSquares(File file) {
        return Collections.unmodifiableList(FILE_SQUARES.get((Object)file));
    }

    public static List<Square> rankSquares(Rank rank) {
        return Collections.unmodifiableList(RANK_SQUARES.get((Object)rank));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Square)) {
            return false;
        }
        Square sq = (Square)o;
        return sq.file().equals((Object)this.file) && sq.rank().equals((Object)this.rank);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 13 + this.rank.hashCode();
        hash = hash * 17 + this.file.hashCode();
        return hash;
    }

    static {
        int n;
        int n2;
        Enum[] enumArray;
        ArrayList<Square> mySquares;
        SQUARES = new ArrayList<Square>();
        FILE_SQUARES = new HashMap<File, List<Square>>();
        RANK_SQUARES = new HashMap<Rank, List<Square>>();
        squares_arr = new Square[8][8];
        for (File file : File.values()) {
            mySquares = new ArrayList<Square>();
            enumArray = Rank.values();
            n2 = enumArray.length;
            for (n = 0; n < n2; ++n) {
                Rank rank = enumArray[n];
                mySquares.add(new Square(file, rank));
            }
            FILE_SQUARES.put(file, mySquares);
        }
        for (Enum enum_ : Rank.values()) {
            mySquares = new ArrayList();
            enumArray = File.values();
            n2 = enumArray.length;
            for (n = 0; n < n2; ++n) {
                Enum file = enumArray[n];
                mySquares.add(new Square((File)file, (Rank)enum_));
            }
            RANK_SQUARES.put((Rank)enum_, mySquares);
        }
        for (Enum enum_ : Rank.values()) {
            for (File file : File.values()) {
                HashSet intersection = new HashSet(FILE_SQUARES.get((Object)file));
                intersection.retainAll((Collection)RANK_SQUARES.get(enum_));
                assert (intersection.size() == 1);
                Square sq = (Square)intersection.iterator().next();
                SQUARES.add(sq);
                Square.squares_arr[file.getValue()][((Rank)enum_).getValue()] = sq;
            }
        }
    }
}

