/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.CastlingRights;
import com.jamesswafford.chess4j.board.Magic;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.NorthEast;
import com.jamesswafford.chess4j.board.squares.NorthWest;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.SouthEast;
import com.jamesswafford.chess4j.board.squares.SouthWest;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import java.util.ArrayList;
import java.util.List;

public final class MoveGen {
    private static void addMoves(Board board, Square fromSq, long moveMap, List<Move> moves) {
        while (moveMap != 0L) {
            int toVal = Bitboard.lsb(moveMap);
            Square toSq = Square.valueOf(toVal);
            Piece toPiece = board.getPiece(toSq);
            moves.add(new Move(fromSq, toSq, toPiece));
            moveMap ^= Bitboard.squares[toVal];
        }
    }

    private static void addPawnMove(List<Move> moves, Square fromSq, Square toSq, Piece captured) {
        if (toSq.rank() == Rank.RANK_1 || toSq.rank() == Rank.RANK_8) {
            boolean isWhite = toSq.rank() == Rank.RANK_8;
            moves.add(new Move(fromSq, toSq, captured, isWhite ? Queen.WHITE_QUEEN : Queen.BLACK_QUEEN));
            moves.add(new Move(fromSq, toSq, captured, isWhite ? Rook.WHITE_ROOK : Rook.BLACK_ROOK));
            moves.add(new Move(fromSq, toSq, captured, isWhite ? Bishop.WHITE_BISHOP : Bishop.BLACK_BISHOP));
            moves.add(new Move(fromSq, toSq, captured, isWhite ? Knight.WHITE_KNIGHT : Knight.BLACK_KNIGHT));
        } else {
            moves.add(new Move(fromSq, toSq, captured));
        }
    }

    private static void genBishopMoves(Board board, List<Move> moves, boolean onlyCaps) {
        long pieceMap;
        long l = pieceMap = board.getPlayerToMove() == Color.WHITE ? board.getWhiteBishops() : board.getBlackBishops();
        while (pieceMap != 0L) {
            int sqVal = Bitboard.msb(pieceMap);
            long moveMap = Magic.getBishopMoves(board, sqVal, MoveGen.getTargetSquares(board, true, !onlyCaps));
            MoveGen.addMoves(board, Square.valueOf(sqVal), moveMap, moves);
            pieceMap ^= Bitboard.squares[sqVal];
        }
    }

    private static void genCastlingMoves(Board board, List<Move> moves) {
        Color player = board.getPlayerToMove();
        if (player.isWhite()) {
            Square fromSq = Square.valueOf(File.FILE_E, Rank.RANK_1);
            if (board.canCastle(CastlingRights.WHITE_KINGSIDE)) {
                moves.add(new Move(fromSq, Square.valueOf(File.FILE_G, Rank.RANK_1), null));
            }
            if (board.canCastle(CastlingRights.WHITE_QUEENSIDE)) {
                moves.add(new Move(fromSq, Square.valueOf(File.FILE_C, Rank.RANK_1), null));
            }
        } else {
            Square fromSq = Square.valueOf(File.FILE_E, Rank.RANK_8);
            if (board.canCastle(CastlingRights.BLACK_KINGSIDE)) {
                moves.add(new Move(fromSq, Square.valueOf(File.FILE_G, Rank.RANK_8), null));
            }
            if (board.canCastle(CastlingRights.BLACK_QUEENSIDE)) {
                moves.add(new Move(fromSq, Square.valueOf(File.FILE_C, Rank.RANK_8), null));
            }
        }
    }

    private static void genKingMoves(Board board, List<Move> moves, boolean onlyCaps) {
        Square fromSq = board.getKingSquare(board.getPlayerToMove());
        long moveMap = Bitboard.kingMoves[fromSq.value()] & MoveGen.getTargetSquares(board, true, !onlyCaps);
        MoveGen.addMoves(board, fromSq, moveMap, moves);
        if (!onlyCaps) {
            MoveGen.genCastlingMoves(board, moves);
        }
    }

    private static void genKnightMoves(Board board, List<Move> moves, boolean onlyCaps) {
        long pieceMap;
        long l = pieceMap = board.getPlayerToMove() == Color.WHITE ? board.getWhiteKnights() : board.getBlackKnights();
        while (pieceMap != 0L) {
            int sqVal = Bitboard.msb(pieceMap);
            long moveMap = Bitboard.knightMoves[sqVal] & MoveGen.getTargetSquares(board, true, !onlyCaps);
            MoveGen.addMoves(board, Square.valueOf(sqVal), moveMap, moves);
            pieceMap ^= Bitboard.squares[sqVal];
        }
    }

    public static List<Move> genLegalMoves(Board board) {
        List<Move> pseudoLegalMoves = MoveGen.genPseudoLegalMoves(board);
        ArrayList<Move> legalMoves = new ArrayList<Move>();
        for (Move m : pseudoLegalMoves) {
            board.applyMove(m);
            if (!board.isOpponentInCheck()) {
                legalMoves.add(m);
            }
            board.undoLastMove();
        }
        return legalMoves;
    }

    private static void genPawnMoves(Board board, List<Move> moves, boolean onlyCaps) {
        block12: {
            Pawn captured;
            Square toSq;
            long pmap;
            int toSqVal;
            block11: {
                Pawn captured2;
                Square toSq2;
                long pmap2;
                int toSqVal2;
                long allPieces = board.getWhitePieces() | board.getBlackPieces();
                if (board.getPlayerToMove() != Color.WHITE) break block11;
                long targets = board.getBlackPieces();
                if (board.getEPSquare() != null) {
                    targets |= Bitboard.squares[board.getEPSquare().value()];
                }
                for (pmap2 = (board.getWhitePawns() & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 9 & targets; pmap2 != 0L; pmap2 ^= Bitboard.squares[toSqVal2]) {
                    toSqVal2 = Bitboard.msb(pmap2);
                    toSq2 = Square.valueOf(toSqVal2);
                    captured2 = toSq2 == board.getEPSquare() ? Pawn.BLACK_PAWN : board.getPiece(toSq2);
                    MoveGen.addPawnMove(moves, SouthEast.getInstance().next(toSq2), toSq2, captured2);
                }
                for (pmap2 = (board.getWhitePawns() & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 7 & targets; pmap2 != 0L; pmap2 ^= Bitboard.squares[toSqVal2]) {
                    toSqVal2 = Bitboard.msb(pmap2);
                    toSq2 = Square.valueOf(toSqVal2);
                    captured2 = toSq2 == board.getEPSquare() ? Pawn.BLACK_PAWN : board.getPiece(toSq2);
                    MoveGen.addPawnMove(moves, SouthWest.getInstance().next(toSq2), toSq2, captured2);
                }
                for (pmap2 = (board.getWhitePawns() & Bitboard.ranks[Rank.RANK_7.getValue()]) >> 8 & (allPieces ^ 0xFFFFFFFFFFFFFFFFL); pmap2 != 0L; pmap2 ^= Bitboard.squares[toSqVal2]) {
                    toSqVal2 = Bitboard.msb(pmap2);
                    toSq2 = Square.valueOf(toSqVal2);
                    MoveGen.addPawnMove(moves, South.getInstance().next(toSq2), toSq2, null);
                }
                if (onlyCaps) break block12;
                for (pmap2 = (board.getWhitePawns() & (Bitboard.ranks[Rank.RANK_7.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 8 & (allPieces ^ 0xFFFFFFFFFFFFFFFFL); pmap2 != 0L; pmap2 ^= Bitboard.squares[toSqVal2]) {
                    toSqVal2 = Bitboard.msb(pmap2);
                    toSq2 = Square.valueOf(toSqVal2);
                    moves.add(new Move(South.getInstance().next(toSq2), toSq2, null));
                    if (toSq2.rank() != Rank.RANK_3 || board.getPiece(North.getInstance().next(toSq2)) != null) continue;
                    moves.add(new Move(South.getInstance().next(toSq2), North.getInstance().next(toSq2), null));
                }
                break block12;
            }
            long targets = board.getWhitePieces();
            if (board.getEPSquare() != null) {
                targets |= Bitboard.squares[board.getEPSquare().value()];
            }
            for (pmap = (board.getBlackPawns() & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 7 & targets; pmap != 0L; pmap ^= Bitboard.squares[toSqVal]) {
                toSqVal = Bitboard.lsb(pmap);
                toSq = Square.valueOf(toSqVal);
                captured = toSq == board.getEPSquare() ? Pawn.WHITE_PAWN : board.getPiece(toSq);
                MoveGen.addPawnMove(moves, NorthEast.getInstance().next(toSq), toSq, captured);
            }
            for (pmap = (board.getBlackPawns() & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 9 & targets; pmap != 0L; pmap ^= Bitboard.squares[toSqVal]) {
                toSqVal = Bitboard.lsb(pmap);
                toSq = Square.valueOf(toSqVal);
                captured = toSq == board.getEPSquare() ? Pawn.WHITE_PAWN : board.getPiece(toSq);
                MoveGen.addPawnMove(moves, NorthWest.getInstance().next(toSq), toSq, captured);
            }
            for (pmap = (board.getBlackPawns() & Bitboard.ranks[Rank.RANK_2.getValue()]) << 8 & (allPieces ^ 0xFFFFFFFFFFFFFFFFL); pmap != 0L; pmap ^= Bitboard.squares[toSqVal]) {
                toSqVal = Bitboard.lsb(pmap);
                toSq = Square.valueOf(toSqVal);
                MoveGen.addPawnMove(moves, North.getInstance().next(toSq), toSq, null);
            }
            if (!onlyCaps) {
                for (pmap = (board.getBlackPawns() & (Bitboard.ranks[Rank.RANK_2.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 8 & (allPieces ^ 0xFFFFFFFFFFFFFFFFL); pmap != 0L; pmap ^= Bitboard.squares[toSqVal]) {
                    toSqVal = Bitboard.lsb(pmap);
                    toSq = Square.valueOf(toSqVal);
                    moves.add(new Move(North.getInstance().next(toSq), toSq, null));
                    if (toSq.rank() != Rank.RANK_6 || board.getPiece(South.getInstance().next(toSq)) != null) continue;
                    moves.add(new Move(North.getInstance().next(toSq), South.getInstance().next(toSq), null));
                }
            }
        }
    }

    public static List<Move> genPseudoLegalMoves(Board board) {
        return MoveGen.genPseudoLegalMoves(board, false);
    }

    public static List<Move> genPseudoLegalMoves(Board board, boolean onlyCapsPromos) {
        ArrayList<Move> moves = new ArrayList<Move>(100);
        MoveGen.genPawnMoves(board, moves, onlyCapsPromos);
        MoveGen.genKnightMoves(board, moves, onlyCapsPromos);
        MoveGen.genBishopMoves(board, moves, onlyCapsPromos);
        MoveGen.genRookMoves(board, moves, onlyCapsPromos);
        MoveGen.genQueenMoves(board, moves, onlyCapsPromos);
        MoveGen.genKingMoves(board, moves, onlyCapsPromos);
        return moves;
    }

    private static void genQueenMoves(Board board, List<Move> moves, boolean onlyCaps) {
        long pieceMap;
        long l = pieceMap = board.getPlayerToMove() == Color.WHITE ? board.getWhiteQueens() : board.getBlackQueens();
        while (pieceMap != 0L) {
            int sqVal = Bitboard.msb(pieceMap);
            long moveMap = Magic.getQueenMoves(board, sqVal, MoveGen.getTargetSquares(board, true, !onlyCaps));
            MoveGen.addMoves(board, Square.valueOf(sqVal), moveMap, moves);
            pieceMap ^= Bitboard.squares[sqVal];
        }
    }

    private static void genRookMoves(Board board, List<Move> moves, boolean onlyCaps) {
        long pieceMap;
        long l = pieceMap = board.getPlayerToMove() == Color.WHITE ? board.getWhiteRooks() : board.getBlackRooks();
        while (pieceMap != 0L) {
            int sqVal = Bitboard.msb(pieceMap);
            long moveMap = Magic.getRookMoves(board, sqVal, MoveGen.getTargetSquares(board, true, !onlyCaps));
            MoveGen.addMoves(board, Square.valueOf(sqVal), moveMap, moves);
            pieceMap ^= Bitboard.squares[sqVal];
        }
    }

    private static long getTargetSquares(Board board, boolean caps, boolean noncaps) {
        long targets = 0L;
        if (caps) {
            long l = targets = board.getPlayerToMove() == Color.WHITE ? board.getBlackPieces() : board.getWhitePieces();
        }
        if (noncaps) {
            targets |= (board.getWhitePieces() | board.getBlackPieces()) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return targets;
    }

    private MoveGen() {
    }
}

