/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.MappableItemStackWrapper;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityIronChestRenderer
extends TileEntitySpecialRenderer {
    private static final Map<MappableItemStackWrapper, Integer> renderList = new HashMap<MappableItemStackWrapper, Integer>();
    private static final Map<IronChestType, ResourceLocation> locations;
    private final Random random;
    private final RenderItem itemRenderer;
    private static final float[][] shifts;
    private final ModelChest model = new ModelChest();

    public TileEntityIronChestRenderer() {
        this.random = new Random();
        RenderBlocks renderBlocks = new RenderBlocks();
        this.itemRenderer = new RenderItem(){

            public byte getMiniBlockCount(ItemStack stack, byte original) {
                return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 15) + 1));
            }

            public byte getMiniItemCount(ItemStack stack, byte original) {
                return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 7) + 1));
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public void render(TileEntityIronChest tile, double x, double y, double z, float partialTick) {
        if (tile == null) {
            return;
        }
        int facing = 3;
        IronChestType type = tile.getType();
        if (tile.func_145830_o()) {
            facing = tile.getFacing();
            type = tile.getType();
            int typ = tile.func_145831_w().func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            type = IronChestType.values()[typ];
        }
        this.func_147499_a(locations.get((Object)type));
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int k = 0;
        if (facing == 2) {
            k = 180;
        }
        if (facing == 3) {
            k = 0;
        }
        if (facing == 4) {
            k = 90;
        }
        if (facing == 5) {
            k = -90;
        }
        GL11.glRotatef((float)k, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidangle = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTick;
        lidangle = 1.0f - lidangle;
        lidangle = 1.0f - lidangle * lidangle * lidangle;
        this.model.field_78234_a.field_78795_f = -(lidangle * 3.141593f / 2.0f);
        this.model.func_78231_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type.isTransparent() && tile.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            if (tile.getTopItemStacks()[1] == null) {
                shift = 8;
                blockScale = 0.85f;
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            EntityItem customitem = new EntityItem(this.field_147501_a.field_147550_f);
            customitem.field_70290_d = 0.0f;
            for (ItemStack item : tile.getTopItemStacks()) {
                if (shift > shifts.length) break;
                if (item == null) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)shiftX, (float)shiftY, (float)shiftZ);
                GL11.glRotatef((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partialTick) {
        this.render((TileEntityIronChest)tileentity, x, y, z, partialTick);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IronChestType typ : IronChestType.values()) {
            builder.put((Object)typ, (Object)new ResourceLocation("ironchest", "textures/model/" + typ.getModelTexture()));
        }
        locations = builder.build();
        shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    }
}

