/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.value;

import com.github.lunatrius.ingameinfo.value.ValueComplex;
import com.github.lunatrius.ingameinfo.value.registry.ValueRegistry;
import java.util.Locale;

public abstract class ValueMath
extends ValueComplex {
    @Override
    public boolean isValidSize() {
        return this.values.size() == 2;
    }

    public static void register() {
        ValueRegistry.INSTANCE.register(new ValueAdd().setName("add"));
        ValueRegistry.INSTANCE.register(new ValueSub().setName("sub"));
        ValueRegistry.INSTANCE.register(new ValueMul().setName("mul"));
        ValueRegistry.INSTANCE.register(new ValueDiv().setName("div"));
        ValueRegistry.INSTANCE.register(new ValueRound().setName("round"));
        ValueRegistry.INSTANCE.register(new ValueMod().setName("mod").setAliases("modulo"));
        ValueRegistry.INSTANCE.register(new ValueModi().setName("modi").setAliases("modint", "moduloi", "moduloint"));
        ValueRegistry.INSTANCE.register(new ValuePercent().setName("pct").setAliases("percent", "percentage"));
    }

    public static class ValueAdd
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                int arg0 = this.getIntValue(0);
                int arg1 = this.getIntValue(1);
                return String.valueOf(arg0 + arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = this.getDoubleValue(0);
                    double arg1 = this.getDoubleValue(1);
                    return String.valueOf(arg0 + arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
    }

    public static class ValueSub
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                int arg0 = this.getIntValue(0);
                int arg1 = this.getIntValue(1);
                return String.valueOf(arg0 - arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = this.getDoubleValue(0);
                    double arg1 = this.getDoubleValue(1);
                    return String.valueOf(arg0 - arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
    }

    public static class ValueMul
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                int arg0 = this.getIntValue(0);
                int arg1 = this.getIntValue(1);
                return String.valueOf(arg0 * arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = this.getDoubleValue(0);
                    double arg1 = this.getDoubleValue(1);
                    return String.valueOf(arg0 * arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
    }

    public static class ValueDiv
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                double arg1 = this.getDoubleValue(1);
                return String.valueOf(arg0 / arg1);
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class ValueRound
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                int arg1 = this.getIntValue(1);
                double dec = Math.pow(10.0, arg1);
                if (arg1 > 0) {
                    return String.format(Locale.ENGLISH, "%." + arg1 + "f", arg0);
                }
                return String.valueOf((int)((double)Math.round(arg0 * dec) / dec));
            }
            catch (Exception e2) {
                return "0";
            }
        }
    }

    public static class ValueMod
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                double arg1 = this.getDoubleValue(1);
                return String.valueOf((double)Math.round(arg0 % arg1 * 1.0E7) / 1.0E7);
            }
            catch (Exception e2) {
                return "0";
            }
        }
    }

    public static class ValueModi
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                int arg0 = this.getIntValue(0);
                int arg1 = this.getIntValue(1);
                return String.valueOf(arg0 % arg1);
            }
            catch (Exception e2) {
                return "0";
            }
        }
    }

    public static class ValuePercent
    extends ValueMath {
        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                double arg1 = this.getDoubleValue(1);
                return String.valueOf(arg0 / arg1 * 100.0);
            }
            catch (Exception e) {
                return "0";
            }
        }
    }
}

