/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.client.gui.InfoText;
import com.github.lunatrius.ingameinfo.handler.ClientConfigurationHandler;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.parser.json.JsonParser;
import com.github.lunatrius.ingameinfo.parser.text.TextParser;
import com.github.lunatrius.ingameinfo.parser.xml.XmlParser;
import com.github.lunatrius.ingameinfo.printer.IPrinter;
import com.github.lunatrius.ingameinfo.printer.json.JsonPrinter;
import com.github.lunatrius.ingameinfo.printer.text.TextPrinter;
import com.github.lunatrius.ingameinfo.printer.xml.XmlPrinter;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.value.Value;
import com.github.lunatrius.ingameinfo.value.ValueComplex;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class InGameInfoCore {
    public static final InGameInfoCore INSTANCE = new InGameInfoCore();
    private IParser parser;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private File configDirectory = null;
    private File configFile = null;
    private String baseConfigFileName;
    private final Map<Alignment, List<List<Value>>> format = new HashMap<Alignment, List<List<Value>>>();
    public ScaledResolution scaledResolution;
    public int scaledWidth;
    public int scaledHeight;
    private boolean needsRefresh;

    private InGameInfoCore() {
        this.scaledResolution = new ScaledResolution(this.minecraft, this.minecraft.field_71443_c, this.minecraft.field_71440_d);
        this.needsRefresh = true;
    }

    public void setConfigDirectory(File directory) {
        this.configDirectory = directory;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigFileWithLocale() {
        if (this.baseConfigFileName != null) {
            this.setConfigFileWithLocale(this.baseConfigFileName);
        }
    }

    public void setConfigFileWithLocale(String filename) {
        String userLang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        String baseName = filename.split("\\.")[0];
        String extension = filename.split("\\.").length > 1 ? filename.split("\\.")[1] : "";
        String localeAwareFileName = baseName + "_" + userLang + "." + extension;
        if (new File(this.configDirectory, localeAwareFileName).isFile()) {
            this.setConfigFile(localeAwareFileName, filename);
        } else {
            this.setConfigFile(filename);
        }
    }

    public boolean setConfigFile(String filename) {
        return this.setConfigFile(filename, filename);
    }

    public boolean setConfigFile(String filename, String baseName) {
        File file = new File(this.configDirectory, filename);
        if (file.exists()) {
            this.configFile = file;
            this.baseConfigFileName = baseName;
            if (filename.endsWith(".xml")) {
                this.parser = new XmlParser();
            } else if (filename.endsWith(".json")) {
                this.parser = new JsonParser();
            } else if (filename.endsWith(".txt")) {
                this.parser = new TextParser();
            }
            return true;
        }
        this.configFile = null;
        this.parser = new XmlParser();
        this.baseConfigFileName = null;
        return false;
    }

    public void onTickClient() {
        float scale = ClientConfigurationHandler.Scale / 10.0f;
        this.scaledWidth = (int)((float)this.scaledResolution.func_78326_a() / scale);
        this.scaledHeight = (int)((float)this.scaledResolution.func_78328_b() / scale);
        Tag.update();
        if (this.needsRefresh) {
            this.refreshInfoTexts();
            this.needsRefresh = false;
        }
        for (Alignment alignment : Alignment.VALUES) {
            int lastActiveIndex = 0;
            for (InfoText infoText : alignment.getLines()) {
                infoText.update(lastActiveIndex);
                if (!infoText.isActive()) continue;
                ++lastActiveIndex;
            }
        }
        ValueComplex.ValueFile.tick();
    }

    public void onTickRender(ScaledResolution resolution) {
        this.scaledResolution = resolution;
        GL11.glPushMatrix();
        float scale = ClientConfigurationHandler.Scale / 10.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        for (Alignment alignment : Alignment.VALUES) {
            for (InfoText info : alignment.getLines()) {
                info.draw();
            }
        }
        GL11.glPopMatrix();
    }

    public boolean loadConfig(String filename) {
        return this.setConfigFile(filename) && this.reloadConfig();
    }

    public boolean reloadConfig() {
        this.needsRefresh = true;
        this.format.clear();
        if (this.parser == null) {
            return false;
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return false;
        }
        if (this.parser.load(inputStream) && this.parser.parse(this.format)) {
            return true;
        }
        this.format.clear();
        return false;
    }

    private InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            if (this.configFile != null && this.configFile.exists()) {
                Reference.logger.debug("Loading file config...");
                inputStream = new FileInputStream(this.configFile);
            } else {
                Reference.logger.debug("Loading default config...");
                ResourceLocation resourceLocation = new ResourceLocation("ingameinfo", "InGameInfo.xml");
                IResource resource = this.minecraft.func_110442_L().func_110536_a(resourceLocation);
                inputStream = resource.func_110527_b();
            }
        }
        catch (Exception e) {
            Reference.logger.error("", (Throwable)e);
        }
        return inputStream;
    }

    public void refreshInfoTexts() {
        for (Alignment alignment : Alignment.VALUES) {
            List<List<Value>> lines = this.format.get((Object)alignment);
            alignment.getLines().clear();
            if (lines == null) continue;
            for (List<Value> line : lines) {
                alignment.getLines().add(new InfoText(alignment, line));
            }
        }
    }

    public boolean saveConfig(String filename) {
        IPrinter printer = null;
        File file = new File(this.configDirectory, filename);
        if (filename.endsWith(".xml")) {
            printer = new XmlPrinter();
        } else if (filename.endsWith(".json")) {
            printer = new JsonPrinter();
        } else if (filename.endsWith(".txt")) {
            printer = new TextPrinter();
        }
        return printer != null && printer.print(file, this.format);
    }

    public void moveConfig(File directory, String fileName) {
        File originalFile = new File(directory, fileName);
        if (!originalFile.isFile()) {
            return;
        }
        Path source = originalFile.toPath();
        Path subdirectory = directory.toPath().resolve("InGameInfoXML");
        Path destination = subdirectory.resolve(fileName).normalize();
        if (!destination.startsWith(directory.toPath())) {
            throw new RuntimeException("Failed to move file: " + destination);
        }
        try {
            if (!subdirectory.toFile().isDirectory()) {
                Files.createDirectory(subdirectory, new FileAttribute[0]);
            }
            destination.toFile().createNewFile();
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

