/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class TagTime
extends Tag {
    @Override
    public String getCategory() {
        return "time";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new MinecraftTotal().setName("worldtimetotal"));
        TagRegistry.INSTANCE.register(new MinecraftDay().setName("day"));
        TagRegistry.INSTANCE.register(new MinecraftHour().setName("mctimeh"));
        TagRegistry.INSTANCE.register(new MinecraftMinute().setName("mctimem"));
        TagRegistry.INSTANCE.register(new Minecraft24().setName("mctime24").setAliases("mctime"));
        TagRegistry.INSTANCE.register(new Minecraft12().setName("mctime12"));
        TagRegistry.INSTANCE.register(new Real24().setName("rltime24").setAliases("rltime"));
        TagRegistry.INSTANCE.register(new Real12().setName("rltime12"));
    }

    public static class Real12
    extends TagTime {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm a");

        @Override
        public String getValue() {
            return this.dateFormat.format(new Date());
        }
    }

    public static class Real24
    extends TagTime {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");

        @Override
        public String getValue() {
            return this.dateFormat.format(new Date());
        }
    }

    public static class Minecraft12
    extends TagTime {
        @Override
        public String getValue() {
            long time = world.func_72820_D();
            long hour = (time / 1000L + 6L) % 24L;
            long minute = time % 1000L * 60L / 1000L;
            String ampm = "AM";
            if (hour >= 12L) {
                hour -= 12L;
                ampm = "PM";
            }
            if (hour == 0L) {
                hour += 12L;
            }
            return String.format(Locale.ENGLISH, "%02d:%02d %s", hour, minute, ampm);
        }
    }

    public static class Minecraft24
    extends TagTime {
        @Override
        public String getValue() {
            long time = world.func_72820_D();
            long hour = (time / 1000L + 6L) % 24L;
            long minute = time % 1000L * 60L / 1000L;
            return String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
        }
    }

    public static class MinecraftMinute
    extends TagTime {
        @Override
        public String getValue() {
            long minute = world.func_72820_D() % 1000L * 60L / 1000L;
            return String.format(Locale.ENGLISH, "%02d", minute);
        }
    }

    public static class MinecraftHour
    extends TagTime {
        @Override
        public String getValue() {
            long hour = (world.func_72820_D() / 1000L + 6L) % 24L;
            return String.format(Locale.ENGLISH, "%02d", hour);
        }
    }

    public static class MinecraftDay
    extends TagTime {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%d", world.func_72820_D() / 24000L);
        }
    }

    public static class MinecraftTotal
    extends TagTime {
        @Override
        public String getValue() {
            long seconds = world.func_82737_E() / 20L;
            long dd = seconds / 86400L;
            long hh = seconds / 3600L % 24L;
            long mm = seconds / 60L % 60L;
            long ss = seconds % 60L;
            if (dd >= 1L) {
                return String.format("%dd %02d:%02d:%02d", dd, hh, mm, ss);
            }
            return String.format("%02d:%02d:%02d", hh, mm, ss);
        }
    }
}

