/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.restriction;

import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.items.MetalPattern;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.items.Pattern;
import tconstruct.weaponry.TinkerWeaponry;

public final class RestrictionHelper {
    public static Map<String, ItemMetaWrapper> configNameToPattern = new HashMap<String, ItemMetaWrapper>();
    public static Map<String, ItemMetaWrapper> configNameToCast = new HashMap<String, ItemMetaWrapper>();
    public static Map<ItemMetaWrapper, List<ToolMaterial>> patternMaterialLookup = new HashMap<ItemMetaWrapper, List<ToolMaterial>>();
    public static Map<ItemMetaWrapper, List<CustomMaterial>> patternCustomMaterialLookup = new HashMap<ItemMetaWrapper, List<CustomMaterial>>();
    public static final String[] patternNames = new String[]{"ingot", "rod", "pickaxe", "shovel", "axe", "swordblade", "largeguard", "mediumguard", "crossbar", "binding", "frypan", "sign", "knifeblade", "chisel", "largerod", "toughbinding", "largeplate", "broadaxe", "scythe", "excavator", "largeblade", "hammerhead", "fullguard", "bowstring", "fletching", "arrowhead"};
    public static final String[] patternNamesWeaponry = new String[]{"shuriken", "crossbowlimb", "crossbowbody", "bowlimb"};
    public static final String[] defaultRestrictions = new String[0];
    public static final String[] defaultAllowed = new String[]{"Wood:rod", "Wood:crossbar", "Wood:binding", "Wood:sign", "Wood:bowlimb", "Wood:crossbowlimb", "Wood:crossbowbody", "Flint:pickaxe", "Flint:shovel", "Flint:axe", "Flint:knifeblade", "Flint:arrowhead", "Flint:shuriken", "Bone:rod", "Bone:shovel", "Bone:axe", "Bone:crossbar", "Bone:knifeblade", "Bone:arrowhead", "Bone:bowlimb", "Bone:crossbowlimb", "Bone:crossbowbody", "Cactus:rod", "Cactus:binding", "Cactus:knifeblade", "Cactus:shuriken", "Paper:rod", "Paper:binding", "Slime:rod", "Slime:sign", "Slime:binding", "Slime:bowlimb", "Slime:crossbowlimb", "Slime:crossbowbody", "BlueSlime:rod", "BlueSlime:binding", "BlueSlime:bowlimb", "BlueSlime:crossbowlimb", "BlueSlime:crossbowbody", "Netherrack:rod", "Netherrack:pickaxe", "Netherrack:shovel", "Netherrack:axe", "Netherrack:largeguard", "Netherrack:mediumguard", "Netherrack:crossbar", "Netherrack:binding", "Netherrack:sign", "Netherrack:largerod", "Netherrack:toughbinding", "Netherrack:largeplate", "Netherrack:broadaxe", "Netherrack:scythe", "Netherrack:excavator", "Netherrack:fullguard", "Netherrack:arrowhead", "Netherrack:crossbowbody", "Obsidian:rod", "Obsidian:pickaxe", "Obsidian:shovel", "Obsidian:axe", "Obsidian:largeguard", "Obsidian:mediumguard", "Obsidian:crossbar", "Obsidian:binding", "Obsidian:sign", "Obsidian:largerod", "Obsidian:toughbinding", "Obsidian:largeplate", "Obsidian:broadaxe", "Obsidian:scythe", "Obsidian:excavator", "Obsidian:hammerhead", "Obsidian:fullguard", "Obsidian:arrowhead", "Obsidian:crossbowbody", "Obsidian:shuriken"};

    private RestrictionHelper() {
    }

    public static boolean isRestricted(ItemStack pattern, ToolMaterial material) {
        boolean restricted = true;
        List<ToolMaterial> matIDs = patternMaterialLookup.get(new ItemMetaWrapper(pattern));
        if (matIDs != null) {
            for (ToolMaterial mat : matIDs) {
                if (!mat.materialName.equals(material.materialName)) continue;
                restricted = false;
                break;
            }
        }
        return restricted;
    }

    public static int getPatternIndexFromName(String name) {
        for (int i = 0; i < patternNames.length; ++i) {
            if (!patternNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static List<ToolMaterial> getPatternMaterials(ItemStack pattern) {
        return patternMaterialLookup.get(new ItemMetaWrapper(pattern));
    }

    public static List<CustomMaterial> getPatternCustomMaterials(ItemStack pattern) {
        return patternCustomMaterialLookup.get(new ItemMetaWrapper(pattern));
    }

    public static void addRestriction(ItemMetaWrapper key, ToolMaterial material) {
        List<ToolMaterial> materials = patternMaterialLookup.get(key);
        if (materials == null) {
            Log.debug(String.format("Couldn't find lookup entry for %s:%d", key.item.func_77658_a(), key.meta));
            return;
        }
        ListIterator<ToolMaterial> iter = materials.listIterator();
        while (iter.hasNext()) {
            ToolMaterial mat = iter.next();
            if (!mat.materialName.equals(material.materialName)) continue;
            iter.remove();
        }
    }

    public static void clearRecipes(ToolMaterial material) {
        for (List<ToolMaterial> mats : patternMaterialLookup.values()) {
            ListIterator<ToolMaterial> iter = mats.listIterator();
            while (iter.hasNext()) {
                ToolMaterial mat = iter.next();
                if (!mat.materialName.equals(material.materialName)) continue;
                iter.remove();
            }
        }
    }

    public static boolean addAllowed(ItemMetaWrapper key, ToolMaterial material) {
        List<ToolMaterial> materials;
        boolean allowed;
        if (key.item instanceof MetalPattern) {
            allowed = false;
            for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
                if (recipe.cast == null || recipe.output == null || !(recipe.output.func_77973_b() instanceof IToolPart)) continue;
                int matID = ((IToolPart)recipe.output.func_77973_b()).getMaterialID(recipe.output);
                if (key.item != recipe.cast.func_77973_b() || key.meta.intValue() != recipe.cast.func_77960_j() || !TConstructRegistry.getMaterial((int)matID).materialName.equals(material.materialName)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return false;
            }
        } else if (key.item instanceof Pattern) {
            allowed = false;
            for (List entry : TConstructRegistry.patternPartMapping.keySet()) {
                Item pattern = (Item)entry.get(0);
                int meta = (Integer)entry.get(1);
                int matID = (Integer)entry.get(2);
                if (key.item != pattern || key.meta != meta || !TConstructRegistry.getMaterial((int)matID).materialName.equals(material.materialName)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return false;
            }
        }
        if ((materials = patternMaterialLookup.get(key)) == null) {
            Log.debug(String.format("Couldn't find lookup entry for %s:%d", key.item.func_77658_a(), key.meta));
            return false;
        }
        for (ToolMaterial mat : materials) {
            if (!mat.materialName.equals(material.materialName)) continue;
            return true;
        }
        materials.add(material);
        return true;
    }

    public static void init() {
        RestrictionHelper.initPatternParts();
        RestrictionHelper.initCastParts();
    }

    private static void initPatternParts() {
        Log.debug("Loading tool pattern combinations");
        for (Map.Entry entry : TConstructRegistry.patternPartMapping.entrySet()) {
            Item pattern = (Item)((List)entry.getKey()).get(0);
            Integer meta = (Integer)((List)entry.getKey()).get(1);
            Integer matID = (Integer)((List)entry.getKey()).get(2);
            String name = pattern == TinkerTools.woodPattern && meta <= patternNames.length ? patternNames[meta] : (pattern == TinkerWeaponry.woodPattern && meta <= patternNamesWeaponry.length ? patternNamesWeaponry[meta] : new ItemStack(pattern, 1, meta.intValue()).func_77977_a());
            if (name == null || name.isEmpty()) continue;
            ItemMetaWrapper im = configNameToPattern.get(name);
            if (im == null) {
                im = new ItemMetaWrapper(pattern, meta);
                configNameToPattern.put(name, im);
            }
            if (!patternMaterialLookup.containsKey(im)) {
                patternMaterialLookup.put(im, new LinkedList());
            }
            patternMaterialLookup.get(im).add(TConstructRegistry.getMaterial((int)matID));
        }
        for (CustomMaterial mat : TConstructRegistry.customMaterials) {
            ItemMetaWrapper im;
            if (mat instanceof BowstringMaterial) {
                im = configNameToPattern.get("bowstring");
                if (im == null) {
                    im = new ItemMetaWrapper(TinkerTools.woodPattern, Integer.valueOf(23));
                    configNameToPattern.put("bowstring", im);
                }
                if (!patternCustomMaterialLookup.containsKey(im)) {
                    patternCustomMaterialLookup.put(im, new LinkedList());
                }
                patternCustomMaterialLookup.get(im).add(mat);
            }
            if (!(mat instanceof FletchingMaterial)) continue;
            im = configNameToPattern.get("fletching");
            if (im == null) {
                im = new ItemMetaWrapper(TinkerTools.woodPattern, Integer.valueOf(24));
                configNameToPattern.put("fletching", im);
            }
            if (!patternCustomMaterialLookup.containsKey(im)) {
                patternCustomMaterialLookup.put(im, new LinkedList());
            }
            patternCustomMaterialLookup.get(im).add(mat);
        }
    }

    private static void initCastParts() {
        Log.debug("Loading tool casting combinations");
        for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
            if (recipe.cast == null || recipe.output == null || !(recipe.output.func_77973_b() instanceof IToolPart)) continue;
            Item pattern = recipe.cast.func_77973_b();
            int meta = recipe.cast.func_77960_j();
            int matID = ((IToolPart)recipe.output.func_77973_b()).getMaterialID(recipe.output);
            String name = pattern == TinkerSmeltery.metalPattern && meta <= patternNames.length ? patternNames[meta] : (pattern == TinkerWeaponry.metalPattern && meta <= patternNamesWeaponry.length ? patternNamesWeaponry[meta] : new ItemStack(pattern, 1, meta).func_77977_a());
            if (name == null || name.isEmpty()) continue;
            ItemMetaWrapper im = configNameToCast.get(name);
            if (im == null) {
                im = new ItemMetaWrapper(pattern, Integer.valueOf(meta));
                configNameToCast.put(name, im);
            }
            if (!patternMaterialLookup.containsKey(im)) {
                patternMaterialLookup.put(im, new LinkedList());
            }
            patternMaterialLookup.get(im).add(TConstructRegistry.getMaterial((int)matID));
        }
    }

    public static void sortEntries() {
        Comparator<ToolMaterial> comparator = new Comparator<ToolMaterial>(){

            @Override
            public int compare(ToolMaterial m1, ToolMaterial m2) {
                Integer id1 = null;
                Integer id2 = null;
                for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
                    if (entry.getValue() == m1) {
                        id1 = (Integer)entry.getKey();
                    }
                    if (entry.getValue() != m2) continue;
                    id2 = (Integer)entry.getKey();
                }
                if (id1 == null || id2 == null) {
                    return 0;
                }
                return id1 - id2;
            }
        };
        for (List<ToolMaterial> mats : patternMaterialLookup.values()) {
            Collections.sort(mats, comparator);
        }
    }
}

