/*
 * Decompiled with CFR 0.152.
 */
package info.inpureprojects.core;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import info.inpureprojects.core.API.Events.EventPreloaderRegister;
import info.inpureprojects.core.API.Events.INpureEventBus;
import info.inpureprojects.core.API.IINpureSubmodule;
import info.inpureprojects.core.API.IINpureSubmoduleExpanded;
import info.inpureprojects.core.API.IUpdateCheck;
import info.inpureprojects.core.API.PreloaderAPI;
import info.inpureprojects.core.API.Utils.LogWrapper;
import info.inpureprojects.core.Config.PropertiesHolder;
import info.inpureprojects.core.NEI.gtfoMicroblocks.Commands.CommandReload;
import info.inpureprojects.core.Preloader.ModuleManager;
import info.inpureprojects.core.Proxy.Proxy;
import info.inpureprojects.core.Updater.UpdateManager;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="inpure|core", name="INpureCore", version="1.7.10R1.0.0B9", dependencies="after:ExtraUtilities")
public class INpureCore {
    @Mod.Instance(value="inpure|core")
    public static INpureCore instance;
    public static ArrayList<IINpureSubmodule> modules;
    @SidedProxy(clientSide="info.inpureprojects.core.Proxy.ProxyClient", serverSide="info.inpureprojects.core.Proxy.ProxyCommon")
    public static Proxy proxy;
    public static PropertiesHolder properties;
    public static LogWrapper log;
    public static ArrayList<UpdateManager> managers;
    public static File dir;

    public static void registerManager(IUpdateCheck check) {
        managers.add(new UpdateManager(check));
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        PreloaderAPI.preLoaderEvents.register(this);
        log = new LogWrapper(evt.getModLog(), null);
        properties = new PropertiesHolder(new Configuration(new File(new File(evt.getModConfigurationDirectory(), "INpureProjects/INpureCore"), "INpureCore.cfg")));
        proxy.client();
        proxy.setupAPI();
        PreloaderAPI.preLoaderEvents.post((Object)new EventPreloaderRegister());
        for (String string : ModuleManager.modules) {
            if (!INpureCore.properties.silence_submodule_logging) {
                proxy.print("Constructing submodule " + string);
            }
            try {
                IINpureSubmodule m = (IINpureSubmodule)Class.forName(string).newInstance();
                modules.add(m);
            }
            catch (Throwable t) {
                proxy.severe("Failed to load submodule " + string + "!");
                t.printStackTrace();
            }
        }
        dir = new File(evt.getModConfigurationDirectory(), "INpureProjects");
        for (IINpureSubmodule iINpureSubmodule : modules) {
            if (!INpureCore.properties.silence_submodule_logging) {
                proxy.print("Processing preinit event for submodule " + iINpureSubmodule.getClass().getName());
            }
            iINpureSubmodule.pre(dir);
        }
    }

    @INpureEventBus.INpureSubscribe
    public void registerModules(EventPreloaderRegister evt) {
        if (Loader.isModLoaded((String)"inpure|core") && INpureCore.properties.updateCheck) {
            PreloaderAPI.modules.register("info.inpureprojects.core.Updater.UpdateModule");
        }
        if (INpureCore.properties.extract_scripts) {
            PreloaderAPI.modules.register("info.inpureprojects.core.Scripting.ScriptExtractor");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        for (IINpureSubmodule s : modules) {
            if (!INpureCore.properties.silence_submodule_logging) {
                proxy.print("Processing init event for submodule " + s.getClass().getName());
            }
            s.init();
        }
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent evt) {
        for (IINpureSubmodule s : modules) {
            if (!INpureCore.properties.silence_submodule_logging) {
                proxy.print("Processing postinit event for submodule " + s.getClass().getName());
            }
            s.post();
        }
        for (UpdateManager m : managers) {
            m.runCheck();
        }
    }

    @Mod.EventHandler
    public void onServer(FMLServerAboutToStartEvent evt) {
        proxy.onServerStartClient();
        for (IINpureSubmodule s : modules) {
            if (!(s instanceof IINpureSubmoduleExpanded)) continue;
            if (!INpureCore.properties.silence_submodule_logging) {
                proxy.print("Processing ServerAboutToStart event for submodule " + s.getClass().getName());
            }
            ((IINpureSubmoduleExpanded)s).onServerAboutToStart();
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandReload());
    }

    static {
        modules = new ArrayList();
        managers = new ArrayList();
    }
}

