/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.IRedstoneConsumer;
import shedar.mods.ic2.nuclearcontrol.IRotation;
import shedar.mods.ic2.nuclearcontrol.IScreenPart;
import shedar.mods.ic2.nuclearcontrol.ISlotItemFilter;
import shedar.mods.ic2.nuclearcontrol.ITextureHelper;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IPanelMultiCard;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemUpgrade;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.panel.Screen;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;
import shedar.mods.ic2.nuclearcontrol.utils.RedstoneHelper;

public class TileEntityInfoPanel
extends TileEntity
implements ISlotItemFilter,
INetworkDataProvider,
INetworkUpdateListener,
INetworkClientTileEntityEventListener,
IWrenchable,
IRedstoneConsumer,
ITextureHelper,
IScreenPart,
IRotation,
IInventory {
    private static final int[] COLORS_HEX = new int[]{0, 15283509, 8577798, 7351060, 2047207, 9379818, 2086889, 0xCBCBCB, 0x222222, 15074933, 2090787, 15322143, 437988, 11536099, 15169055};
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LEFT = 1;
    public static final int BORDER_RIGHT = 2;
    public static final int BORDER_TOP = 4;
    public static final int BORDER_BOTTOM = 8;
    public static final int DISPLAY_DEFAULT = Integer.MAX_VALUE;
    private static final byte SLOT_CARD = 0;
    private static final byte SLOT_UPGRADE_RANGE = 1;
    private static final byte SLOT_UPGRADE_COLOR = 2;
    private static final byte SLOT_UPGRADE_WEB = 2;
    private static final byte LOCATION_RANGE = 8;
    protected int updateTicker;
    protected int dataTicker;
    protected int tickRate;
    protected int dt;
    protected int updatedataTicker;
    public boolean init;
    public ItemStack[] inventory;
    public NBTTagCompound screenData;
    protected Screen screen;
    protected ItemStack card;
    private boolean prevPowered;
    protected boolean powered;
    private boolean prevIsWeb = false;
    protected boolean isWeb = false;
    protected final Map<Byte, Map<UUID, Integer>> displaySettings;
    private int prevRotation;
    public int rotation;
    private boolean prevShowLabels;
    public boolean showLabels;
    private short prevFacing;
    public short facing;
    private int prevColorBackground;
    public int colorBackground;
    private int prevColorText;
    public int colorText;
    private boolean prevColored;
    public boolean colored;
    private final Map<Integer, List<PanelString>> cardData;

    @Override
    public short getFacing() {
        return (short)Facing.field_71588_a[this.facing];
    }

    public void setFacing(short f) {
        this.setSide((short)Facing.field_71588_a[f]);
    }

    private void setCard(ItemStack value) {
        this.card = value;
    }

    private void setSide(short f) {
        this.facing = f;
        if (this.init && this.prevFacing != f) {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && !this.init) {
                IC2NuclearControl.instance.screenManager.unregisterScreenPart(this);
                IC2NuclearControl.instance.screenManager.registerInfoPanel(this);
            }
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = f;
    }

    @Override
    public void setPowered(boolean p) {
        this.powered = p;
        if (this.prevPowered != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "powered");
        }
        this.prevPowered = this.powered;
    }

    @Override
    public boolean getPowered() {
        return this.powered;
    }

    public void setColored(boolean c) {
        this.colored = c;
        if (this.prevColored != c) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "colored");
        }
        this.prevColored = this.colored;
    }

    public boolean getColored() {
        return this.colored;
    }

    public void setIsWeb(boolean c) {
        this.isWeb = c;
        if (this.prevIsWeb != c) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "isWeb");
        }
        this.prevIsWeb = this.isWeb;
    }

    public boolean getIsWeb() {
        return this.isWeb;
    }

    public void setColorBackground(int c) {
        this.colorBackground = c &= 0xF;
        if (this.prevColorBackground != c) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "colorBackground");
        }
        this.prevColorBackground = this.colorBackground;
    }

    public int getColorBackground() {
        return this.colorBackground;
    }

    public void setColorText(int c) {
        this.colorText = c &= 0xF;
        if (this.prevColorText != c) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "colorText");
        }
        this.prevColorText = this.colorText;
    }

    public int getColorText() {
        return this.colorText;
    }

    public int getColorTextHex() {
        return COLORS_HEX[this.colorText];
    }

    public void setShowLabels(boolean p) {
        this.showLabels = p;
        if (this.prevShowLabels != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "showLabels");
        }
        this.prevShowLabels = this.showLabels;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    protected boolean isCardSlot(int slot) {
        return slot == 0;
    }

    public void setDisplaySettings(byte slot, int settings) {
        if (!this.isCardSlot(slot)) {
            return;
        }
        UUID cardType = null;
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.func_77973_b() instanceof IPanelMultiCard) {
                cardType = ((IPanelMultiCard)stack.func_77973_b()).getCardType(new CardWrapperImpl(stack, slot));
            } else if (stack.func_77973_b() instanceof IPanelDataSource) {
                cardType = ((IPanelDataSource)this.inventory[slot].func_77973_b()).getCardType();
            }
        }
        if (cardType != null) {
            if (!this.displaySettings.containsKey(slot)) {
                this.displaySettings.put(slot, new HashMap());
            }
            boolean update = true;
            this.displaySettings.get(slot).put(cardType, settings);
            if (update && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                NuclearNetworkHelper.sendDisplaySettingsUpdate(this, slot, cardType, settings);
            }
        }
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("screenData")) {
            if (this.screen != null && FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.screen.destroy(true, this.field_145850_b);
            }
            if (this.screenData != null) {
                this.screen = IC2NuclearControl.instance.screenManager.loadScreen(this);
                if (this.screen != null) {
                    this.screen.init(true, this.field_145850_b);
                }
            }
        }
        if (field.equals("facing") && this.prevFacing != this.facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevFacing = this.facing;
        }
        if (field.equals("colorBackground") || field.equals("colored")) {
            if (this.screen != null) {
                this.screen.markUpdate(this.field_145850_b);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.prevColored = this.colored;
            this.prevColorBackground = this.colorBackground;
        }
        if (field.equals("card")) {
            this.inventory[0] = this.card;
        }
        if (field.equals("showLabels")) {
            this.prevShowLabels = this.showLabels;
        }
        if (field.equals("powered") && this.prevPowered != this.powered) {
            if (this.screen != null) {
                this.screen.turnPower(this.getPowered(), this.field_145850_b);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.prevPowered = this.powered;
        }
        if (field.equals("rotation") && this.prevRotation != this.rotation) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevRotation = this.rotation;
        }
    }

    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        if (i == -1) {
            this.setShowLabels(true);
        } else if (i == -2) {
            this.setShowLabels(false);
        }
    }

    public TileEntityInfoPanel(int inventorySize) {
        this.inventory = new ItemStack[inventorySize];
        this.screen = null;
        this.card = null;
        this.init = false;
        this.cardData = new HashMap<Integer, List<PanelString>>();
        this.updateTicker = this.tickRate = IC2NuclearControl.instance.screenRefreshPeriod;
        this.dt = IC2NuclearControl.instance.dataRefreshPeriod;
        this.updatedataTicker = this.dataTicker = this.dt > this.tickRate ? this.tickRate : this.dt;
        this.displaySettings = new HashMap<Byte, Map<UUID, Integer>>(1);
        this.displaySettings.put((byte)0, new HashMap());
        this.powered = false;
        this.prevPowered = false;
        this.facing = 0;
        this.prevFacing = 0;
        this.prevRotation = 0;
        this.rotation = 0;
        this.showLabels = true;
        this.colored = false;
        this.colorBackground = 2;
    }

    public TileEntityInfoPanel() {
        this(3);
    }

    public List<String> getNetworkedFields() {
        ArrayList<String> list = new ArrayList<String>(9);
        list.add("powered");
        list.add("facing");
        list.add("rotation");
        list.add("card");
        list.add("showLabels");
        list.add("colorBackground");
        list.add("colorText");
        list.add("colored");
        list.add("screenData");
        list.add("isWeb");
        return list;
    }

    protected void initData() {
        if (this.field_145850_b.field_72995_K) {
            NuclearNetworkHelper.requestDisplaySettings(this);
        } else {
            RedstoneHelper.checkPowered(this.field_145850_b, this);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.screenData == null) {
                IC2NuclearControl.instance.screenManager.registerInfoPanel(this);
            } else {
                this.screen = IC2NuclearControl.instance.screenManager.loadScreen(this);
                if (this.screen != null) {
                    this.screen.init(true, this.field_145850_b);
                }
            }
        }
        this.init = true;
    }

    public void resetCardData() {
        this.cardData.clear();
    }

    public List<PanelString> getCardData(int settings, ItemStack cardStack, ICardWrapper helper) {
        IPanelDataSource card = (IPanelDataSource)cardStack.func_77973_b();
        byte slot = this.getIndexOfCard(cardStack);
        List<PanelString> data = this.cardData.get(slot);
        if (data == null) {
            data = card.getStringData(settings, helper, this.getShowLabels());
            String title = helper.getTitle();
            if (data != null && title != null && !title.isEmpty()) {
                PanelString titleString = new PanelString();
                titleString.textCenter = title;
                data.add(0, titleString);
            }
            this.cardData.put(Integer.valueOf(slot), data);
        }
        return data;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.initData();
        }
        --this.updatedataTicker;
        if (this.updatedataTicker <= 0) {
            this.resetCardData();
            this.updatedataTicker = this.dataTicker;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.func_70296_d();
        }
        super.func_145845_h();
    }

    protected void postReadFromNBT() {
        if (this.inventory[0] != null) {
            this.card = this.inventory[0];
        }
    }

    protected void deserializeDisplaySettings(NBTTagCompound nbttagcompound, String tagName, byte slot) {
        if (nbttagcompound.func_74764_b(tagName)) {
            NBTTagList settingsList = nbttagcompound.func_150295_c(tagName, 10);
            for (int i = 0; i < settingsList.func_74745_c(); ++i) {
                NBTTagCompound compound = settingsList.func_150305_b(i);
                try {
                    UUID key = UUID.fromString(compound.func_74779_i("key"));
                    int value = compound.func_74762_e("value");
                    this.getDisplaySettingsForSlot(slot).put(key, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    IC2NuclearControl.logger.warn("Ivalid display settings for Information Panel");
                }
            }
        }
    }

    protected void readDisplaySettings(NBTTagCompound nbttagcompound) {
        this.deserializeDisplaySettings(nbttagcompound, "dSettings", (byte)0);
        if (nbttagcompound.func_74764_b("dSets")) {
            int[] dSets = nbttagcompound.func_74759_k("dSets");
            for (int i = 0; i < dSets.length; ++i) {
                this.displaySettings.get((byte)0).put(new UUID(0L, i), dSets[i]);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("rotation")) {
            this.prevRotation = this.rotation = nbttagcompound.func_74762_e("rotation");
        }
        if (nbttagcompound.func_74764_b("showLabels")) {
            this.prevShowLabels = this.showLabels = nbttagcompound.func_74767_n("showLabels");
        } else {
            this.showLabels = true;
            this.prevShowLabels = true;
        }
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
        if (nbttagcompound.func_74764_b("colorBackground")) {
            this.colorText = nbttagcompound.func_74762_e("colorText");
            this.colorBackground = nbttagcompound.func_74762_e("colorBackground");
        } else {
            this.colorText = 0;
            this.colorBackground = 2;
        }
        if (nbttagcompound.func_74764_b("screenData")) {
            this.screenData = (NBTTagCompound)nbttagcompound.func_74781_a("screenData");
        }
        this.readDisplaySettings(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound compound = nbttaglist.func_150305_b(i);
            byte slotNum = compound.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.inventory.length) continue;
            this.inventory[slotNum] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.postReadFromNBT();
        this.func_70296_d();
    }

    public void func_145843_s() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            IC2NuclearControl.instance.screenManager.unregisterScreenPart(this);
        }
        super.func_145843_s();
    }

    protected NBTTagList serializeSlotSettings(byte slot) {
        NBTTagList settingsList = new NBTTagList();
        for (Map.Entry<UUID, Integer> item : this.getDisplaySettingsForSlot(slot).entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("key", item.getKey().toString());
            compound.func_74768_a("value", item.getValue().intValue());
            settingsList.func_74742_a((NBTBase)compound);
        }
        return settingsList;
    }

    protected void saveDisplaySettings(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("dSettings", (NBTBase)this.serializeSlotSettings((byte)0));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74768_a("rotation", this.rotation);
        nbttagcompound.func_74757_a("showLabels", this.getShowLabels());
        nbttagcompound.func_74768_a("colorBackground", this.colorBackground);
        nbttagcompound.func_74768_a("colorText", this.colorText);
        this.saveDisplaySettings(nbttagcompound);
        if (this.screen != null) {
            this.screenData = this.screen.toTag();
            nbttagcompound.func_74782_a("screenData", (NBTBase)this.screenData);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(compound);
            nbttaglist.func_74742_a((NBTBase)compound);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotNum) {
        return this.inventory[slotNum];
    }

    public ItemStack func_70298_a(int slotNum, int amount) {
        if (this.inventory[slotNum] != null) {
            if (this.inventory[slotNum].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slotNum];
                this.inventory[slotNum] = null;
                if (slotNum == 0) {
                    this.setCard(null);
                }
                return itemStack;
            }
            ItemStack taken = this.inventory[slotNum].func_77979_a(amount);
            if (this.inventory[slotNum].field_77994_a == 0) {
                this.inventory[slotNum] = null;
                if (slotNum == 0) {
                    this.setCard(null);
                }
            }
            return taken;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        this.inventory[slotNum] = itemStack;
        if (slotNum == 0) {
            this.setCard(itemStack);
        }
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "block.StatusDisplay";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    protected ItemStack getRangeUpgrade() {
        return this.inventory[1];
    }

    protected boolean isColoredEval() {
        ItemStack itemStack = this.inventory[2];
        return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 1;
    }

    protected boolean isWebEval() {
        ItemStack itemStack = this.inventory[2];
        return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 2;
    }

    public int getCardSlotsCount() {
        return 1;
    }

    public List<ItemStack> getCards() {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>(1);
        data.add(this.inventory[0]);
        return data;
    }

    public byte getIndexOfCard(Object card) {
        if (card == null) {
            return 0;
        }
        int slot = 0;
        for (int i = 0; i < this.func_70302_i_(); i = (int)((byte)(i + 1))) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !stack.equals(card)) continue;
            slot = i;
            break;
        }
        return (byte)slot;
    }

    protected long getIdForCard(CardWrapperImpl cardHelper) {
        long id = cardHelper.getLong("_webSensorId");
        if (id <= 0L) {
            // empty if block
        }
        return id;
    }

    public void processCard(ItemStack card, int upgradeCountRange, int slot) {
        if (card == null) {
            return;
        }
        Item item = card.func_77973_b();
        if (item instanceof IPanelDataSource) {
            boolean needUpdate = true;
            if (upgradeCountRange > 7) {
                upgradeCountRange = 7;
            }
            int range = 8 * (int)Math.pow(2.0, upgradeCountRange);
            CardWrapperImpl cardHelper = new CardWrapperImpl(card, slot);
            if (this.isWeb) {
                // empty if block
            }
            if (item instanceof IRemoteSensor) {
                ChunkCoordinates target = cardHelper.getTarget();
                if (target == null) {
                    needUpdate = false;
                    cardHelper.setState(CardState.INVALID_CARD);
                } else {
                    int dx = target.field_71574_a - this.field_145851_c;
                    int dy = 0;
                    int dz = target.field_71573_c - this.field_145849_e;
                    if (Math.abs(dx) > range || Math.abs(dy) > range || Math.abs(dz) > range) {
                        needUpdate = false;
                        cardHelper.setState(CardState.OUT_OF_RANGE);
                    }
                }
            }
            if (needUpdate) {
                CardState state = ((IPanelDataSource)item).update(this, (ICardWrapper)cardHelper, range);
                cardHelper.setInt("state", state.getIndex());
            }
            cardHelper.commit(this);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int upgradeCountRange = 0;
            this.setColored(this.isColoredEval());
            this.setIsWeb(this.isWebEval());
            ItemStack itemStack = this.getRangeUpgrade();
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 0) {
                upgradeCountRange = itemStack.field_77994_a;
            }
            List<ItemStack> cards = this.getCards();
            for (ItemStack card : cards) {
                byte slot = this.getIndexOfCard(card);
                this.processCard(card, upgradeCountRange, slot);
            }
        }
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 0: {
                return itemstack.func_77973_b() instanceof IPanelDataSource;
            }
            case 1: {
                return itemstack.func_77973_b() instanceof ItemUpgrade && itemstack.func_77960_j() == 0;
            }
            case 2: {
                return itemstack.func_77973_b() instanceof ItemUpgrade && (itemstack.func_77960_j() == 1 || itemstack.func_77960_j() == 2);
            }
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int face) {
        return !entityPlayer.func_70093_af() && this.getFacing() != face;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return !entityPlayer.func_70093_af();
    }

    public int modifyTextureIndex(int texture, int x, int y, int z) {
        if (texture != 53) {
            return texture;
        }
        texture -= 15;
        if (this.screen != null) {
            boolean left = false;
            boolean right = false;
            boolean top = false;
            boolean bottom = false;
            boolean ccw = false;
            switch (this.facing) {
                case 0: {
                    if (x == this.screen.minX) {
                        left = true;
                    }
                    if (x == this.screen.maxX) {
                        right = true;
                    }
                    if (z == this.screen.minZ) {
                        top = true;
                    }
                    if (z != this.screen.maxZ) break;
                    bottom = true;
                    break;
                }
                case 1: {
                    if (x == this.screen.minX) {
                        left = true;
                    }
                    if (x == this.screen.maxX) {
                        right = true;
                    }
                    if (z == this.screen.minZ) {
                        top = true;
                    }
                    if (z != this.screen.maxZ) break;
                    bottom = true;
                    break;
                }
                case 2: {
                    if (x == this.screen.minX) {
                        left = true;
                    }
                    if (x == this.screen.maxX) {
                        right = true;
                    }
                    if (y == this.screen.maxY) {
                        top = true;
                    }
                    if (y != this.screen.minY) break;
                    bottom = true;
                    break;
                }
                case 3: {
                    if (x == this.screen.minX) {
                        right = true;
                    }
                    if (x == this.screen.maxX) {
                        left = true;
                    }
                    if (y == this.screen.maxY) {
                        top = true;
                    }
                    if (y == this.screen.minY) {
                        bottom = true;
                    }
                    ccw = true;
                    break;
                }
                case 4: {
                    if (z == this.screen.minZ) {
                        right = true;
                    }
                    if (z == this.screen.maxZ) {
                        left = true;
                    }
                    if (y == this.screen.maxY) {
                        top = true;
                    }
                    if (y == this.screen.minY) {
                        bottom = true;
                    }
                    ccw = true;
                    break;
                }
                case 5: {
                    if (z == this.screen.minZ) {
                        left = true;
                    }
                    if (z == this.screen.maxZ) {
                        right = true;
                    }
                    if (y == this.screen.maxY) {
                        top = true;
                    }
                    if (y != this.screen.minY) break;
                    bottom = true;
                }
            }
            if (this.rotation == 0) {
                if (left) {
                    ++texture;
                }
                if (right) {
                    texture += 2;
                }
                if (top) {
                    texture += 4;
                }
                if (bottom) {
                    texture += 8;
                }
            } else if (!ccw && this.rotation == 1) {
                if (this.facing == 1) {
                    if (left) {
                        texture += 4;
                    }
                    if (right) {
                        texture += 8;
                    }
                    if (top) {
                        texture += 2;
                    }
                    if (bottom) {
                        ++texture;
                    }
                } else {
                    if (left) {
                        texture += 8;
                    }
                    if (right) {
                        texture += 4;
                    }
                    if (top) {
                        ++texture;
                    }
                    if (bottom) {
                        texture += 2;
                    }
                }
            } else if (ccw && this.rotation == 1) {
                if (left) {
                    texture += 8;
                }
                if (right) {
                    texture += 4;
                }
                if (top) {
                    texture += 2;
                }
                if (bottom) {
                    ++texture;
                }
            } else if (this.rotation == 3) {
                if (left) {
                    texture += 2;
                }
                if (right) {
                    ++texture;
                }
                if (top) {
                    texture += 8;
                }
                if (bottom) {
                    texture += 4;
                }
            } else if (!ccw && this.rotation == 2) {
                if (this.facing == 1) {
                    if (left) {
                        texture += 8;
                    }
                    if (right) {
                        texture += 4;
                    }
                    if (top) {
                        ++texture;
                    }
                    if (bottom) {
                        texture += 2;
                    }
                } else {
                    if (left) {
                        texture += 4;
                    }
                    if (right) {
                        texture += 8;
                    }
                    if (top) {
                        texture += 2;
                    }
                    if (bottom) {
                        ++texture;
                    }
                }
            } else if (ccw && this.rotation == 2) {
                if (left) {
                    texture += 4;
                }
                if (right) {
                    texture += 8;
                }
                if (top) {
                    ++texture;
                }
                if (bottom) {
                    texture += 2;
                }
            }
        } else {
            texture += 15;
        }
        if (this.colored) {
            texture = texture - 32 + this.colorBackground * 16;
        }
        if (this.getPowered()) {
            texture += 240;
        }
        return texture;
    }

    @Override
    public int modifyTextureIndex(int texture) {
        return this.modifyTextureIndex(texture, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field_145851_c;
        result = 31 * result + this.field_145848_d;
        result = 31 * result + this.field_145849_e;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileEntityInfoPanel other = (TileEntityInfoPanel)obj;
        if (this.field_145851_c != other.field_145851_c) {
            return false;
        }
        if (this.field_145848_d != other.field_145848_d) {
            return false;
        }
        if (this.field_145849_e != other.field_145849_e) {
            return false;
        }
        return this.field_145850_b == other.field_145850_b;
    }

    @Override
    public void rotate() {
        int r;
        switch (this.rotation) {
            case 0: {
                r = 1;
                break;
            }
            case 1: {
                r = 3;
                break;
            }
            case 3: {
                r = 2;
                break;
            }
            case 2: {
                r = 0;
                break;
            }
            default: {
                r = 0;
            }
        }
        this.setRotation(r);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(int value) {
        this.rotation = value;
        if (this.rotation != this.prevRotation) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotation");
        }
        this.prevRotation = this.rotation;
    }

    public Map<Byte, Map<UUID, Integer>> getDisplaySettings() {
        return this.displaySettings;
    }

    public Map<UUID, Integer> getDisplaySettingsForSlot(byte slot) {
        if (!this.displaySettings.containsKey(slot)) {
            this.displaySettings.put(slot, new HashMap());
        }
        return this.displaySettings.get(slot);
    }

    public int getDisplaySettingsForCardInSlot(int slot) {
        ItemStack card = this.inventory[slot];
        if (card == null) {
            return 0;
        }
        return this.getDisplaySettingsByCard(card);
    }

    public int getDisplaySettingsByCard(ItemStack card) {
        byte slot = this.getIndexOfCard(card);
        if (card == null) {
            return 0;
        }
        if (!this.displaySettings.containsKey(slot)) {
            return Integer.MAX_VALUE;
        }
        UUID cardType = null;
        if (card.func_77973_b() instanceof IPanelMultiCard) {
            cardType = ((IPanelMultiCard)card.func_77973_b()).getCardType(new CardWrapperImpl(card, 0));
        } else if (card.func_77973_b() instanceof IPanelDataSource) {
            cardType = ((IPanelDataSource)card.func_77973_b()).getCardType();
        }
        if (this.displaySettings.get(slot).containsKey(cardType)) {
            return this.displaySettings.get(slot).get(cardType);
        }
        return Integer.MAX_VALUE;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 4);
    }

    @Override
    public void updateData() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.screenData = this.screen == null ? null : this.screen.toTag();
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "screenData");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.isItemValid(slot, itemstack);
    }
}

