/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.ICardSettingsWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.gui.GuiInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class CardSettingsWrapperImpl
implements ICardSettingsWrapper {
    private ItemStack card;
    private TileEntity panel;
    private Map<String, Object> updateSet;
    private GuiInfoPanel gui;
    private int slot;

    public CardSettingsWrapperImpl(ItemStack card, TileEntity panel, GuiInfoPanel gui, int slot) {
        if (!(card.func_77973_b() instanceof IPanelDataSource)) {
            IC2NuclearControl.logger.error("CardHelper sould be used for IPanelDataSource items.");
        }
        this.card = card;
        this.panel = panel;
        this.updateSet = new HashMap<String, Object>();
        this.gui = gui;
        this.slot = slot;
    }

    @Override
    public void setInt(String name, Integer value) {
        this.updateSet.put(name, value);
    }

    @Override
    public void setDouble(String name, double value) {
        this.updateSet.put(name, value);
    }

    @Override
    public void setString(String name, String value) {
        this.updateSet.put(name, value);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        this.updateSet.put(name, value);
    }

    @Override
    public void commit() {
        if (!this.updateSet.isEmpty()) {
            NuclearNetworkHelper.setCardSettings(this.card, this.panel, this.updateSet, this.slot);
            this.updateSet = new HashMap<String, Object>();
        }
    }

    @Override
    public void closeGui() {
        this.gui.prevCard = null;
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)this.gui);
    }
}

