/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.InventoryItem;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;

public class PacketClientRemoteMonitor
implements IMessage {
    private Map<String, Object> fields;
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    public PacketClientRemoteMonitor() {
    }

    public PacketClientRemoteMonitor(Map<String, Object> updateSet) {
        this.fields = updateSet;
    }

    public void fromBytes(ByteBuf buf) {
        int fieldCount = buf.readShort();
        this.fields = new HashMap<String, Object>();
        block11: for (int i = 0; i < fieldCount; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte type = buf.readByte();
            switch (type) {
                case 2: {
                    this.fields.put(name, buf.readInt());
                    continue block11;
                }
                case 4: {
                    this.fields.put(name, buf.readBoolean());
                    continue block11;
                }
                case 7: {
                    this.fields.put(name, buf.readLong());
                    continue block11;
                }
                case 1: {
                    this.fields.put(name, buf.readDouble());
                    continue block11;
                }
                case 3: {
                    this.fields.put(name, ByteBufUtils.readUTF8String((ByteBuf)buf));
                    continue block11;
                }
                case 5: {
                    try {
                        int size = buf.readInt();
                        DataInputStream dat = new DataInputStream(new ByteArrayInputStream(Arrays.copyOfRange(buf.array(), buf.readerIndex() + 1, buf.readerIndex() + 1 + size)));
                        NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)dat);
                        this.fields.put(name, tag);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block11;
                }
                case 6: {
                    this.fields.put(name, null);
                    continue block11;
                }
                default: {
                    IC2NuclearControl.logger.warn("Invalid field type: %d", new Object[]{type});
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.fields.size());
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Long) {
                buf.writeByte(7);
                buf.writeLong(((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                buf.writeByte(1);
                buf.writeDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                buf.writeByte(2);
                buf.writeInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                buf.writeByte(3);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                continue;
            }
            if (value instanceof Boolean) {
                buf.writeByte(4);
                buf.writeBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof NBTTagCompound) {
                buf.writeByte(5);
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    DataOutputStream output = new DataOutputStream(stream);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)((NBTTagCompound)value), (OutputStream)output);
                    buf.writeInt(stream.size());
                    buf.writeBytes(stream.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (value != null) continue;
            buf.writeByte(6);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketClientRemoteMonitor, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketClientRemoteMonitor message, MessageContext ctx) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == IC2NuclearControl.itemRemoteMonitor) {
                InventoryItem itemInv = new InventoryItem(player.func_70694_bm());
                if (itemInv.func_70301_a(0) == null || !(itemInv.func_70301_a(0).func_77973_b() instanceof IPanelDataSource)) {
                    return null;
                }
                CardWrapperImpl helper = new CardWrapperImpl(itemInv.func_70301_a(0), -1);
                for (Map.Entry entry : message.fields.entrySet()) {
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Long) {
                        helper.setLong(name, (Long)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        helper.setDouble(name, (Double)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        helper.setInt(name, (Integer)value);
                        continue;
                    }
                    if (value instanceof String) {
                        helper.setString(name, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        helper.setBoolean(name, (Boolean)value);
                        continue;
                    }
                    if (value instanceof NBTTagCompound) {
                        helper.setTag(name, (NBTTagCompound)value);
                        continue;
                    }
                    if (value != null) continue;
                    helper.clearField(name);
                }
            }
            return null;
        }
    }
}

