/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.abstractions;

import chylex.hee.system.abstractions.Pos;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class Vec {
    public double x;
    public double y;
    public double z;

    public static Vec xyz(double x, double y, double z) {
        return new Vec(x, y, z);
    }

    public static Vec xz(double x, double z) {
        return new Vec(x, 0.0, z);
    }

    public static Vec zero() {
        return new Vec(0.0, 0.0, 0.0);
    }

    public static Vec from(Vec3 vec3) {
        return new Vec(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public static Vec xzRandom(Random rand) {
        return new Vec(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5).normalized();
    }

    public static Vec xyzRandom(Random rand) {
        return new Vec(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5).normalized();
    }

    public static Vec between(Entity source, Entity target) {
        return new Vec(target.field_70165_t - source.field_70165_t, target.field_70163_u - source.field_70163_u, target.field_70161_v - source.field_70161_v);
    }

    public static Vec pos(Entity entity) {
        return new Vec(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static Vec xyzLook(EntityLivingBase entity) {
        return Vec.from(entity.func_70040_Z());
    }

    public static Vec xzLook(EntityLivingBase entity) {
        float angle = -MathUtil.toRad(entity.field_70177_z) - (float)Math.PI;
        return new Vec(-Math.sin(angle), 0.0, -Math.cos(angle));
    }

    private Vec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void moveBy(Vec vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public Vec copy() {
        return new Vec(this.x, this.y, this.z);
    }

    public Vec normalized() {
        double len = this.length();
        return MathUtil.floatEquals((float)len, 0.0f) ? Vec.zero() : Vec.xyz(this.x / len, this.y / len, this.z / len);
    }

    public Vec offset(double offX, double offY, double offZ) {
        return Vec.xyz(this.x + offX, this.y + offY, this.z + offZ);
    }

    public Vec offset(Vec byVec) {
        return Vec.xyz(this.x + byVec.x, this.y + byVec.y, this.z + byVec.z);
    }

    public Vec offset(Vec byVec, double factor) {
        return Vec.xyz(this.x + byVec.x * factor, this.y + byVec.y * factor, this.z + byVec.z * factor);
    }

    public Vec interpolated(Vec toVec, double progress) {
        return Vec.xyz(this.x + (toVec.x - this.x) * progress, this.y + (toVec.y - this.y) * progress, this.z + (toVec.z - this.z) * progress);
    }

    public Vec multiplied(double factor) {
        return Vec.xyz(this.x * factor, this.y * factor, this.z * factor);
    }

    public Vec multiplied(double facX, double facY, double facZ) {
        return Vec.xyz(this.x * facX, this.y * facY, this.z * facZ);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double distance(Vec vec) {
        return MathUtil.distance(vec.x - this.x, vec.y - this.y, vec.z - this.z);
    }

    public double dotProduct(Vec vec) {
        return vec.x * this.x + vec.y * this.y + vec.z * this.z;
    }

    public Pos toPos() {
        return Pos.at((double)this.x, (double)this.y, (double)this.z);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.func_72330_a((double)this.x, (double)this.y, (double)this.z, (double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        return "{ " + this.x + ", " + this.y + ", " + this.z + " }";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vec) {
            Vec vec = (Vec)obj;
            return vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return (Double.hashCode(this.y) + Double.hashCode(this.z) * 31) * 31 + Double.hashCode(this.x);
    }
}

