/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.save.types.global;

import chylex.hee.game.save.SaveFile;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;

public class WorldGenFile
extends SaveFile {
    private final TLongObjectHashMap<WorldGenElement> elements = new TLongObjectHashMap();

    public WorldGenFile() {
        super("worldgen.nbt");
    }

    public void addElementAt(int chunkX, int chunkZ, WorldGenElement element) {
        this.elements.put(this.getFromChunkPos(chunkX, chunkZ), (Object)element);
        this.setModified();
    }

    public boolean isAreaBlocked(int chunkX, int chunkZ, WorldGenElement element) {
        TLongObjectIterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (Math.abs(this.getX(iter.key()) - chunkX) > ((WorldGenElement)((Object)iter.value())).rad + element.rad || Math.abs(this.getZ(iter.key()) - chunkZ) > ((WorldGenElement)((Object)iter.value())).rad + element.rad) continue;
            return true;
        }
        return false;
    }

    private final long getFromChunkPos(int x, int z) {
        if (x >= -1875000 && z >= -1875000 && x < 1875000 && z < 1875000) {
            return (long)x + 1875000L << 24 | (long)z + 1875000L;
        }
        return Long.MAX_VALUE;
    }

    private final int getX(long pos) {
        return (int)((pos >> 24) - 1875000L);
    }

    private final int getZ(long pos) {
        return (int)((pos & 0xFFFFFFL) - 1875000L);
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        TByteObjectHashMap saved = new TByteObjectHashMap();
        TLongObjectIterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            iter.advance();
            byte ord = (byte)((WorldGenElement)((Object)iter.value())).ordinal();
            if (!saved.containsKey(ord)) {
                saved.put(ord, (Object)new NBTTagList());
            }
            ((NBTTagList)saved.get(ord)).func_74742_a((NBTBase)new NBTTagDouble(Double.longBitsToDouble(iter.key())));
        }
        iter = saved.iterator();
        while (iter.hasNext()) {
            iter.advance();
            nbt.func_74782_a(String.valueOf(iter.key()), (NBTBase)iter.value());
        }
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        WorldGenElement[] vals = WorldGenElement.values();
        for (int a = 0; a < vals.length; ++a) {
            NBTTagList list = nbt.func_150295_c(String.valueOf(a), 6);
            for (int index = 0; index < list.func_74745_c(); ++index) {
                this.elements.put(Double.doubleToLongBits(list.func_150309_d(index)), (Object)vals[a]);
            }
        }
    }

    public static enum WorldGenElement {
        DUNGEON_TOWER(1),
        BIOME_ISLAND(6),
        INSIDIOUS_SANCTUARY(0);

        private final byte rad;

        private WorldGenElement(int rad) {
            this.rad = (byte)rad;
        }
    }
}

