/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.teleport;

import chylex.hee.entity.mob.teleport.ITeleportListener;
import chylex.hee.entity.mob.teleport.ITeleportLocation;
import chylex.hee.entity.mob.teleport.ITeleportPredicate;
import chylex.hee.entity.mob.teleport.TeleportLocation;
import chylex.hee.system.abstractions.Vec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;

public class MobTeleporter<T extends Entity> {
    private int attempts;
    private ITeleportLocation<T> locationSelector;
    private List<ITeleportPredicate<T>> locationPredicates = new ArrayList<ITeleportPredicate<T>>(2);
    private List<ITeleportListener<T>> onTeleport = new ArrayList<ITeleportListener<T>>(2);

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void setLocationSelector(ITeleportLocation<T> locationSelector) {
        this.locationSelector = locationSelector;
    }

    public void setLocationSelector(TeleportLocation.ITeleportXZ<T> xzSelector, TeleportLocation.ITeleportY<T> ySelector) {
        this.locationSelector = new TeleportLocation<T>(xzSelector, ySelector);
    }

    public void addLocationPredicate(ITeleportPredicate<T> locationPredicate) {
        this.locationPredicates.add(locationPredicate);
    }

    public void onTeleport(ITeleportListener<T> listener) {
        this.onTeleport.add(listener);
    }

    public boolean teleport(T entity, Random rand) {
        if (((Entity)entity).field_70170_p.field_72995_K) {
            return false;
        }
        Vec oldPos = Vec.pos(entity);
        Vec oldPosCopy = oldPos.copy();
        for (int attempt = 0; attempt < this.attempts; ++attempt) {
            Vec newPos = this.locationSelector.findPosition(entity, oldPosCopy, rand);
            entity.func_70107_b(newPos.x, newPos.y, newPos.z);
            if (!this.locationPredicates.stream().allMatch(predicate -> predicate.isValid(entity, oldPos, rand))) continue;
            if (((Entity)entity).field_70154_o != null) {
                entity.func_70078_a(null);
                entity.func_70107_b(newPos.x, newPos.y, newPos.z);
            }
            for (ITeleportListener<T> listener : this.onTeleport) {
                listener.onTeleport(entity, oldPos, rand);
            }
            return true;
        }
        entity.func_70107_b(oldPos.x, oldPos.y, oldPos.z);
        return false;
    }
}

