/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.block;

import chylex.hee.item.ItemPortalToken;
import chylex.hee.system.abstractions.Vec;
import chylex.hee.system.abstractions.entity.EntityDataWatcher;
import chylex.hee.system.collections.CollectionUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.end.EndTerritory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityBlockTokenHolder
extends Entity {
    protected EntityDataWatcher entityData;
    public float rotation;
    public float prevRotation;
    public float prevCharge;
    private boolean isRestoring;
    private short restoreTimer;
    private EndTerritory tokenTerritory;

    public EntityBlockTokenHolder(World world) {
        super(world);
        this.func_70105_a(0.75f, 1.05f);
        this.field_70156_m = true;
        this.rotation = this.prevRotation = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
    }

    protected void func_70088_a() {
        this.entityData = new EntityDataWatcher(this);
        this.entityData.addFloat(Data.CHARGE_PROGRESS);
        this.entityData.addBoolean(Data.IS_RARE);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            this.prevRotation = this.rotation;
            this.prevCharge = this.getChargeProgress();
            this.rotation += 4.0f;
        } else {
            if (EndTerritory.fromPosition((double)this.field_70165_t) == EndTerritory.THE_HUB && (this.restoreTimer = (short)(this.restoreTimer + 1)) >= 600) {
                this.restoreTimer = 0;
                this.isRestoring = true;
            }
            if (this.isRestoring && this.getChargeProgress() < 1.0f) {
                float newValue = Math.min(1.0f, this.getChargeProgress() + 0.05f);
                if (MathUtil.floatEquals(newValue, 1.0f)) {
                    this.isRestoring = false;
                }
                this.setChargeProgress(newValue);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar() || !(source.func_76364_f() instanceof EntityPlayer)) {
            return false;
        }
        if (source.func_76364_f().func_70093_af() && ((EntityPlayer)source.func_76364_f()).field_71075_bZ.field_75098_d) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "dig.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.1f + 0.92f, false);
            }
            this.func_70106_y();
            return true;
        }
        if (!this.field_70128_L && MathUtil.floatEquals(this.getChargeProgress(), 1.0f)) {
            if (EndTerritory.fromPosition((double)this.field_70165_t) == EndTerritory.THE_HUB) {
                this.setChargeProgress(0.0f);
                this.isRestoring = false;
            } else {
                this.func_70106_y();
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "dig.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.1f + 0.92f, false);
                for (int a = 0; a < 20; ++a) {
                    this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.8, this.field_70163_u + 0.05 + this.field_70146_Z.nextDouble() * 1.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0);
                }
            } else {
                EntityItem item = this.func_70099_a(ItemPortalToken.forTerritory((EndTerritory)this.tokenTerritory, (boolean)this.isRare(), (Random)this.field_70146_Z), 0.5f);
                if (item != null) {
                    Vec target = Vec.between((Entity)item, source.func_76364_f()).normalized().multiplied(0.225);
                    item.field_70159_w = target.x + (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
                    item.field_70179_y = target.z + (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
                }
            }
        }
        return true;
    }

    public void setTerritory(EndTerritory territory) {
        this.tokenTerritory = territory;
    }

    public void setChargeProgress(float progress) {
        this.entityData.setFloat(Data.CHARGE_PROGRESS, progress);
        this.restoreTimer = 0;
    }

    public float getChargeProgress() {
        return this.entityData.getFloat(Data.CHARGE_PROGRESS);
    }

    public void setRare(boolean isRare) {
        this.entityData.setBoolean(Data.IS_RARE, isRare);
    }

    public boolean isRare() {
        return this.entityData.getBoolean(Data.IS_RARE);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.tokenTerritory == null) {
            return;
        }
        nbt.func_74776_a("charge", this.getChargeProgress());
        nbt.func_74757_a("isRare", this.isRare());
        nbt.func_74774_a("territory", (byte)this.tokenTerritory.ordinal());
        if (this.restoreTimer > 0) {
            nbt.func_74777_a("restoreTim", this.restoreTimer);
        }
        if (this.isRestoring) {
            nbt.func_74757_a("isRestoring", this.isRestoring);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setChargeProgress(nbt.func_74760_g("charge"));
        this.setRare(nbt.func_74767_n("isRare"));
        this.tokenTerritory = CollectionUtil.get((Object[])EndTerritory.values, (int)nbt.func_74771_c("territory")).orElse(null);
        this.restoreTimer = nbt.func_74765_d("restoreTim");
        this.isRestoring = nbt.func_74767_n("isRestoring");
        if (this.tokenTerritory == null) {
            this.func_70106_y();
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    private static enum Data {
        CHARGE_PROGRESS,
        IS_RARE;

    }
}

