/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.managers;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class DragonChunkManager
implements ForgeChunkManager.LoadingCallback {
    private static DragonChunkManager instance;
    private ForgeChunkManager.Ticket ticket;
    private int prevChunkX = Integer.MAX_VALUE;
    private int prevChunkZ = Integer.MAX_VALUE;
    private int timer;

    public static void register() {
        if (instance != null) {
            throw new RuntimeException("Cannot register DragonChunkManager twice!");
        }
        instance = new DragonChunkManager();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)HardcoreEnderExpansion.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public static void ping(EntityBossDragon dragon) {
        ForgeChunkManager.Ticket ticket = DragonChunkManager.instance.ticket;
        if (ticket == null) {
            ticket = DragonChunkManager.instance.ticket = ForgeChunkManager.requestTicket((Object)HardcoreEnderExpansion.instance, (World)dragon.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            Log.debug("Requested chunkloading ticket on dragon load.", new Object[0]);
            if (ticket != null) {
                ticket.bindEntity((Entity)dragon);
                ticket.setChunkListDepth(9);
            }
        }
        if (ticket == null || --DragonChunkManager.instance.timer >= 0) {
            return;
        }
        DragonChunkManager.instance.timer = 4;
        if (dragon.field_70176_ah == DragonChunkManager.instance.prevChunkX && dragon.field_70164_aj == DragonChunkManager.instance.prevChunkZ) {
            return;
        }
        DragonChunkManager.instance.prevChunkX = dragon.field_70176_ah;
        DragonChunkManager.instance.prevChunkZ = dragon.field_70164_aj;
        Stopwatch.timeAverage("DragonChunkManager - ping update", 10);
        for (int xx = dragon.field_70176_ah - 1; xx <= dragon.field_70176_ah + 1; ++xx) {
            for (int zz = dragon.field_70164_aj - 1; zz <= dragon.field_70164_aj + 1; ++zz) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(xx, zz));
            }
        }
        Stopwatch.finish("DragonChunkManager - ping update");
    }

    public static void release(EntityBossDragon dragon) {
        if (DragonChunkManager.instance.ticket == null) {
            return;
        }
        ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).setLastDragonChunk(dragon.field_70176_ah, dragon.field_70164_aj);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)DragonChunkManager.instance.ticket);
        DragonChunkManager.instance.ticket = null;
        instance.clear();
        Log.debug("Dragon requested releasing the chunkloading ticket.", new Object[0]);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        Log.debug("Loaded dragon chunkloading tickets ($0).", tickets.size());
        if (!tickets.isEmpty()) {
            this.ticket = tickets.get(0);
            if (this.ticket.getType() != ForgeChunkManager.Type.ENTITY || !(this.ticket.getEntity() instanceof EntityBossDragon)) {
                Log.debug("Canceled loaded ticket (invalid).", new Object[0]);
                this.ticket = null;
            } else {
                this.clear();
                DragonChunkManager.ping((EntityBossDragon)this.ticket.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.world.field_72995_K && e.world.field_73011_w.field_76574_g == 1) {
            DragonSavefile file = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class);
            if (file.isDragonDead()) {
                return;
            }
            ChunkCoordIntPair chunk = file.getLastDragonChunk();
            e.world.func_72964_e(chunk.field_77276_a, chunk.field_77275_b);
            int xx = chunk.field_77276_a * 16;
            int zz = chunk.field_77275_b * 16;
            List list = e.world.func_72872_a(EntityBossDragon.class, AxisAlignedBB.func_72330_a((double)xx, (double)-32.0, (double)zz, (double)(xx + 16), (double)512.0, (double)(zz + 16)));
            if (!list.isEmpty()) {
                Log.debug("Loading dragon based on last stored chunk.", new Object[0]);
                this.clear();
                DragonChunkManager.ping((EntityBossDragon)list.get(0));
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (this.ticket != null && !e.world.field_72995_K && e.world.field_73011_w.field_76574_g == 1) {
            this.ticket = null;
            Log.debug("World unloaded, dereferencing dragon chunkloading ticket.", new Object[0]);
        }
    }

    private void clear() {
        this.timer = 0;
        this.prevChunkZ = Integer.MAX_VALUE;
        this.prevChunkX = Integer.MAX_VALUE;
    }
}

