/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.technical;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.technical.EntityTechnicalBase;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.curse.CurseEvents;
import chylex.hee.mechanics.curse.CurseType;
import chylex.hee.mechanics.curse.ICurseCaller;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityTechnicalCurseBlock
extends EntityTechnicalBase
implements ICurseCaller {
    private UUID owner;
    private int ownerEntityID = -1;
    private CurseType curseType;
    private boolean eternal;
    private byte usesLeft;
    private final List<EntityLivingBase> prevAffectedEntities = new ArrayList<EntityLivingBase>();
    @SideOnly(value=Side.CLIENT)
    private byte disappearTimer;

    public EntityTechnicalCurseBlock(World world) {
        super(world);
    }

    public EntityTechnicalCurseBlock(World world, int x, int y, int z, UUID ownerID, CurseType type, boolean eternal) {
        super(world);
        this.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
        this.owner = ownerID;
        this.curseType = type;
        this.eternal = eternal;
        this.usesLeft = (byte)(eternal ? -1 : type.getUses(CurseType.EnumCurseUse.BLOCK, this.field_70146_Z));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)-1);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.curseType == null) {
                this.curseType = CurseType.getFromDamage(this.field_70180_af.func_75683_a(16) - 1);
            }
            if (this.curseType != null) {
                boolean forceRenderFX;
                EntityPlayer client = HardcoreEnderExpansion.proxy.getClientSidePlayer();
                double dist = client.func_70032_d((Entity)this);
                if (dist > 32.0) {
                    return;
                }
                if (this.ownerEntityID == -1) {
                    this.ownerEntityID = this.field_70180_af.func_75679_c(17);
                }
                boolean bl = forceRenderFX = client.func_145782_y() == this.ownerEntityID || client.func_70694_bm() != null && client.func_70694_bm().func_77973_b() == ItemList.curse_amulet;
                if (!forceRenderFX) {
                    for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(1.75, 0.1, 1.75))) {
                        if (entity != client) continue;
                        this.disappearTimer = (byte)120;
                        break;
                    }
                }
                if (forceRenderFX || this.disappearTimer > 0 && (this.disappearTimer = (byte)(this.disappearTimer - 1)) > 0) {
                    for (int a = 0; a < 1 + this.field_70146_Z.nextInt(dist > 16.0 ? 2 : 3); ++a) {
                        HardcoreEnderExpansion.fx.curse(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 3.0, this.field_70163_u, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 3.0, this.curseType);
                    }
                }
            }
            return;
        }
        if (this.field_70173_aa == 1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(this.curseType.damage + 1)));
        }
        if (this.field_70173_aa % 20 == 1) {
            if (this.ownerEntityID == -1) {
                for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                    if (!player.func_110124_au().equals(this.owner)) continue;
                    this.ownerEntityID = player.func_145782_y();
                    this.field_70180_af.func_75692_b(17, (Object)this.ownerEntityID);
                    break;
                }
            } else if (this.field_70170_p.func_73045_a(this.ownerEntityID) == null) {
                this.ownerEntityID = -1;
            }
        }
        ArrayList<EntityLivingBase> newAffectedEntities = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(1.5, 0.1, 1.5))) {
            if (entity.func_110124_au().equals(this.owner) || entity instanceof IBossDisplayData) continue;
            newAffectedEntities.add(entity);
            if (!this.curseType.handler.tickEntity(entity, this) || this.usesLeft == -1 || (this.usesLeft = (byte)(this.usesLeft - 1)) > 0 && (!CurseEvents.hasAmulet(entity) || (this.usesLeft = (byte)(this.usesLeft - 1)) > 0)) continue;
            this.curseType.handler.end(entity, this);
            this.func_70106_y();
            break;
        }
        for (EntityLivingBase prevAffected : this.prevAffectedEntities) {
            if (newAffectedEntities.contains(prevAffected)) continue;
            this.curseType.handler.end(prevAffected, this);
        }
        this.prevAffectedEntities.clear();
        this.prevAffectedEntities.addAll(newAffectedEntities);
    }

    @Override
    public void onPurify() {
        if (this.curseType != null) {
            for (EntityLivingBase prevAffected : this.prevAffectedEntities) {
                this.curseType.handler.end(prevAffected, this);
            }
            this.prevAffectedEntities.clear();
        }
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("curse", this.curseType.damage);
        nbt.func_74757_a("eternal", this.eternal);
        nbt.func_74774_a("usesLeft", this.usesLeft);
        nbt.func_74772_a("own1", this.owner.getLeastSignificantBits());
        nbt.func_74772_a("own2", this.owner.getMostSignificantBits());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.curseType = CurseType.getFromDamage(nbt.func_74771_c("curse"));
        if (this.curseType == null) {
            this.func_70106_y();
        }
        this.eternal = nbt.func_74767_n("eternal");
        this.usesLeft = nbt.func_74771_c("usesLeft");
        this.owner = new UUID(nbt.func_74763_f("own2"), nbt.func_74763_f("own1"));
    }
}

