/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.util;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public final class DecoratorFeatureGenerator {
    private final TIntObjectHashMap<GeneratedBlock> blocks = new TIntObjectHashMap();
    private final Map<BlockPosM, ITileEntityGenerator> tileEntities = new HashMap<BlockPosM, ITileEntityGenerator>();
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int bottomY;
    private int topY;
    private int outOfBoundsCounter;

    public boolean setBlock(int x, int y, int z, Block block) {
        return this.setBlock(x, y, z, block, 0);
    }

    public boolean setBlock(int x, int y, int z, Block block, int metadata) {
        if (x < -16 || x > 15 || z < -16 || z > 15 || y < -64 || y > 63) {
            ++this.outOfBoundsCounter;
            return false;
        }
        if (x < this.minX) {
            this.minX = x;
        } else if (x > this.maxX) {
            this.maxX = x;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (y > this.topY) {
            this.topY = y;
        } else if (y < this.bottomY) {
            this.bottomY = y;
        }
        this.blocks.put(1024 * (y + 128) + 32 * (x + 16) + z + 16, (Object)new GeneratedBlock(block, metadata, x, y, z));
        return true;
    }

    public boolean setTileEntity(int x, int y, int z, ITileEntityGenerator tileGen) {
        if (x < -16 || x > 15 || z < -16 || z > 15 || y < -64 || y > 63) {
            return false;
        }
        this.tileEntities.put(new BlockPosM(x, y, z), tileGen);
        return true;
    }

    public void runPass(IDecoratorGenPass pass) {
        pass.run(this, this.getUsedLocations());
    }

    public Block getBlock(int x, int y, int z) {
        GeneratedBlock block = (GeneratedBlock)this.blocks.get(1024 * (y + 128) + 32 * (x + 16) + z + 16);
        return block == null ? Blocks.field_150350_a : block.block;
    }

    public int getMetadata(int x, int y, int z) {
        GeneratedBlock block = (GeneratedBlock)this.blocks.get(1024 * (y + 128) + 32 * (x + 16) + z + 16);
        return block == null ? (byte)0 : block.metadata;
    }

    public int getTopBlockY(int x, int z) {
        int y = this.topY + 1;
        while (y >= this.bottomY) {
            if (this.getBlock(x, --y, z) == Blocks.field_150350_a) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    public int getOutOfBoundsCounter() {
        return this.outOfBoundsCounter;
    }

    public List<BlockPosM> getUsedLocations() {
        ArrayList<BlockPosM> locs = new ArrayList<BlockPosM>();
        for (GeneratedBlock block : this.blocks.valueCollection()) {
            if (block.block == Blocks.field_150350_a) continue;
            locs.add(new BlockPosM(block.x, block.y, block.z));
        }
        return locs;
    }

    public void generate(World world, Random rand, int centerX, int centerY, int centerZ) {
        if (this.blocks.isEmpty()) {
            return;
        }
        int sizeX = this.maxX - this.minX + 1;
        int sizeZ = this.maxZ - this.minZ + 1;
        int randX = 16 - sizeX >> 1;
        int randZ = 16 - sizeZ >> 1;
        if (randX > 0) {
            centerX += rand.nextInt(randX * 2) - randX;
        }
        if (randZ > 0) {
            centerZ += rand.nextInt(randZ * 2) - randZ;
        }
        ArrayList<GeneratedBlock> delayed = new ArrayList<GeneratedBlock>();
        try {
            for (GeneratedBlock generatedBlock : this.blocks.valueCollection()) {
                if (!generatedBlock.block.func_149718_j(world, centerX + generatedBlock.x, centerY + generatedBlock.y, centerZ + generatedBlock.z)) {
                    delayed.add(generatedBlock);
                    continue;
                }
                world.func_147465_d(centerX + generatedBlock.x, centerY + generatedBlock.y, centerZ + generatedBlock.z, generatedBlock.block, (int)generatedBlock.metadata, 3);
            }
            if (!delayed.isEmpty()) {
                for (GeneratedBlock generatedBlock : delayed) {
                    world.func_147465_d(centerX + generatedBlock.x, centerY + generatedBlock.y, centerZ + generatedBlock.z, generatedBlock.block, (int)generatedBlock.metadata, 3);
                }
            }
            if (!this.tileEntities.isEmpty()) {
                for (Map.Entry entry : this.tileEntities.entrySet()) {
                    BlockPosM loc = (BlockPosM)entry.getKey();
                    ((ITileEntityGenerator)entry.getValue()).onTileEntityRequested("", world.func_147438_o(centerX + loc.x, centerY + loc.y, centerZ + loc.z), rand);
                }
            }
        }
        catch (RuntimeException e) {
            Log.debug("DecoratorFeatureGenerator failed ($0,$1 - $2,$3)", centerX, centerZ, sizeX, sizeZ);
        }
    }

    public static interface IDecoratorGenPass {
        public void run(DecoratorFeatureGenerator var1, List<BlockPosM> var2);
    }

    private static final class GeneratedBlock {
        final Block block;
        final byte metadata;
        final byte x;
        final byte y;
        final byte z;

        GeneratedBlock(Block block, int metadata, int x, int y, int z) {
            this.block = block;
            this.metadata = (byte)metadata;
            this.x = (byte)x;
            this.y = (byte)y;
            this.z = (byte)z;
        }
    }
}

