/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.orb;

import chylex.hee.mechanics.orb.WeightedItem;
import chylex.hee.mechanics.orb.WeightedItemList;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemPattern;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;

public final class OrbAcquirableItems {
    public static final WeightedItemList idList = new WeightedItemList();
    public static final List<ItemPattern> blacklist = new ArrayList<ItemPattern>();
    private static String lastWorldIdentifier;

    public static void initialize(boolean firstTime) {
        Stopwatch.time("OrbAcquirableItems");
        if (!firstTime) {
            idList.clear();
        }
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            if (biome.field_76756_M >= 128) break;
            idList.add(new WeightedItem(biome.field_76752_A, 0, 34));
            idList.add(new WeightedItem(biome.field_76753_B, 0, 34));
        }
        Iterator iter = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            try {
                int weight = 30 - (int)(7.0f * FurnaceRecipes.func_77602_a().func_151398_b((ItemStack)entry.getValue()));
                idList.add(new WeightedItem(((ItemStack)entry.getKey()).func_77973_b(), 0, weight));
                idList.add(new WeightedItem(((ItemStack)entry.getValue()).func_77973_b(), 0, weight));
            }
            catch (Throwable t) {
                if (!firstTime) continue;
                Log.error("[HEE-ORB] Corrupted furnace recipe: $0 <= $1", OrbAcquirableItems.toString((ItemStack)entry.getValue()), OrbAcquirableItems.toString((ItemStack)entry.getKey()));
                iter.remove();
            }
        }
        iter = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (iter.hasNext()) {
            IRecipe recipe = (IRecipe)iter.next();
            Class<?> cls = recipe.getClass();
            try {
                Object shaped;
                if (cls == ShapedRecipes.class) {
                    shaped = (ShapedRecipes)recipe;
                    OrbAcquirableItems.addItemToList(shaped.func_77571_b(), 21 - ((ShapedRecipes)shaped).field_77576_b * 2 - ((ShapedRecipes)shaped).field_77577_c * 2);
                    for (ItemStack is : ((ShapedRecipes)shaped).field_77574_d) {
                        OrbAcquirableItems.addItemToList(is, 23 - ((ShapedRecipes)shaped).field_77576_b * 2 - ((ShapedRecipes)shaped).field_77577_c * 2);
                    }
                    continue;
                }
                if (cls == ShapelessRecipes.class) {
                    OrbAcquirableItems.addItemToList(recipe.func_77571_b(), 24 - recipe.func_77570_a() * 2);
                    for (ItemStack item : ((ShapelessRecipes)recipe).field_77579_b) {
                        OrbAcquirableItems.addItemToList(item, 25 - recipe.func_77570_a() * 2);
                    }
                    continue;
                }
                if (cls == ShapedOreRecipe.class) {
                    shaped = (ShapedOreRecipe)recipe;
                    int amt = DragonUtil.getNonNullValues(shaped.getInput()).length;
                    OrbAcquirableItems.addItemToList(shaped.func_77571_b(), 20 - amt * 2);
                    for (Object obj : shaped.getInput()) {
                        if (obj instanceof ItemStack) {
                            OrbAcquirableItems.addItemToList((ItemStack)obj, 19 - amt * 2);
                            continue;
                        }
                        if (!(obj instanceof ArrayList)) continue;
                        ArrayList list = (ArrayList)obj;
                        int len = list.size();
                        for (ItemStack listObj : list) {
                            OrbAcquirableItems.addItemToList(listObj, Math.max(2, 19 - amt * 2 - (len - 1) * 3));
                        }
                    }
                    continue;
                }
                if (cls != ShapelessOreRecipe.class) continue;
                int amt = recipe.func_77570_a();
                OrbAcquirableItems.addItemToList(recipe.func_77571_b(), 23 - amt * 2);
                for (Object obj : ((ShapelessOreRecipe)recipe).getInput()) {
                    if (obj instanceof ItemStack) {
                        OrbAcquirableItems.addItemToList((ItemStack)obj, 24 - amt * 2);
                        continue;
                    }
                    if (!(obj instanceof ArrayList)) continue;
                    ArrayList list = (ArrayList)obj;
                    int len = list.size();
                    for (ItemStack listObj : list) {
                        OrbAcquirableItems.addItemToList(listObj, Math.max(2, 24 - amt * 2 - (len - 1) * 3));
                    }
                }
            }
            catch (Throwable t) {
                if (!firstTime) continue;
                if (cls == ShapedRecipes.class) {
                    Log.error("[HEE-ORB] Corrupted shaped recipe: $0 <= $1", OrbAcquirableItems.toString(recipe.func_77571_b()), OrbAcquirableItems.toString(((ShapedRecipes)recipe).field_77574_d));
                } else if (cls == ShapelessRecipes.class) {
                    Log.error("[HEE-ORB] Corrupted shapeless recipe: $0 <= $1", OrbAcquirableItems.toString(recipe.func_77571_b()), OrbAcquirableItems.toString(((ShapelessRecipes)recipe).field_77579_b));
                } else if (cls == ShapedOreRecipe.class) {
                    Log.error("[HEE-ORB] Corrupted shaped ore recipe: $0 <= $1", OrbAcquirableItems.toString(recipe.func_77571_b()), OrbAcquirableItems.toString(((ShapedOreRecipe)recipe).getInput()));
                } else if (cls == ShapelessOreRecipe.class) {
                    Log.error("[HEE-ORB] Corrupted shapeless ore recipe: $0 <= $1", OrbAcquirableItems.toString(recipe.func_77571_b()), OrbAcquirableItems.toString(((ShapelessOreRecipe)recipe).getInput()));
                }
                iter.remove();
            }
        }
        Item fire = Item.func_150898_a((Block)Blocks.field_150480_ab);
        Iterator iter2 = idList.iterator();
        block13: while (iter2.hasNext()) {
            Block block;
            WeightedItem weightedItem = (WeightedItem)iter2.next();
            Item item = weightedItem.getItem();
            if (item == fire) {
                iter2.remove();
                continue;
            }
            if (item instanceof ItemBlock && ((block = Block.func_149634_a((Item)item)) instanceof IFluidBlock || block instanceof BlockLiquid)) {
                iter2.remove();
                continue;
            }
            for (ItemPattern pattern : blacklist) {
                if (!((Boolean)weightedItem.runBlacklistPattern(pattern).getRight()).booleanValue()) continue;
                iter2.remove();
                continue block13;
            }
        }
        Stopwatch.finish("OrbAcquirableItems");
    }

    public static WeightedItem getRandomItem(World world, Random rand) {
        String identifier = WorldDataHandler.getWorldIdentifier(world);
        if (lastWorldIdentifier == null || !lastWorldIdentifier.equals(identifier)) {
            lastWorldIdentifier = identifier;
            OrbAcquirableItems.initialize(false);
        }
        return (WeightedItem)idList.getRandomItem(rand);
    }

    private static String getModID(ItemStack is) {
        try {
            return GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b()).modId;
        }
        catch (NullPointerException e) {
            return "<null>";
        }
    }

    private static void addItemToList(ItemStack is, int weight) {
        if (is == null || is.func_77942_o() || weight <= 0) {
            return;
        }
        if (is.func_77973_b() == null) {
            is.func_77951_h();
        }
        idList.add(new WeightedItem(is.func_77973_b(), is.func_77960_j(), weight));
    }

    private static String toString(ItemStack is) {
        if (is == null) {
            return "<critical:stack null>";
        }
        if (is.func_77973_b() == null) {
            return "<error:null>";
        }
        return "[" + OrbAcquirableItems.getModID(is) + "]" + (is.field_77994_a > 9 ? is.toString().substring(3).replace('@', '/') : is.toString().substring(2)).replace('@', '/');
    }

    private static String toString(List list) {
        return OrbAcquirableItems.toString(list.toArray());
    }

    private static String toString(Object[] array) {
        Object[] newArray = new Object[array.length];
        for (int a = 0; a < array.length; ++a) {
            if (array[a] == null) {
                newArray[a] = "<empty>";
                continue;
            }
            if (array[a] instanceof ItemStack) {
                newArray[a] = OrbAcquirableItems.toString((ItemStack)array[a]);
                continue;
            }
            if (array[a] instanceof Collection) {
                Collection collection = (Collection)array[a];
                if (collection.isEmpty()) {
                    newArray[a] = "<empty-list>";
                    continue;
                }
                Object obj = collection.iterator().next();
                if (obj instanceof ItemStack) {
                    newArray[a] = OrbAcquirableItems.toString((ItemStack)obj) + "(ore)";
                    continue;
                }
                newArray[a] = "<unknown>";
                continue;
            }
            newArray[a] = "<unknown-cls " + array[a].getClass().getSimpleName() + ">";
        }
        return ArrayUtils.toString((Object)newArray).replace(",", ", ");
    }

    private OrbAcquirableItems() {
    }
}

