/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.managers;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.projectile.EntityProjectileDragonFireball;
import chylex.hee.proxy.ModCommonProxy;
import net.minecraft.entity.Entity;

public class DragonShotManager {
    private final EntityBossDragon dragon;
    private ShotType type;
    private double x;
    private double y;
    private double z;
    private boolean random;

    public DragonShotManager(EntityBossDragon dragon) {
        this.dragon = dragon;
        this.reset();
    }

    private void reset() {
        this.type = ShotType.NONE;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.random = false;
    }

    public DragonShotManager createNew(ShotType type) {
        this.type = type;
        return this;
    }

    public DragonShotManager setTarget(Entity e) {
        if (e == null) {
            return this;
        }
        return this.setTarget(e.field_70165_t, e.field_70121_D.field_72338_b + (double)(e.field_70131_O * 0.5f), e.field_70161_v);
    }

    public DragonShotManager setTarget(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public DragonShotManager setRandom() {
        this.random = true;
        return this;
    }

    public void shoot() {
        EntityProjectileDragonFireball e;
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return;
        }
        double xDiff = this.x - this.dragon.field_70165_t;
        double yDiff = this.y - (this.dragon.field_70163_u + (double)(this.dragon.field_70131_O * 0.5f));
        double zDiff = this.z - this.dragon.field_70161_v;
        EntityProjectileDragonFireball entityProjectileDragonFireball = this.type == ShotType.FIREBALL ? new EntityProjectileDragonFireball(this.dragon.field_70170_p, this.dragon, xDiff, yDiff, zDiff, this.dragon.angryStatus ? 1.5f : 1.0f, this.random, (this.dragon.angryStatus ? 2.8f : 2.5f) + (ModCommonProxy.opMobs ? 0.7f : 0.0f)) : (e = null);
        if (e == null) {
            return;
        }
        e.field_70165_t = this.dragon.dragonPartHead.field_70165_t;
        e.field_70163_u = this.dragon.dragonPartHead.field_70163_u + (double)(this.dragon.field_70131_O / 6.0f);
        e.field_70161_v = this.dragon.dragonPartHead.field_70161_v;
        this.dragon.field_70170_p.func_72838_d((Entity)e);
        this.reset();
    }

    public static enum ShotType {
        NONE,
        FIREBALL;

    }
}

