/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.render.entity.RenderBossDragon;
import chylex.hee.render.entity.RenderMobAngryEnderman;
import chylex.hee.render.entity.RenderMobBabyEnderman;
import chylex.hee.render.entity.RenderMobEnderman;
import chylex.hee.render.entity.RenderMobHomelandEnderman;
import chylex.hee.render.entity.RenderMobInfestedBat;
import chylex.hee.render.entity.RenderMobParalyzedEnderman;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public final class Baconizer {
    private static final Pattern lcword = Pattern.compile("\\b([a-z]+?)\\b", 8);
    private static final Pattern fcword = Pattern.compile("\\b([A-Z][a-z]+?)\\b", 8);
    private static final Pattern ucword = Pattern.compile("\\b([A-Z]+?)\\b", 8);
    @SideOnly(value=Side.CLIENT)
    private static Map<Class<?>, ResourceLocation> renderers;

    @SideOnly(value=Side.CLIENT)
    public static void load() {
        if (!ModCommonProxy.hardcoreEnderbacon) {
            return;
        }
        Blocks.field_150377_bs.func_149663_c("baconStone");
        Baconizer.baconizeBlocks(new Block[]{BlockList.end_powder_ore, BlockList.endium_ore, BlockList.endium_block, BlockList.enderman_head, BlockList.death_flower, BlockList.transport_beacon});
        Baconizer.baconizeItems(new Item[]{ItemList.end_powder, ItemList.endium_ingot, ItemList.adventurers_diary, ItemList.knowledge_note, ItemList.altar_nexus, ItemList.temple_caller, ItemList.dry_splinter, ItemList.spectral_tear, ItemList.living_matter, ItemList.scorching_pickaxe});
        renderers = new HashMap();
        Baconizer.baconizeMob(RenderMobEnderman.class, "enderman");
        Baconizer.baconizeMob(RenderMobAngryEnderman.class, "enderman");
        Baconizer.baconizeMob(RenderMobBabyEnderman.class, "enderman");
        Baconizer.baconizeMob(RenderMobHomelandEnderman.class, "enderman");
        Baconizer.baconizeMob(RenderMobParalyzedEnderman.class, "enderman");
        Baconizer.baconizeMob(RenderMobInfestedBat.class, "bat_infested");
        Baconizer.baconizeMob(RenderBossDragon.class, "dragon");
    }

    private static void baconizeBlocks(Block[] blocks) {
        for (Block block : blocks) {
            block.func_149663_c(block.func_149739_a().substring(5) + ".bacon");
        }
    }

    private static void baconizeItems(Item[] items) {
        for (Item item : items) {
            item.func_77655_b(item.func_77658_a().substring(5) + ".bacon");
        }
    }

    private static void baconizeMob(Class<?> cls, String texName) {
        renderers.put(cls, new ResourceLocation("hardcoreenderexpansion:textures/entity/bacon/" + texName + ".png"));
    }

    public static String mobName(String name) {
        return ModCommonProxy.hardcoreEnderbacon ? name.substring(0, name.length() - 4) + "bacon.name" : name;
    }

    public static ResourceLocation mobTexture(Render renderer, ResourceLocation defLoc) {
        return ModCommonProxy.hardcoreEnderbacon ? renderers.get(renderer.getClass()) : defLoc;
    }

    public static String soundNormal(String defsound) {
        return ModCommonProxy.hardcoreEnderbacon ? "mob.pig.say" : defsound;
    }

    public static String soundDeath(String defsound) {
        return ModCommonProxy.hardcoreEnderbacon ? "mob.pig.death" : defsound;
    }

    public static String sentence(String text) {
        if (!ModCommonProxy.hardcoreEnderbacon) {
            return text;
        }
        String lc = StatCollector.func_74838_a((String)"baconizer.bacon");
        String fc = Character.toUpperCase(lc.charAt(0)) + lc.substring(1);
        String uc = lc.toUpperCase();
        text = lcword.matcher(text).replaceAll(lc);
        text = fcword.matcher(text).replaceAll(fc);
        text = ucword.matcher(text).replaceAll(uc);
        return text;
    }

    @SideOnly(value=Side.CLIENT)
    public static void runBaconCommand() {
        Object text = null;
        text = !ModCommonProxy.hardcoreEnderbacon ? new ChatComponentTranslation("commands.generic.notFound", new Object[0]) : new ChatComponentText(Baconizer.getBaconJoke(Minecraft.func_71410_x().field_71441_e.field_73012_v));
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)text);
    }

    @SideOnly(value=Side.CLIENT)
    private static String getBaconJoke(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return "Why did the pig go into the kitchen? He felt like bacon.";
            }
            case 1: {
                return "What do you get when you cross a pig and a cactus? A Porkupine.";
            }
            case 2: {
                return "How do pigs write top secret messages? With invisible oink.";
            }
            case 3: {
                return "What do you call a pig that does karate? Porkchop!";
            }
            case 4: {
                return "What do you get when you cross a pig and a dinosaur? Jurassic pork.";
            }
            case 5: {
                return "What did the bacon say to a burger patty? Don't worry, I got you covered!";
            }
            case 6: {
                return "What did one slice of bacon say to the other slice? Nice fat!";
            }
            case 7: {
                return "How did the pig get to the hospital? In a hambulance.";
            }
            case 8: {
                return "What do pigs drive? Pigup trucks.";
            }
            case 9: {
                return "Where do pigs go for warm weather? The tropigs.";
            }
            case 10: {
                return "What do you call a pig that took a plane? Swine flu.";
            }
        }
        return "";
    }

    private Baconizer() {
    }
}

