/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.Unfinalizer;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;

public class ReflectionUtils {
    public static Boolean obf;
    public static Map<String, CachedField> mCachedFields;
    private static HashMap<String, String> obfFieldNames;

    public static boolean checkObfuscated() {
        if (obf != null) {
            return obf;
        }
        boolean obfuscated = false;
        try {
            obfuscated = (Boolean)ReflectionHelper.findField(CoreModManager.class, (String[])new String[]{"deobfuscatedEnvironment"}).get(null) == false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            try {
                byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
                obfuscated = bs == null;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                obfuscated = false;
            }
        }
        return obfuscated;
    }

    public static String getCorrectFieldName(String aFieldName) {
        if (!obfFieldNames.keySet().contains(aFieldName)) {
            return aFieldName;
        }
        if (ReflectionUtils.checkObfuscated()) {
            aFieldName = obfFieldNames.get(aFieldName);
        }
        return aFieldName;
    }

    private static boolean cacheField(Class<?> aClass, Field aField) {
        if (aField == null) {
            return false;
        }
        CachedField y = mCachedFields.get(aClass.getName() + "." + aField.getName());
        if (y == null) {
            Log.debug("Caching Field: " + aClass.getName() + "." + aField.getName(), new Object[0]);
            mCachedFields.put(aClass.getName() + "." + aField.getName(), new CachedField(aField));
            return true;
        }
        return false;
    }

    public static Field getField(Class<?> aClass, String aFieldName) {
        if (aClass == null || aFieldName == null || aFieldName.length() <= 0) {
            return null;
        }
        aFieldName = ReflectionUtils.getCorrectFieldName(aFieldName);
        Log.debug("Getting Field: " + aFieldName, new Object[0]);
        CachedField y = mCachedFields.get(aClass.getName() + "." + aFieldName);
        if (y == null) {
            try {
                Field u = ReflectionUtils.getField_Internal(aClass, aFieldName);
                if (u != null) {
                    ReflectionUtils.cacheField(aClass, u);
                    return u;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }
        return y.get();
    }

    public static Field getField(Object aInstance, String aFieldName) {
        return ReflectionUtils.getField(aInstance.getClass(), aFieldName);
    }

    public static <T> T getFieldValue(Object aInstance, String aFieldName) {
        aFieldName = ReflectionUtils.getCorrectFieldName(aFieldName);
        Log.debug("Getting Field Value: " + aFieldName, new Object[0]);
        try {
            return (T)ReflectionUtils.getField(aInstance, aFieldName).get(aInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    public static void setFieldValue(Object aInstance, String aFieldName, Object aNewValue) {
        ReflectionUtils.setFieldValue(aInstance, aFieldName, aInstance instanceof Class, aNewValue);
    }

    public static void setFieldValue(Object aInstance, String aFieldName, boolean aStatic, Object aNewValue) {
        aFieldName = ReflectionUtils.getCorrectFieldName(aFieldName);
        Log.debug("Setting Field: " + aFieldName, new Object[0]);
        try {
            if (aInstance instanceof Class && aStatic) {
                Field f = ReflectionUtils.getField((Class)aInstance, aFieldName);
                ReflectionUtils.makeFieldAccessible(f);
                f.set(null, aNewValue);
            } else {
                Field f = ReflectionUtils.getField(aInstance, aFieldName);
                ReflectionUtils.makeFieldAccessible(f);
                f.set(aInstance, aNewValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static Field getField_Internal(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Field k = clazz.getDeclaredField(fieldName);
            ReflectionUtils.makeFieldAccessible(k);
            return k;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            Log.debug("Checking Super: " + superClass.getCanonicalName(), new Object[0]);
            return ReflectionUtils.getField_Internal(superClass, fieldName);
        }
    }

    public static void makeFieldAccessible(Field field) {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                Unfinalizer.unfinalizeField(field);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        mCachedFields = new LinkedHashMap<String, CachedField>();
        obfFieldNames = new HashMap();
        obfFieldNames.put("registryObjects", "field_82596_a");
        obfFieldNames.put("underlyingIntegerMap", "field_148759_a");
        obfFieldNames.put("block", "field_150939_a");
        obfFieldNames.put("lastDamage", "field_110153_bc");
        obfFieldNames.put("equipmentDropChances", "field_82174_bp");
        obfFieldNames.put("fire", "field_70151_c");
        obfFieldNames.put("targetedEntity", "field_70792_g");
        obfFieldNames.put("tagList", "field_74747_a");
        obfFieldNames.put("floatingTickCount", "field_147365_f");
        obfFieldNames.put("lastPosX", "field_147373_o");
        obfFieldNames.put("lastPosY", "field_147382_p");
        obfFieldNames.put("lastPosZ", "field_147381_q");
        obfFieldNames.put("endRNG", "field_73204_i");
        obfFieldNames.put("sky", "field_76779_k");
        obfFieldNames.put("chunkProvider", "field_73020_y");
        obfFieldNames.put("mcMusicTicker", "field_147126_aw");
        obfFieldNames.put("xSize", "field_146999_f");
        obfFieldNames.put("ySize", "field_147000_g");
        obfFieldNames.put("mapSoundPositions", "field_147593_P");
    }

    private static class CachedField {
        private final Field FIELD;

        public CachedField(Field aField) {
            this.FIELD = aField;
        }

        public Field get() {
            return this.FIELD;
        }
    }
}

