/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.ReflectionUtils;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ObjectIntIdentityMap;

public class BlockReplaceHelper {
    public static void replaceBlock(Block toReplace, Block replacement) {
        Stopwatch.time("BlockReplace");
        Class[] classTest = new Class[4];
        Exception exception = null;
        try {
            for (Field blockField : Blocks.class.getFields()) {
                Block block;
                if (!Block.class.isAssignableFrom(blockField.getType()) || (block = (Block)blockField.get(null)) != toReplace) continue;
                String registryName = Block.field_149771_c.func_148750_c((Object)block);
                int id = Block.func_149682_b((Block)block);
                Log.debug("Replacing block - $0/$1", id, registryName);
                ReflectionUtils.setFieldValue((ItemBlock)Item.func_150898_a((Block)block), "field_150939_a", replacement);
                FMLControlledNamespacedRegistry registryBlocks = GameData.getBlockRegistry();
                Log.debug("Got BlockRegistry.", new Object[0]);
                Map registryObjects = (Map)ReflectionUtils.getFieldValue(registryBlocks, "registryObjects");
                Log.debug("Got registryObjects.", new Object[0]);
                ObjectIntIdentityMap underlyingIntegerMap = (ObjectIntIdentityMap)ReflectionUtils.getFieldValue(registryBlocks, "underlyingIntegerMap");
                Log.debug("Got underlyingIntegerMap.", new Object[0]);
                registryObjects.put(registryName, replacement);
                Log.debug("Put " + replacement.func_149739_a() + " in registryObjects with key: " + registryName, new Object[0]);
                underlyingIntegerMap.func_148746_a((Object)replacement, id);
                Log.debug("OBFUSCATED put object - underlyingIntegerMap", new Object[0]);
                ReflectionUtils.setFieldValue(registryBlocks, "registryObjects", registryObjects);
                Log.debug("Set new value for registryObjects: registryObjects. For object registryBlocks.", new Object[0]);
                ReflectionUtils.setFieldValue(registryBlocks, "underlyingIntegerMap", underlyingIntegerMap);
                Log.debug("Set new value for underlyingIntegerMap: underlyingIntegerMap. For object registryBlocks.", new Object[0]);
                ReflectionUtils.makeFieldAccessible(blockField);
                Log.debug("Made " + blockField.getName() + " accessible.", new Object[0]);
                blockField.set(null, replacement);
                Log.debug("Set " + blockField.getName() + " to " + replacement.func_149739_a() + ".", new Object[0]);
                Method delegateNameMethod = replacement.delegate.getClass().getDeclaredMethod("setName", String.class);
                delegateNameMethod.setAccessible(true);
                Log.debug("Made " + delegateNameMethod.getName() + " accessible.", new Object[0]);
                delegateNameMethod.invoke((Object)replacement.delegate, toReplace.delegate.name());
                Log.debug("Invoked " + delegateNameMethod.getName() + ".", new Object[0]);
                classTest[0] = blockField.get(null).getClass();
                classTest[1] = Block.field_149771_c.func_148754_a(id).getClass();
                classTest[2] = ((ItemBlock)Item.func_150898_a((Block)replacement)).field_150939_a.getClass();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        Stopwatch.finish("BlockReplace");
        Log.debug("Check field: $0", classTest[0]);
        Log.debug("Check block registry: $0", classTest[1]);
        Log.debug("Check item: $0", classTest[2]);
        if (classTest[0] != classTest[1] || classTest[0] != classTest[2] || classTest[0] == null) {
            throw new RuntimeException("HardcoreEnderExpansion was unable to replace block " + toReplace.func_149739_a() + "! Debug info to report: " + classTest[0] + "," + classTest[1] + "," + classTest[2], exception);
        }
    }
}

