/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.handlers;

import chylex.hee.api.message.MessageHandler;
import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.ItemPatternValue;
import chylex.hee.api.message.element.SpawnEntryValue;
import chylex.hee.api.message.handlers.ImcHandler;
import chylex.hee.api.message.utils.MessageLogger;
import chylex.hee.api.message.utils.RunEvent;
import chylex.hee.mechanics.orb.OrbAcquirableItems;
import chylex.hee.mechanics.orb.OrbSpawnableMobs;
import chylex.hee.mechanics.orb.WeightedItem;
import chylex.hee.mechanics.orb.WeightedItemList;
import chylex.hee.system.util.ItemPattern;
import java.util.Iterator;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.IBossDisplayData;
import org.apache.commons.lang3.tuple.Pair;

public class ImcOrbHandlers
extends ImcHandler {
    private static final MessageHandler itemBlacklist = new MessageHandler(){

        @Override
        public void call(MessageRunner runner) {
            ItemPattern pattern = (ItemPattern)runner.getValue("pattern");
            OrbAcquirableItems.blacklist.add(pattern);
            WeightedItemList list = OrbAcquirableItems.idList;
            int size = list.size();
            int damageRemoved = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Pair<Integer, Boolean> info = ((WeightedItem)iter.next()).runBlacklistPattern(pattern);
                if (((Boolean)info.getRight()).booleanValue()) {
                    iter.remove();
                }
                damageRemoved += ((Integer)info.getLeft()).intValue();
            }
            if ((size -= list.size()) == 0 && damageRemoved == 0) {
                MessageLogger.logWarn("Did not find any items to remove.", new Object[0]);
            } else if (size == 0) {
                MessageLogger.logOk("Removed $0 damage value(s) from items.", damageRemoved);
            } else {
                MessageLogger.logOk("Removed $0 item(s) and $1 damage value(s) in total.", size, damageRemoved);
            }
            if (list.size() == 0) {
                MessageLogger.logWarn("No items left in the list, falling back to generic chest loot.", new Object[0]);
            }
        }
    };
    private static final MessageHandler mobAdd = new MessageHandler(){

        @Override
        public void call(MessageRunner runner) {
            Class cls = (Class)EntityList.field_75625_b.get(runner.getString("id"));
            if (IBossDisplayData.class.isAssignableFrom(cls)) {
                MessageLogger.logFail("Cannot add boss mobs to the list.", new Object[0]);
            } else if (OrbSpawnableMobs.classList.add(cls)) {
                MessageLogger.logOk("Added 1 mob to the list.", new Object[0]);
            } else {
                MessageLogger.logFail("The mob was already in the list.", new Object[0]);
            }
        }
    };
    private static final MessageHandler mobRemove = new MessageHandler(){

        @Override
        public void call(MessageRunner runner) {
            if (OrbSpawnableMobs.classList.remove(EntityList.field_75625_b.get(runner.getString("id")))) {
                MessageLogger.logOk("Removed 1 mob from the list.", new Object[0]);
            } else {
                MessageLogger.logFail("The mob was not present in the list.", new Object[0]);
            }
        }
    };

    @Override
    public void register() {
        this.register("HEE:Orb:ItemBlacklist", itemBlacklist, RunEvent.LOADCOMPLETE).addProp("pattern", ItemPatternValue.any());
        this.register("HEE:Orb:MobAdd", mobAdd, RunEvent.LOADCOMPLETE).addProp("id", SpawnEntryValue.livingMobString);
        this.register("HEE:Orb:MobRemove", mobRemove, RunEvent.LOADCOMPLETE).addProp("id", SpawnEntryValue.livingMobString);
    }
}

