/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.render.entity;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.proxy.ModClientProxy;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.render.model.ModelEnderDragon;
import chylex.hee.sound.EndMusicType;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBossDragon
extends RenderLiving {
    private static final ResourceLocation texDragon = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation texDragonEyes = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
    private static final ResourceLocation texCrystalBeam = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    private static final ResourceLocation texDeathExplosions = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");

    public RenderBossDragon() {
        super((ModelBase)new ModelEnderDragon(), 0.5f);
        this.func_77042_a(this.field_77045_g);
    }

    protected void rotateDragonBody(EntityBossDragon dragon, float entityTickTime, float yawOffset, float partialTickTime) {
        GL11.glRotatef((float)(-((float)dragon.getMovementOffsets(7, partialTickTime)[0])), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(10.0f * (float)(dragon.getMovementOffsets(5, partialTickTime)[1] - dragon.getMovementOffsets(10, partialTickTime)[1])), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
        if (dragon.field_70725_aQ > 0) {
            GL11.glRotatef((float)(Math.min(1.0f, MathHelper.func_76129_c((float)(((float)dragon.field_70725_aQ + partialTickTime - 1.0f) / 20.0f * 1.6f))) * this.func_77037_a((EntityLivingBase)dragon)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderDragonModel(EntityBossDragon dragon, float limbSwing, float limbSwingAngle, float entityTickTime, float rotationYaw, float rotationPitch, float unitPixel) {
        if (dragon.deathTicks > 0) {
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)((float)dragon.deathTicks * 0.005f));
            this.func_110776_a(texDeathExplosions);
            this.field_77045_g.func_78088_a((Entity)dragon, limbSwing, limbSwingAngle, entityTickTime, rotationYaw, rotationPitch, unitPixel);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        this.func_110777_b((Entity)dragon);
        this.field_77045_g.func_78088_a((Entity)dragon, limbSwing, limbSwingAngle, entityTickTime, rotationYaw, rotationPitch, unitPixel);
        if (dragon.field_70737_aN > 0) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.field_77045_g.func_78088_a((Entity)dragon, limbSwing, limbSwingAngle, entityTickTime, rotationYaw, rotationPitch, unitPixel);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
        }
    }

    public void renderDragon(EntityBossDragon dragon, double x, double y, double z, float yaw, float partialTickTime) {
        BossStatus.func_82824_a((IBossDisplayData)dragon, (boolean)false);
        BossStatus.field_82827_c = (dragon.isAngry() ? EnumChatFormatting.LIGHT_PURPLE : "") + I18n.func_135052_a((String)dragon.func_70005_c_(), (Object[])new Object[0]);
        EndMusicType.update(dragon.isAngry() ? EndMusicType.DRAGON_ANGRY : EndMusicType.DRAGON_CALM);
        super.func_76986_a((EntityLiving)dragon, x, y, z, yaw, partialTickTime);
        if (dragon.healingEnderCrystal != null) {
            float animRot = (float)dragon.healingEnderCrystal.field_70261_a + partialTickTime;
            float yCorrection = MathHelper.func_76126_a((float)(animRot * 0.2f)) * 0.5f + 0.5f;
            yCorrection = (yCorrection * yCorrection + yCorrection) * 0.2f;
            float diffX = (float)(dragon.healingEnderCrystal.field_70165_t - dragon.field_70165_t - (dragon.field_70169_q - dragon.field_70165_t) * (double)(1.0f - partialTickTime));
            float diffY = (float)((double)yCorrection + dragon.healingEnderCrystal.field_70163_u - 1.0 - dragon.field_70163_u - (dragon.field_70167_r - dragon.field_70163_u) * (double)(1.0f - partialTickTime));
            float diffZ = (float)(dragon.healingEnderCrystal.field_70161_v - dragon.field_70161_v - (dragon.field_70166_s - dragon.field_70161_v) * (double)(1.0f - partialTickTime));
            float distXZ = MathHelper.func_76129_c((float)(diffX * diffX + diffZ * diffZ));
            float distXYZ = MathHelper.func_76129_c((float)(diffX * diffX + diffY * diffY + diffZ * diffZ));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + 2.0f), (float)((float)z));
            GL11.glRotatef((float)(MathUtil.toDeg((float)(-Math.atan2(diffZ, diffX))) - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(MathUtil.toDeg((float)(-Math.atan2(distXZ, diffY))) - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2884);
            this.func_110776_a(texCrystalBeam);
            GL11.glShadeModel((int)7425);
            float animTime = -((float)dragon.field_70173_aa + partialTickTime) * 0.01f;
            float textureV = MathHelper.func_76129_c((float)(diffX * diffX + diffY * diffY + diffZ * diffZ)) * 0.03125f - ((float)dragon.field_70173_aa + partialTickTime) * 0.01f;
            tessellator.func_78371_b(5);
            int sideAmount = 8;
            for (int i = 0; i <= sideAmount; ++i) {
                float f11 = MathHelper.func_76126_a((float)((float)(i % sideAmount) * (float)Math.PI * 2.0f / (float)sideAmount)) * 0.75f;
                float f12 = MathHelper.func_76134_b((float)((float)(i % sideAmount) * (float)Math.PI * 2.0f / (float)sideAmount)) * 0.75f;
                float f13 = i % sideAmount / sideAmount;
                tessellator.func_78378_d(0);
                tessellator.func_78374_a((double)(f11 * 0.2f), (double)(f12 * 0.2f), 0.0, (double)f13, (double)textureV);
                tessellator.func_78378_d(0xFFFFFF);
                tessellator.func_78374_a((double)f11, (double)f12, (double)distXYZ, (double)f13, (double)animTime);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    protected void renderDragonDying(EntityBossDragon dragon, float partialTickTime) {
        super.func_77029_c((EntityLivingBase)dragon, partialTickTime);
        if (dragon.deathTicks > 0) {
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderHelper.func_74518_a();
            float animPerc = ((float)dragon.deathTicks + partialTickTime) * 0.005f;
            float fade = animPerc > 0.8f ? (animPerc - 0.8f) * 5.0f : 0.0f;
            Random rand = ModClientProxy.seedableRand;
            rand.setSeed(432L);
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)-2.0f);
            int beam = 0;
            while ((float)beam < (animPerc + animPerc * animPerc) / 2.0f * 60.0f) {
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(rand.nextFloat() * 360.0f + animPerc * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.func_78371_b(6);
                float yRot = rand.nextFloat() * 20.0f + 5.0f + fade * 10.0f;
                float xzRot = rand.nextFloat() * 2.0f + 1.0f + fade * 2.0f;
                tessellator.func_78384_a(0xFFFFFF, (int)(255.0f * (1.0f - fade)));
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78384_a(0xFF00FF, 0);
                tessellator.func_78377_a(-0.866 * (double)xzRot, (double)yRot, (double)(-0.5f * xzRot));
                tessellator.func_78377_a(0.866 * (double)xzRot, (double)yRot, (double)(-0.5f * xzRot));
                tessellator.func_78377_a(0.0, (double)yRot, (double)xzRot);
                tessellator.func_78377_a(-0.866 * (double)xzRot, (double)yRot, (double)(-0.5f * xzRot));
                tessellator.func_78381_a();
                ++beam;
            }
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glShadeModel((int)7424);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            RenderHelper.func_74519_b();
        }
    }

    protected int renderGlow(EntityBossDragon dragon, int pass, float partialTickTime) {
        if (pass == 1) {
            GL11.glDepthFunc((int)515);
        }
        if (pass != 0 || ModCommonProxy.hardcoreEnderbacon) {
            return -1;
        }
        this.func_110776_a(texDragonEyes);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthFunc((int)514);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return 1;
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderDragon((EntityBossDragon)entity, x, y, z, yaw, partialTickTime);
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float partialTickTime) {
        return this.renderGlow((EntityBossDragon)entity, pass, partialTickTime);
    }

    protected void func_77029_c(EntityLivingBase entity, float partialTickTime) {
        this.renderDragonDying((EntityBossDragon)entity, partialTickTime);
    }

    protected void func_77043_a(EntityLivingBase entity, float entityTickTime, float yawOffset, float partialTickTime) {
        this.rotateDragonBody((EntityBossDragon)entity, entityTickTime, yawOffset, partialTickTime);
    }

    protected void func_77036_a(EntityLivingBase entity, float limbSwing, float limbSwingAngle, float entityTickTime, float rotationYaw, float rotationPitch, float unitPixel) {
        this.renderDragonModel((EntityBossDragon)entity, limbSwing, limbSwingAngle, entityTickTime, rotationYaw, rotationPitch, unitPixel);
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderDragon((EntityBossDragon)entity, x, y, z, yaw, partialTickTime);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return Baconizer.mobTexture((Render)this, texDragon);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderDragon((EntityBossDragon)entity, x, y, z, yaw, partialTickTime);
    }
}

