/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.integration;

import chylex.hee.system.integration.IIntegrationHandler;
import chylex.hee.system.integration.handlers.MineFactoryReloadedIntegration;
import chylex.hee.system.integration.handlers.NotEnoughItemsIntegration;
import chylex.hee.system.integration.handlers.ThaumcraftIntegration;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import cpw.mods.fml.common.Loader;
import java.util.HashSet;
import java.util.Set;

public final class ModIntegrationManager {
    public static final Set<String> blacklistedMods = new HashSet<String>();

    public static final void integrateMods() {
        Class[] handlerClasses;
        Stopwatch.time("ModIntegrationManager - integrateMods");
        for (Class cls : handlerClasses = new Class[]{NotEnoughItemsIntegration.class, ThaumcraftIntegration.class, MineFactoryReloadedIntegration.class}) {
            try {
                IIntegrationHandler handler = (IIntegrationHandler)cls.newInstance();
                String modId = handler.getModId();
                if (!Loader.isModLoaded((String)modId) || blacklistedMods.contains(modId)) continue;
                handler.integrate();
            }
            catch (Throwable e) {
                Log.throwable(e, "Unable to integrate with mod $0.", cls.getSimpleName());
            }
        }
        Stopwatch.finish("ModIntegrationManager - integrateMods");
    }
}

