/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message;

import chylex.hee.api.message.MessageHandler;
import chylex.hee.api.message.MessagePattern;
import chylex.hee.api.message.handlers.ImcHandler;
import chylex.hee.api.message.utils.MessageLogger;
import chylex.hee.api.message.utils.RunEvent;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public final class MessageRegistry {
    private static Map<String, MessagePattern> registry = new HashMap<String, MessagePattern>();
    private static Map<String, RunEvent> events = new HashMap<String, RunEvent>();

    public static MessagePattern register(String key, MessageHandler handler, RunEvent event) {
        MessagePattern pattern = new MessagePattern(handler);
        if (registry.put(key, pattern) != null) {
            throw new IllegalArgumentException("Cannot register duplicate IMC message key: " + key);
        }
        events.put(key, event);
        return pattern;
    }

    public static boolean runMessage(String key, NBTTagCompound root) {
        MessagePattern pattern = registry.get(key);
        if (pattern == null) {
            MessageLogger.logError("Message key not found: $0", key);
            return false;
        }
        return pattern.tryRun(root);
    }

    public static boolean canRunInEvent(String key, RunEvent event) {
        return events.get(key) == event || event == null;
    }

    private MessageRegistry() {
    }

    static {
        ImcHandler.loadHandlers();
        registry = ImmutableMap.copyOf(registry);
        events = ImmutableMap.copyOf(events);
    }
}

