/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.common.Helpers;
import gravisuite.proxy.ServerProxy;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public abstract class ItemToolLevelable
extends ItemTool {
    private static double _mXPGainFactor = 100000.0;

    protected ItemToolLevelable(float p_i45333_1_, Item.ToolMaterial p_i45333_2_, Set p_i45333_3_) {
        super(p_i45333_1_, p_i45333_2_, p_i45333_3_);
    }

    public static void AddXP(EntityPlayer pPlayer, ItemStack pItemStack, int pAmount) {
        int tNextLevel;
        double tCurrentXP = ItemToolLevelable.readToolXP(pItemStack);
        int tCurrLevel = ItemToolLevelable.getLevel(tCurrentXP);
        if (Double.MAX_VALUE - tCurrentXP >= (double)pAmount) {
            tCurrentXP += (double)pAmount;
        }
        if ((tNextLevel = ItemToolLevelable.getLevel(tCurrentXP)) > tCurrLevel) {
            String tLevelup = String.format("%s%s", EnumChatFormatting.GOLD, Helpers.formatMessage("message.xp.levelup"));
            ServerProxy.sendPlayerMessage(pPlayer, tLevelup);
        }
        ItemToolLevelable.saveToolXP(pItemStack, tCurrentXP);
    }

    public boolean hasMaxLevel(ItemStack pItemStack) {
        return ItemToolLevelable.getLevel(pItemStack) >= this.getMaxLevel();
    }

    public void setXP(ItemStack pItemStack, double pXP) {
        double tTargetXP = Math.min((double)ItemToolLevelable.getXPForLevel(this.getMaxLevel()), pXP);
        ItemToolLevelable.saveToolXP(pItemStack, tTargetXP);
    }

    public void setLevel(ItemStack pItemStack, int pLevel) {
        int tTargetLevel = Math.min(this.getMaxLevel(), pLevel);
        double toolXP = ItemToolLevelable.getXPForLevel(tTargetLevel);
        ItemToolLevelable.saveToolXP(pItemStack, toolXP);
    }

    public abstract int getMaxLevel();

    public static int getLevel(double pXPValue) {
        return new Double(Math.floor(Math.sqrt(pXPValue / _mXPGainFactor))).intValue();
    }

    public static int getLevel(ItemStack pItemStack) {
        return ItemToolLevelable.getLevel(ItemToolLevelable.readToolXP(pItemStack));
    }

    public static boolean hasLevel(ItemStack pItemStack, int pLevel) {
        return ItemToolLevelable.getLevel(pItemStack) >= pLevel;
    }

    private static double readToolXP(ItemStack pItemStack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(pItemStack);
        double toolXP = nbttagcompound.func_74769_h("toolXP");
        return toolXP;
    }

    public static int getXPForLevel(int pLevel) {
        return (int)(_mXPGainFactor * (double)pLevel * (double)pLevel);
    }

    private static int readToolXPInt(ItemStack pItemStack) {
        return new Double(ItemToolLevelable.readToolXP(pItemStack)).intValue();
    }

    private static void saveToolXP(ItemStack pItemStack, double pToolXP) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(pItemStack);
        nbttagcompound.func_74780_a("toolXP", pToolXP);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pList, boolean par4) {
        super.func_77624_a(pItemStack, pPlayer, pList, par4);
        if (Keyboard.isKeyDown((int)42)) {
            int tCurrentTotalXP = ItemToolLevelable.readToolXPInt(pItemStack);
            int tCurrentLevel = ItemToolLevelable.getLevel(pItemStack);
            if (this.getMaxLevel() > tCurrentLevel) {
                pList.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.xp.youhavecollected") + ": " + EnumChatFormatting.WHITE + tCurrentTotalXP);
                pList.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.xp.nextLevelUp") + ": " + EnumChatFormatting.WHITE + ItemToolLevelable.getXPForLevel(ItemToolLevelable.getLevel(pItemStack) + 1));
                pList.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.xp.toolLevel") + ": " + EnumChatFormatting.WHITE + tCurrentLevel);
            } else {
                pList.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.xp.maxLevelReached"));
            }
        }
    }
}

