/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.tools;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.EntityPlasmaBall;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.common.Helpers;
import gravisuite.keyboard.Keyboard;
import gravisuite.proxy.ServerProxy;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemRelocator
extends ItemTool
implements IElectricItem {
    private final double maxCharge;
    private final int tier;
    private final int transferLimit;
    private final int energyPerStandartTp;
    private int energyPerDimesionTp;
    private final int energyPerPortal;
    private final int energyPerShoot;
    public static final int maxPoints = 10;
    public static final String nbt_tpList_name = "nbt_tpList_name";
    public static final String nbt_tpList_dimID = "nbt_tpList_dimID";
    public static final String nbt_tpList_pointName = "nbt_tpList_pointName";
    public static final String nbt_tpList_xPos = "nbt_tpList_xPos";
    public static final String nbt_tpList_yPos = "nbt_tpList_yPos";
    public static final String nbt_tpList_zPos = "nbt_tpList_zPos";
    public static final String nbt_tpList_yaw = "nbt_tpList_yaw";
    public static final String nbt_tpList_pitch = "nbt_tpList_pitch";
    public static final String nbt_tpList_defPoint = "nbt_tpList_defPoint";

    public ItemRelocator(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.maxCharge = GraviProperties.ElectricPreSets.Relocator.MaxCharge;
        this.energyPerStandartTp = GraviSuite.relocatorEnergyPerStandartTp;
        this.energyPerDimesionTp = GraviSuite.relocatorEnergyPerDimesionTp;
        this.energyPerPortal = GraviSuite.relocatorEnergyPerPortal;
        this.energyPerShoot = GraviSuite.relocatorEnergyPerTranslocator;
        if ((double)(this.energyPerDimesionTp * 2) > this.maxCharge) {
            this.energyPerDimesionTp = new Double(this.maxCharge / 2.0 - 100.0).intValue();
        }
        this.tier = GraviProperties.ElectricPreSets.Relocator.Tier;
        this.transferLimit = GraviProperties.ElectricPreSets.Relocator.TransferLimit;
        this.func_77656_e(27);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            Integer toolMode = ItemRelocator.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 2) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.relocator.mode.personal"));
            }
            if (toolMode == 1) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.relocator.mode.translocator"));
            }
            if (toolMode == 2) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.AQUA + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.relocator.mode.portal"));
            }
            return itemStack;
        }
        Integer toolMode = ItemRelocator.readToolMode(itemStack);
        if (player.func_70093_af()) {
            if (toolMode == 1 || toolMode == 2) {
                player.openGui((Object)GraviSuite.instance, 3, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                player.openGui((Object)GraviSuite.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        } else if (toolMode == 0) {
            player.openGui((Object)GraviSuite.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else if (toolMode == 1 || toolMode == 2) {
            TeleportPoint tpPoint = ItemRelocator.getDefaultPoint(itemStack);
            if (tpPoint != null) {
                int energyPerOperation = 0;
                byte launchType = 0;
                if (toolMode == 1) {
                    energyPerOperation = this.energyPerShoot;
                    launchType = 0;
                    if (GraviSuite.disableRelocatorTranslocator) {
                        ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.relocator.text.modeTranslocatorDisabled"));
                        return itemStack;
                    }
                } else {
                    energyPerOperation = this.energyPerPortal;
                    launchType = 1;
                    if (GraviSuite.disableRelocatorPortal) {
                        ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.relocator.text.modePortalDisabled"));
                        return itemStack;
                    }
                }
                if (ElectricItem.manager.canUse(itemStack, (double)energyPerOperation) || player.field_71075_bZ.field_75098_d) {
                    if (GraviSuite.isSimulating() && !player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.use(itemStack, (double)energyPerOperation, (EntityLivingBase)player);
                    }
                    EntityPlasmaBall plasmaBall = new EntityPlasmaBall(world, (EntityLivingBase)player, tpPoint, launchType);
                    if (GraviSuite.isSimulating()) {
                        world.func_72838_d((Entity)plasmaBall);
                    }
                    player.func_71038_i();
                } else {
                    ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.text.noenergy"));
                }
            } else {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.relocator.text.noDefaultPoint"));
            }
        }
        return itemStack;
    }

    public static List<TeleportPoint> loadTeleportPoints(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList list = itemStack.field_77990_d.func_150295_c(nbt_tpList_name, 10);
        ArrayList tpList = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            TeleportPoint newPoint = new TeleportPoint();
            NBTTagCompound loadedPoint = list.func_150305_b(i);
            newPoint.pointName = loadedPoint.func_74779_i(nbt_tpList_pointName);
            newPoint.dimID = loadedPoint.func_74762_e(nbt_tpList_dimID);
            newPoint.x = loadedPoint.func_74769_h(nbt_tpList_xPos);
            newPoint.y = loadedPoint.func_74769_h(nbt_tpList_yPos);
            newPoint.z = loadedPoint.func_74769_h(nbt_tpList_zPos);
            newPoint.yaw = loadedPoint.func_74769_h(nbt_tpList_yaw);
            newPoint.pitch = loadedPoint.func_74769_h(nbt_tpList_pitch);
            newPoint.defPoint = loadedPoint.func_74767_n(nbt_tpList_defPoint);
            tpList.add(newPoint);
        }
        return tpList;
    }

    public static void saveTeleportPoints(ItemStack itemStack, List<TeleportPoint> tpList) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList nbtList = new NBTTagList();
        for (TeleportPoint point : tpList) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a(nbt_tpList_pointName, point.pointName);
            nbt.func_74768_a(nbt_tpList_dimID, point.dimID);
            nbt.func_74780_a(nbt_tpList_xPos, point.x);
            nbt.func_74780_a(nbt_tpList_yPos, point.y);
            nbt.func_74780_a(nbt_tpList_zPos, point.z);
            nbt.func_74780_a(nbt_tpList_yaw, point.yaw);
            nbt.func_74780_a(nbt_tpList_pitch, point.pitch);
            nbt.func_74757_a(nbt_tpList_defPoint, point.defPoint);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        itemStack.func_77978_p().func_74782_a(nbt_tpList_name, (NBTBase)nbtList);
    }

    public static void addNewTeleportPoint(EntityPlayer player, ItemStack itemStack, TeleportPoint newPoint) {
        if (itemStack == null || newPoint == null) {
            return;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        Boolean pointExists = false;
        for (TeleportPoint point : tpList) {
            if (!point.pointName.equalsIgnoreCase(newPoint.pointName)) continue;
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + newPoint.pointName + " " + EnumChatFormatting.RED + Helpers.formatMessage("message.relocator.text.pointExists"));
            pointExists = true;
            return;
        }
        if (!pointExists.booleanValue()) {
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + newPoint.pointName + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.relocator.text.poindAdded"));
            tpList.add(newPoint);
            ItemRelocator.saveTeleportPoints(itemStack, tpList);
        }
    }

    public static TeleportPoint getDefaultPoint(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        for (TeleportPoint point : tpList) {
            if (!point.defPoint) continue;
            return point;
        }
        return null;
    }

    public static Boolean setDefaultPoint(EntityPlayer player, ItemStack itemStack, String ptName) {
        if (itemStack == null) {
            return false;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        Boolean pointExists = false;
        for (TeleportPoint point : tpList) {
            if (point.pointName.equalsIgnoreCase(ptName)) {
                point.defPoint = true;
                pointExists = true;
                continue;
            }
            point.defPoint = false;
        }
        if (pointExists.booleanValue()) {
            ItemRelocator.saveTeleportPoints(itemStack, tpList);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.WHITE + Helpers.formatMessage("message.relocator.text.defaultPointSet") + " " + EnumChatFormatting.YELLOW + ptName);
        } else {
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.relocator.text.noPoint"));
        }
        return null;
    }

    public static TeleportPoint getTeleportPointByName(ItemStack itemStack, String ptName) {
        if (itemStack == null || ptName == "") {
            return null;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        for (TeleportPoint point : tpList) {
            if (!point.pointName.equalsIgnoreCase(ptName)) continue;
            return point;
        }
        return null;
    }

    public static void removeTeleportPoint(ItemStack itemStack, String tpName) {
        if (itemStack == null) {
            return;
        }
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(itemStack));
        for (int i = 0; i < tpList.size(); ++i) {
            TeleportPoint tmpPoint = (TeleportPoint)tpList.get(i);
            if (!tmpPoint.pointName.equalsIgnoreCase(tpName)) continue;
            tpList.remove(i);
            ItemRelocator.saveTeleportPoints(itemStack, tpList);
            FMLLog.info((String)"Point deleted: %s", (Object[])new Object[]{tmpPoint.pointName});
            return;
        }
    }

    public void teleportPlayer(EntityPlayer player, ItemStack itemStack, String tpName) {
        if (itemStack == null || player == null) {
            return;
        }
        TeleportPoint point = ItemRelocator.getTeleportPointByName(itemStack, tpName);
        if (point == null) {
            return;
        }
        int currentDim = player.field_70170_p.field_73011_w.field_76574_g;
        int energyPerOperation = currentDim == point.dimID ? this.energyPerStandartTp : this.energyPerDimesionTp;
        if (ElectricItem.manager.canUse(itemStack, (double)energyPerOperation) || player.field_71075_bZ.field_75098_d) {
            if (GraviSuite.isSimulating() && !player.field_71075_bZ.field_75098_d) {
                ElectricItem.manager.use(itemStack, (double)energyPerOperation, (EntityLivingBase)player);
            }
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.relocator.text.teleportingnow") + " " + EnumChatFormatting.GREEN + point.pointName);
            Helpers.teleportEntity((Entity)player, point);
        } else {
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.text.noenergy"));
        }
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 3) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        TeleportPoint tpPoint;
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemRelocator.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.relocator.mode.personal"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.relocator.mode.translocator"));
        }
        if (toolMode == 2) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.relocator.mode.portal"));
        }
        if ((tpPoint = ItemRelocator.getDefaultPoint(par1ItemStack)) != null) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.relocator.defPoint") + ": " + EnumChatFormatting.WHITE + tpPoint.pointName);
        } else {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.relocator.defPoint") + ": -");
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemRelocator");
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public static class TeleportPoint {
        public int dimID;
        public String pointName;
        public double x;
        public double y;
        public double z;
        public double yaw;
        public double pitch;
        public boolean defPoint;
    }
}

