/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.EntityPlasmaBall;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.GuiHandler;
import gravisuite.common.GraviRegistry;
import gravisuite.common.Helpers;
import gravisuite.common.ICustomItemBars;
import gravisuite.common.InventoryItem;
import gravisuite.items.ItemPlasmaCell;
import gravisuite.proxy.ServerProxy;
import ic2.api.item.ElectricItem;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemPlasmaLauncher
extends Item
implements ICustomItemBars {
    public static int _mPowerPerMaxShot;
    private IIcon iconLauncher;
    private static final int _mPlasmaAmountPerShot = 1000;
    private static GraviRegistry _mReg;

    public ItemPlasmaLauncher() {
        _mPowerPerMaxShot = GraviProperties.ElectricPreSets.PlasmaLauncher.EnergyPerOperation;
        this.func_77637_a(GraviSuite._mGraviCreativeTab);
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack pItemStack, World pWorld, EntityPlayer pPlayer) {
        if (!pWorld.field_72995_K && pPlayer.func_70093_af()) {
            pPlayer.openGui((Object)GraviSuite.instance, GuiHandler.GUIID_PLASMALAUNCHER, pWorld, (int)pPlayer.field_70165_t, (int)pPlayer.field_70163_u, (int)pPlayer.field_70161_v);
            return pItemStack;
        }
        ItemStack tAmmoStack = this.getAmmunition(pItemStack);
        if (tAmmoStack == null) {
            ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.plasmaLauncher.noPlasmaCellFound"));
            return pItemStack;
        }
        FluidStack tPlasma = ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getFluid(tAmmoStack);
        if (tPlasma == null) {
            ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.plasmaLauncher.PlasmaCellEmpty"));
            return pItemStack;
        }
        if (tPlasma.amount < 1000) {
            ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.plasmaLauncher.NotEnoughPlasma"));
            return pItemStack;
        }
        ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).drain(tAmmoStack, 1000, true);
        float tPlasmaEnergyAmount = _mReg.getPlasmaEfficiency(tPlasma) / 100.0f;
        tPlasmaEnergyAmount = Math.min(100.0f, tPlasmaEnergyAmount);
        if (ElectricItem.manager.canUse(tAmmoStack, (double)_mPowerPerMaxShot)) {
            EntityPlasmaBall plasmaBall = new EntityPlasmaBall(pWorld, (EntityLivingBase)pPlayer, tPlasmaEnergyAmount, 2);
            if (!pWorld.field_72995_K) {
                ElectricItem.manager.discharge(tAmmoStack, (double)_mPowerPerMaxShot, 99, true, false, false);
                pWorld.func_72838_d((Entity)plasmaBall);
                ItemPlasmaLauncher.notifyWorldPlasmaFired(pPlayer);
            }
            pPlayer.func_71038_i();
        } else {
            ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.plasmaLauncher.noEnergy"));
        }
        return pItemStack;
    }

    private static void notifyWorldPlasmaFired(EntityPlayer pEp) {
        pEp.field_70170_p.func_72956_a((Entity)pEp, "gravisuite:plasmaFired", 1.25f, 1.0f);
    }

    public ItemStack getAmmunition(ItemStack pItemStack) {
        ItemStack tReturn = null;
        InventoryItem invi = new InventoryItem(pItemStack);
        ItemStack ammoStack = invi.func_70301_a(0);
        if (ammoStack != null) {
            tReturn = ammoStack;
        }
        return tReturn;
    }

    public boolean hasAmmunition(ItemStack pItemStack) {
        return this.getAmmunition(pItemStack) != null;
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pInfo, boolean pSomethingBooleanIhaveNoIdeaWhatItDoes) {
        if (this.hasAmmunition(pItemStack)) {
            pInfo.addAll(ItemPlasmaCell.getToolTipInfo(this.getAmmunition(pItemStack)));
        } else {
            pInfo.add("No PlasmaCell loaded or PlasmaCell depleted");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = this.iconLauncher = par1IconRegister.func_94245_a("gravisuite:PlasmaCannon_0");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.iconLauncher;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack pItemStack, int pRenderPass, EntityPlayer pPlayer, ItemStack pUsingItem, int pUseRemaining) {
        return this.iconLauncher;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public int getNumBars(ItemStack pItemStack) {
        int tRet = this.hasAmmunition(pItemStack) ? 2 : 0;
        return tRet;
    }

    @Override
    public Color getColorForMinValue(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getColorForMinValue(this.getAmmunition(pItemStack), pBarIndex);
    }

    @Override
    public Color getColorForMaxValue(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getColorForMaxValue(this.getAmmunition(pItemStack), pBarIndex);
    }

    @Override
    public double getMaxValue(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getMaxValue(this.getAmmunition(pItemStack), pBarIndex);
    }

    @Override
    public double getValueForBar(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getValueForBar(this.getAmmunition(pItemStack), pBarIndex);
    }

    @Override
    public ICustomItemBars.BAR_ALIGNMENT getBarAlignment() {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getBarAlignment();
    }

    @Override
    public int getBarThickness(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getBarThickness(this.getAmmunition(pItemStack), pBarIndex);
    }

    @Override
    public boolean getIsBarInverted(ItemStack pItemStack, int pBarIndex) {
        return ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getIsBarInverted(this.getAmmunition(pItemStack), pBarIndex);
    }

    static {
        _mReg = GraviRegistry.getInstance();
    }
}

