/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.tools;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.common.Helpers;
import gravisuite.keyboard.Keyboard;
import gravisuite.proxy.ServerProxy;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ItemAdvChainsaw
extends ItemTool
implements IElectricItem {
    private final int maxCharge;
    private final int tier;
    private final float effPower;
    private final int energyPerOperation;
    private final int transferLimit;
    public Set mineableBlocks = new HashSet();
    public int soundTicker;
    public int field_77865_bY;
    private Random rnd = new Random();
    private int _mHarvestLevelAxe;

    public ItemAdvChainsaw(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.maxCharge = GraviProperties.ElectricPreSets.AdvChainsaw.MaxCharge;
        this.transferLimit = GraviProperties.ElectricPreSets.AdvChainsaw.TransferLimit;
        this.tier = GraviProperties.ElectricPreSets.AdvChainsaw.Tier;
        this.field_77864_a = this.effPower = 30.0f;
        this.energyPerOperation = GraviProperties.ElectricPreSets.AdvChainsaw.EnergyPerOperation;
        this.field_77865_bY = 1;
        this.func_77637_a(GraviSuite._mGraviCreativeTab);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this._mHarvestLevelAxe = toolMaterial.func_77996_d();
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150344_f);
        this.mineableBlocks.add(Blocks.field_150342_X);
        this.mineableBlocks.add(Blocks.field_150376_bx);
        this.mineableBlocks.add(Blocks.field_150486_ae);
        this.mineableBlocks.add(Blocks.field_150362_t);
        this.mineableBlocks.add(Blocks.field_150321_G);
        this.mineableBlocks.add(Blocks.field_150325_L);
        this.mineableBlocks.add(Blocks.field_150423_aK);
        this.mineableBlocks.add(Blocks.field_150440_ba);
        this.mineableBlocks.add(Blocks.field_150434_aF);
        this.mineableBlocks.add(Blocks.field_150433_aE);
        ItemStack tmpItem = IC2Items.getItem((String)"rubberLeaves");
        if (tmpItem != null) {
            this.mineableBlocks.add(tmpItem);
        }
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(block, stack) || Items.field_151056_x.func_150893_a(stack, block) > 1.0f || Items.field_151048_u.canHarvestBlock(block, stack) || Items.field_151048_u.func_150893_a(stack, block) > 1.0f || this.mineableBlocks.contains(block);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass.equals("axe")) {
            return this._mHarvestLevelAxe;
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (toolClass.equals("axe")) {
            this._mHarvestLevelAxe = level;
        }
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, (double)this.energyPerOperation)) {
            return 0.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe");
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, attacker)) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 13.0f);
        } else {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (GraviSuite.isSimulating()) {
            IShearable target;
            Entity entity = event.target;
            EntityPlayer player = event.entityPlayer;
            ItemStack itemstack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
            if (itemstack != null && itemstack.func_77973_b() == this && entity instanceof IShearable && ItemAdvChainsaw.readToolMode(itemstack) == 1 && ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, (EntityLivingBase)player) && (target = (IShearable)entity).isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack stack = (ItemStack)drops.get(i);
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(field_77697_d.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                }
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        Block block;
        if (!GraviSuite.isSimulating()) {
            return false;
        }
        if (ItemAdvChainsaw.readToolMode(itemstack) == 0 && (block = player.field_70170_p.func_147439_a(x, y, z)) instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, x, y, z) && ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, (EntityLivingBase)player)) {
            this.PlayRandomChainSawSound(player);
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = (ItemStack)drops.get(i);
                float f = 0.7f;
                double d = (double)(field_77697_d.nextFloat() * 0.7f) + (double)0.15f;
                double d1 = (double)(field_77697_d.nextFloat() * 0.7f) + (double)0.15f;
                double d2 = (double)(field_77697_d.nextFloat() * 0.7f) + (double)0.15f;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        if (ItemAdvChainsaw.readToolMode(itemstack) == 2) {
            World world = player.field_70170_p;
            Block wood = world.func_147439_a(x, y, z);
            if (wood == null) {
                return true;
            }
            if (!ElectricItem.manager.canUse(itemstack, (double)(this.energyPerOperation * 10))) {
                return true;
            }
            if ((wood.isWood((IBlockAccess)world, x, y, z) || wood.func_149688_o() == Material.field_151583_m) && this.detectTree(world, x, y, z, wood)) {
                int meta = world.func_72805_g(x, y, z);
                this.breakTree(world, x, y, z, x, y, z, itemstack, wood, meta, player);
                return true;
            }
        }
        return false;
    }

    private void PlayRandomChainSawSound(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "gravisuite:chainsaw", 1.25f, 1.0f);
    }

    private void breakTree(World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack stack, Block bID, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    Block localBlock;
                    if (!ElectricItem.manager.use(stack, (double)this.energyPerOperation, (EntityLivingBase)player) || bID != (localBlock = world.func_147439_a(xPos, yPos, zPos))) continue;
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    int hlvl = localBlock.getHarvestLevel(localMeta);
                    float localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                    boolean cancelHarvest = false;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, world, localBlock, localMeta, player);
                    event.setCanceled(cancelHarvest);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    cancelHarvest = event.isCanceled();
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500) continue;
                    if (cancelHarvest) {
                        this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, bID, meta, player);
                        continue;
                    }
                    if (localBlock != bID || localMeta % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_149636_a(world, player, x, y, z, localMeta);
                        this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    world.func_147468_f(xPos, yPos, zPos);
                    if (world.field_72995_K) continue;
                    this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, bID, meta, player);
                }
            }
        }
    }

    private boolean detectTree(World world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_147439_a(x, ++height, z)) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block leaves = world.func_147439_a(xPos, yPos, zPos);
                        if (leaves == null || !leaves.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedChainsaw");
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block block, int xPos, int yPos, int zPos, EntityLivingBase par7EntityLiving) {
        if ((double)block.func_149712_f(par2World, xPos, yPos, zPos) != 0.0) {
            if (par7EntityLiving != null) {
                ElectricItem.manager.use(par1ItemStack, (double)this.energyPerOperation, par7EntityLiving);
            } else {
                ElectricItem.manager.discharge(par1ItemStack, (double)this.energyPerOperation, this.tier, true, false, false);
            }
        }
        return true;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 2) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            Integer toolMode;
            Integer n = toolMode = ItemAdvChainsaw.readToolMode(itemStack);
            Integer n2 = toolMode = Integer.valueOf(toolMode + 1);
            if (toolMode > 2) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            String tBaseMessage = String.format("%s%s: ", EnumChatFormatting.GREEN, Helpers.formatMessage("message.text.mode"));
            String tModeMessage = "%s%s";
            if (toolMode == 0) {
                tModeMessage = String.format(tModeMessage, EnumChatFormatting.GREEN, Helpers.formatMessage("message.advChainsaw.mode.axe"));
            }
            if (toolMode == 1) {
                tModeMessage = String.format(tModeMessage, EnumChatFormatting.GOLD, Helpers.formatMessage("message.advChainsaw.mode.shear"));
            }
            if (toolMode == 2) {
                tModeMessage = String.format(tModeMessage, EnumChatFormatting.AQUA, Helpers.formatMessage("message.advChainsaw.mode.treecapitator"));
            }
            ServerProxy.sendPlayerMessage(player, String.format("%s%s", tBaseMessage, tModeMessage));
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemAdvChainsaw.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advChainsaw.mode.axe"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advChainsaw.mode.shear"));
        }
        if (toolMode == 2) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advChainsaw.mode.treecapitator"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

