/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.client.fx.FXQuantumShield;
import gravisuite.network.IPacket;
import gravisuite.network.PacketHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketQuantumShield
extends IPacket {
    private int _mSource;
    private int _mTarget;

    public PacketQuantumShield() {
        this.packetID = 3;
    }

    public PacketQuantumShield(int pSource, int pTarget) {
        this();
        this._mSource = pSource;
        this._mTarget = pTarget;
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this._mSource = data.readInt();
        this._mTarget = data.readInt();
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this._mSource);
        data.writeInt(this._mTarget);
    }

    public static void issue(int pSource, int pTarget) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(3);
            os.writeInt(pSource);
            os.writeInt(pTarget);
            os.close();
            PacketHandler.sendPacket(buffer.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void execute(EntityPlayer player) {
        Minecraft tMC = FMLClientHandler.instance().getClient();
        Entity p = tMC.field_71441_e.func_73045_a(this._mSource);
        if (p == null || tMC == null) {
            return;
        }
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (this._mTarget >= 0) {
            Entity t = tMC.field_71441_e.func_73045_a(this._mTarget);
            if (t != null) {
                float f1;
                double d0 = p.field_70165_t - t.field_70165_t;
                double d1 = (p.field_70121_D.field_72338_b + p.field_70121_D.field_72337_e) / 2.0 - (t.field_70121_D.field_72338_b + t.field_70121_D.field_72337_e) / 2.0;
                double d2 = p.field_70161_v - t.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                pitch = f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
                yaw = f;
            } else {
                pitch = 90.0f;
                yaw = 0.0f;
            }
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, yaw, pitch, FXQuantumShield.EShieldMode.Impact);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        } else if (this._mTarget == -1) {
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 90.0f, FXQuantumShield.EShieldMode.Impact);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
            qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 270.0f, FXQuantumShield.EShieldMode.Impact);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        } else if (this._mTarget == -2) {
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 270.0f, FXQuantumShield.EShieldMode.Impact);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        } else if (this._mTarget == -3) {
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 90.0f, FXQuantumShield.EShieldMode.Impact);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        } else if (this._mTarget == -4) {
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 90.0f, FXQuantumShield.EShieldMode.PowerUp);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
            qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 270.0f, FXQuantumShield.EShieldMode.PowerUp);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        } else if (this._mTarget == -5) {
            FXQuantumShield qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 90.0f, FXQuantumShield.EShieldMode.PowerDown);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
            qs = new FXQuantumShield((World)tMC.field_71441_e, p.field_70165_t, p.field_70163_u, p.field_70161_v, p, 8, 0.0f, 270.0f, FXQuantumShield.EShieldMode.PowerDown);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)qs);
        }
    }
}

