/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.keyboard;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.armor.ItemAdvancedJetPack;
import gravisuite.common.Helpers;
import gravisuite.keyboard.Keyboard;
import gravisuite.lappacks.ItemAdvancedLappack;
import gravisuite.network.PacketKeyPress;
import gravisuite.network.PacketKeyboardUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Configuration;

@SideOnly(value=Side.CLIENT)
public class KeyboardClient
extends Keyboard {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static KeyBinding flyKey = new KeyBinding("Gravi Fly Key", 33, "GraviSuite");
    public static KeyBinding displayHUDKey = new KeyBinding("Gravi Display Hud", 35, "GraviSuite");
    public static KeyBinding medicalKey = new KeyBinding("GraviSuite MedKit", 23, "GraviSuite");
    private static int lastKeyState = 0;
    private static boolean lastKeyModeState = false;
    public static int icBoostKeyID;
    public static int icAltKeyID;
    public static int icModeKeyID;
    public static float moveStrafe;
    public static float moveForward;

    public static void registerKeys() {
        ClientRegistry.registerKeyBinding((KeyBinding)flyKey);
        ClientRegistry.registerKeyBinding((KeyBinding)displayHUDKey);
        ClientRegistry.registerKeyBinding((KeyBinding)medicalKey);
    }

    public static void medicalKeyPressed() {
        ItemStack itemstack = KeyboardClient.mc.field_71439_g.field_71071_by.func_70440_f(2);
        if (itemstack != null && itemstack.func_77973_b() == GraviSuite.graviChestPlate) {
            PacketKeyPress.issue(4);
        }
    }

    public static void keyFlyPressed() {
        if (KeyboardClient.mc.field_71415_G) {
            ItemStack itemstack = KeyboardClient.mc.field_71439_g.field_71071_by.func_70440_f(2);
            if (itemstack != null && itemstack.func_77973_b() == GraviSuite.graviChestPlate) {
                PacketKeyPress.issue(1);
            }
            if (itemstack != null && (itemstack.func_77973_b() == GraviSuite.advJetpack || itemstack.func_77973_b() == GraviSuite.advNanoChestPlate)) {
                PacketKeyPress.issue(1);
            }
        }
    }

    public static void keyHudDisplayPressed() {
        ItemStack itemstack;
        if (KeyboardClient.mc.field_71415_G && (itemstack = KeyboardClient.mc.field_71439_g.field_71071_by.func_70440_f(2)) != null && (itemstack.func_77973_b() == GraviSuite.graviChestPlate || itemstack.func_77973_b() instanceof ItemAdvancedJetPack || itemstack.func_77973_b() instanceof ItemAdvancedLappack)) {
            if (KeyboardClient.isAltKeyDown((EntityPlayer)KeyboardClient.mc.field_71439_g)) {
                KeyboardClient.SwitchDisplayHud(false);
            } else {
                KeyboardClient.SwitchDisplayHud(true);
            }
        }
    }

    public static boolean isBoostKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74324_K[icBoostKeyID].func_151470_d();
    }

    public static boolean isAltKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74324_K[icAltKeyID].func_151470_d();
    }

    public static boolean isModeKeyPress(EntityPlayer player) {
        if (KeyboardClient.mc.field_71474_y.field_74324_K[icModeKeyID].func_151470_d()) {
            if (!lastKeyModeState) {
                lastKeyModeState = true;
                KeyboardClient.sendModeKey(player);
            }
            return true;
        }
        lastKeyModeState = false;
        return false;
    }

    public static boolean isJumpKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74314_A.func_151470_d();
    }

    public static boolean isForwardKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74351_w.func_151470_d();
    }

    public static boolean isSneakKeyDown(EntityPlayer player) {
        return KeyboardClient.mc.field_71474_y.field_74311_E.func_151470_d();
    }

    public static void sendModeKey(EntityPlayer player) {
        PacketKeyPress.issue(2);
    }

    @Override
    public void sendKeyUpdate(EntityPlayer player) {
        int currentKeyState = (KeyboardClient.isBoostKeyDown(player) ? 1 : 0) << 0 | (KeyboardClient.isAltKeyDown(player) ? 1 : 0) << 1 | (KeyboardClient.isModeKeyPress(player) ? 1 : 0) << 2 | (KeyboardClient.isForwardKeyDown(player) ? 1 : 0) << 3 | (KeyboardClient.isJumpKeyDown(player) ? 1 : 0) << 4 | (KeyboardClient.isSneakKeyDown(player) ? 1 : 0) << 5;
        if (currentKeyState != lastKeyState) {
            PacketKeyboardUpdate.issue(currentKeyState);
            lastKeyState = currentKeyState;
            super.processKeyUpdate(player, currentKeyState);
        }
    }

    public static void updatePlayerMove() {
        moveStrafe = 0.0f;
        moveForward = 0.0f;
        if (KeyboardClient.mc.field_71474_y.field_74351_w.func_151470_d()) {
            moveForward += 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74368_y.func_151470_d()) {
            moveForward -= 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74370_x.func_151470_d()) {
            moveStrafe += 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74366_z.func_151470_d()) {
            moveStrafe -= 1.0f;
        }
        if (KeyboardClient.mc.field_71474_y.field_74311_E.func_151470_d()) {
            moveStrafe = (float)((double)moveStrafe * 0.3);
            moveForward = (float)((double)moveForward * 0.3);
        }
    }

    public static void SwitchDisplayHud(Boolean onOffHud) {
        Configuration tmpConfig = new Configuration(GraviSuite.configFile);
        try {
            tmpConfig.load();
            if (onOffHud.booleanValue()) {
                if (GraviSuite.displayHud) {
                    GraviSuite.displayHud = false;
                    tmpConfig.get("Hud settings", "Display hud", false).set(false);
                    KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.displayHud") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled")));
                } else {
                    GraviSuite.displayHud = true;
                    tmpConfig.get("Hud settings", "Display hud", true).set(true);
                    KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.displayHud") + ": " + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled")));
                }
            } else if (GraviSuite.displayHud) {
                int tmpHudPos = GraviSuite.hudPos;
                if (++tmpHudPos > 4) {
                    tmpHudPos = 1;
                }
                String HudPosString = "";
                switch (tmpHudPos) {
                    case 1: {
                        HudPosString = Helpers.formatMessage("message.hud.location.topLeft");
                        break;
                    }
                    case 2: {
                        HudPosString = Helpers.formatMessage("message.hud.location.topRight");
                        break;
                    }
                    case 3: {
                        HudPosString = Helpers.formatMessage("message.hud.location.bottomLeft");
                        break;
                    }
                    case 4: {
                        HudPosString = Helpers.formatMessage("message.hud.location.bottomRight");
                    }
                }
                GraviSuite.hudPos = tmpHudPos;
                tmpConfig.get("Hud settings", "hudPosition", tmpHudPos).set(tmpHudPos);
                KeyboardClient.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "[GraviSuite] " + Helpers.formatMessage("message.hud.location") + ": " + EnumChatFormatting.AQUA + HudPosString));
            }
        }
        catch (Exception e) {
            GraviSuite.addLog("Error while loading config file: " + e);
            throw new RuntimeException(e);
        }
        finally {
            tmpConfig.save();
        }
    }
}

