/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.IItemTickListener;
import gravisuite.common.FluidHelper;
import gravisuite.common.GraviRegistry;
import gravisuite.common.GregTechAPIHelper;
import gravisuite.common.ICustomItemBars;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemPlasmaCell
extends Item
implements IElectricItem,
IItemTickListener,
ICustomItemBars,
IFluidContainerItem {
    private static final String NBT_FLUID_TAG = "Fluid";
    private final int _mMaxCharge;
    private final int _mTransferLimit;
    private final int _mTier;
    protected static final int _mCapacity = 64000;
    private static GraviRegistry _mReg = GraviRegistry.getInstance();
    public static IIcon _mIcon;

    public ItemPlasmaCell() {
        this._mMaxCharge = GraviProperties.ElectricPreSets.PlasmaCell.MaxCharge;
        this._mTransferLimit = GraviProperties.ElectricPreSets.PlasmaCell.TransferLimit;
        this.func_77637_a(GraviSuite._mGraviCreativeTab);
        this._mTier = GraviProperties.ElectricPreSets.PlasmaCell.Tier;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b("PlasmaCell");
    }

    public FluidStack getFluid(ItemStack pFluidContainer) {
        NBTTagCompound tTagCompound = ItemPlasmaCell.getOrCreateNbtData(pFluidContainer);
        NBTTagCompound tFluidTag = tTagCompound.func_74775_l(NBT_FLUID_TAG);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tFluidTag);
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public int getCapacity(ItemStack pFluidContainer) {
        return 64000;
    }

    public int fill(ItemStack pFluidContainer, FluidStack pFluidSource, boolean pDoFill) {
        if (GregTechAPIHelper.getPlasmaFuelValue(pFluidSource) < 1) {
            return 0;
        }
        if (pFluidContainer.field_77994_a != 1) {
            return 0;
        }
        if (pFluidSource == null) {
            return 0;
        }
        NBTTagCompound tTagCompound = ItemPlasmaCell.getOrCreateNbtData(pFluidContainer);
        NBTTagCompound tFluidTag = tTagCompound.func_74775_l(NBT_FLUID_TAG);
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tFluidTag);
        if (fs == null) {
            fs = new FluidStack(pFluidSource, 0);
        }
        if (!fs.isFluidEqual(pFluidSource)) {
            return 0;
        }
        int amount = Math.min(64000 - fs.amount, pFluidSource.amount);
        if (pDoFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(tFluidTag);
            tTagCompound.func_74782_a(NBT_FLUID_TAG, (NBTBase)tFluidTag);
        }
        return amount;
    }

    public FluidStack drain(ItemStack pFluidContainer, int pMaxDrain, boolean pDoDrain) {
        if (pFluidContainer.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound tTagCompound = ItemPlasmaCell.getOrCreateNbtData(pFluidContainer);
        NBTTagCompound tFluidTag = tTagCompound.func_74775_l(NBT_FLUID_TAG);
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tFluidTag);
        if (fs == null) {
            return null;
        }
        pMaxDrain = Math.min(fs.amount, pMaxDrain);
        if (pDoDrain) {
            fs.amount -= pMaxDrain;
            if (fs.amount <= 0) {
                tTagCompound.func_82580_o(NBT_FLUID_TAG);
            } else {
                fs.writeToNBT(tFluidTag);
                tTagCompound.func_74782_a(NBT_FLUID_TAG, (NBTBase)tFluidTag);
            }
        }
        return new FluidStack(fs, pMaxDrain);
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pInfo, boolean pSomethingBooleanIhaveNoIdeaWhatItDoes) {
        pInfo.addAll(ItemPlasmaCell.getToolTipInfo(pItemStack));
    }

    public static List getToolTipInfo(ItemStack pItemStack) {
        ArrayList<String> tList = new ArrayList<String>();
        FluidStack fluid = ((ItemPlasmaCell)GraviSuite.itemPlasmaCell).getFluid(pItemStack);
        if (fluid != null) {
            tList.add(String.format("Contains: %s (%,d mb)", FluidHelper.getFluidName(fluid), fluid.amount));
            tList.add(String.format("Efficiency: %.2f %%", Float.valueOf(_mReg.getPlasmaEfficiency(fluid))));
        } else {
            tList.add(String.format("Contains: Nothing ", new Object[0]));
            tList.add(String.format("Efficiency: 0.00 %%", new Object[0]));
        }
        return tList;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister pRegister) {
        _mIcon = pRegister.func_94245_a("gravisuite:itemPlasmaCell");
    }

    public IIcon getIcon(ItemStack pItemStack, int pPass) {
        return _mIcon;
    }

    public IIcon func_77617_a(int pDamage) {
        return _mIcon;
    }

    public Item getEmptyItem(ItemStack pItemStack) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack pItemStack) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack pItemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack pItemStack) {
        return this._mMaxCharge;
    }

    public int getTier(ItemStack pItemStack) {
        return this._mTier;
    }

    public double getTransferLimit(ItemStack pItemStack) {
        return this._mTransferLimit;
    }

    @Override
    public boolean onTick(EntityPlayer pPlayer, ItemStack pItemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack pItemStack) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        ItemStack fullStack = new ItemStack((Item)this, 1, this.func_77612_l());
        var3.add(fullStack);
        Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tPlasmaStack = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
                if (tPlasmaStack == null) continue;
                ItemStack tempStack = new ItemStack((Item)this, 1, this.func_77612_l());
                ElectricItem.manager.charge(tempStack, 2.147483647E9, Integer.MAX_VALUE, true, false);
                FluidStack tFS = tPlasmaStack.copy();
                tFS.amount = 64000;
                this.fill(tempStack, tFS, true);
                var3.add(tempStack);
            }
        }
    }

    @Override
    public int getNumBars(ItemStack pItemStack) {
        return 2;
    }

    @Override
    public Color getColorForMinValue(ItemStack pItemStack, int pBarIndex) {
        return Color.RED;
    }

    @Override
    public Color getColorForMaxValue(ItemStack pItemStack, int pBarIndex) {
        if (pBarIndex == 0) {
            return Color.GREEN;
        }
        return Color.YELLOW;
    }

    @Override
    public double getMaxValue(ItemStack pItemStack, int pBarIndex) {
        if (pBarIndex == 0) {
            return this._mMaxCharge;
        }
        return 64000.0;
    }

    @Override
    public double getValueForBar(ItemStack pItemStack, int pBarIndex) {
        if (pBarIndex == 0) {
            return ElectricItem.manager.getCharge(pItemStack);
        }
        FluidStack tFluid = this.getFluid(pItemStack);
        if (tFluid != null) {
            return tFluid.amount;
        }
        return 0.0;
    }

    @Override
    public ICustomItemBars.BAR_ALIGNMENT getBarAlignment() {
        return ICustomItemBars.BAR_ALIGNMENT.HORIZONTAL_BOTTOM;
    }

    @Override
    public int getBarThickness(ItemStack pItemStack, int pBarIndex) {
        return 1;
    }

    @Override
    public boolean getIsBarInverted(ItemStack pItemStack, int pBarIndex) {
        return true;
    }
}

