/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.common.render;

import cpw.mods.fml.common.FMLLog;
import gravisuite.common.ICustomItemBars;
import gravisuite.common.client.ColorUtil;
import gravisuite.common.client.RenderUtil;
import gravisuite.common.math.vector.Vector4f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCustomItemBar
implements IItemRenderer {
    private RenderItem _mRenderItem = new RenderItem();
    private static int _mStartXHorizonal_Top = 2;
    private static int _mStartXHorizonal_Bottom = 14;
    private static int _mStartXVertical_Left = 2;
    private static int _mStartXVertical_Right = 14;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType pType) {
        return pType == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType pItemRenderType, ItemStack pItemStack, IItemRenderer.ItemRendererHelper pRenderHelper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType pType, ItemStack pItemStack, Object ... pData) {
        if (pData != null && pData.length > 0) {
            this.renderToInventory(pItemStack, (RenderBlocks)pData[0]);
        }
    }

    public void renderToInventory(ItemStack pItemStack, RenderBlocks pRenderBlocks) {
        Minecraft tMc = Minecraft.func_71410_x();
        this._mRenderItem.renderItemIntoGUI(tMc.field_71466_p, tMc.func_110434_K(), pItemStack, 0, 0, true);
        if (!(pItemStack.func_77973_b() instanceof ICustomItemBars)) {
            return;
        }
        ICustomItemBars tBarsItem = (ICustomItemBars)pItemStack.func_77973_b();
        int tMaxBars = tBarsItem.getNumBars(pItemStack);
        ICustomItemBars.BAR_ALIGNMENT tAlignment = tBarsItem.getBarAlignment();
        int tCurrentPosXY = -1;
        int tThicknessPrefixMultiplicator = 0;
        boolean tIsVertical = false;
        switch (tAlignment) {
            case HORIZONTAL_BOTTOM: {
                tCurrentPosXY = _mStartXHorizonal_Bottom;
                tThicknessPrefixMultiplicator = -1;
                break;
            }
            case HORIZONTAL_TOP: {
                tCurrentPosXY = _mStartXHorizonal_Top;
                tThicknessPrefixMultiplicator = 1;
                break;
            }
            case VERTICAL_LEFT: {
                tCurrentPosXY = _mStartXVertical_Left;
                tThicknessPrefixMultiplicator = 1;
                tIsVertical = true;
                break;
            }
            case VERTICAL_RIGHT: {
                tCurrentPosXY = _mStartXVertical_Right;
                tThicknessPrefixMultiplicator = -1;
                tIsVertical = true;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < tMaxBars; ++i) {
            double tBarValue = tBarsItem.getValueForBar(pItemStack, i);
            int tThickness = tBarsItem.getBarThickness(pItemStack, i);
            if (tBarValue > -1.0) {
                double tBarMax = tBarsItem.getMaxValue(pItemStack, i);
                Color tCE = tBarsItem.getColorForMaxValue(pItemStack, i);
                Color tCF = tBarsItem.getColorForMinValue(pItemStack, i);
                boolean tInverted = tBarsItem.getIsBarInverted(pItemStack, i);
                this.renderBar(tCurrentPosXY, tBarMax, tBarValue, tCE, tCF, tThickness, tIsVertical, tInverted);
            }
            if ((tCurrentPosXY += tThickness * tThicknessPrefixMultiplicator) > 0 && tCurrentPosXY < 15) continue;
            FMLLog.warning((String)"[CustomBarItemRenderer] Index violates boundary limits", (Object[])new Object[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBar(int pXYStart, double pMaxDamage, double pDispDamage, Color pColorfull, Color pColorempty, int pThickness, boolean pVertical, boolean pInverted) {
        try {
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double ratio = pDispDamage / pMaxDamage;
            Vector4f fgColor = ColorUtil.toFloat(pInverted ? pColorempty : pColorfull);
            Vector4f ec = ColorUtil.toFloat(pInverted ? pColorfull : pColorempty);
            fgColor.interpolate(ec, (float)ratio);
            Vector4f bgColor = ColorUtil.toFloat(Color.black);
            bgColor.interpolate(fgColor, 0.15f);
            int barLenght = 0;
            barLenght = pInverted ? (int)Math.round(12.0 * ratio) : (int)Math.round(12.0 * (1.0 - ratio));
            int tBarX = 0;
            int tBarY = 0;
            boolean tBarZ = false;
            int tBgBarWidth = 0;
            int tFgBarWidth = 0;
            int tBgBarHeight = 0;
            int tFgBarHeight = 0;
            if (pVertical) {
                tBarX = pXYStart;
                tBarY = 2;
                tBarZ = false;
                tFgBarWidth = pThickness;
                tFgBarHeight = barLenght;
                tBgBarWidth = pThickness;
                tBgBarHeight = 12;
            } else {
                tBarX = 2;
                tBarY = pXYStart;
                tBarZ = false;
                tFgBarWidth = barLenght;
                tFgBarHeight = pThickness;
                tBgBarWidth = 12;
                tBgBarHeight = pThickness;
            }
            RenderUtil.renderQuad2D((double)tBarX, (double)tBarY, (double)tBarZ, (double)tBgBarWidth, (double)tBgBarHeight, bgColor);
            RenderUtil.renderQuad2D((double)tBarX, (double)tBarY, (double)tBarZ, (double)tFgBarWidth, (double)tFgBarHeight, fgColor);
        }
        catch (Exception exception) {
        }
        finally {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
        }
    }
}

