/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gravisuite.GraviSuite;
import gravisuite.tools.ItemRelocator;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.lwjgl.opengl.GL11;

public class Helpers {
    public static boolean setBlockToAir(World w, int x, int y, int z) {
        return w.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 0);
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == Helpers.getBlock(stack);
    }

    public static String formatMessage(String inputString) {
        ChatComponentTranslation cht = new ChatComponentTranslation(inputString, new Object[0]);
        return StatCollector.func_74838_a((String)cht.func_150261_e());
    }

    public static int convertRGBcolorToInt(int r, int g, int b) {
        float divColor = 255.0f;
        Color tmpColor = new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        return tmpColor.getRGB();
    }

    public static Color convertRGBtoColor(int r, int g, int b) {
        float divColor = 255.0f;
        Color tmpColor = new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        return tmpColor;
    }

    public static void renderTooltip(int x, int y, List<String> tooltipData) {
        int color = Helpers.convertRGBcolorToInt(0, 149, 218);
        int color2 = Helpers.convertRGBcolorToInt(119, 187, 218);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (!tooltipData.isEmpty()) {
            int var7;
            int var6;
            int var5 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var6 = 0; var6 < tooltipData.size(); ++var6) {
                var7 = fontRenderer.func_78256_a(tooltipData.get(var6));
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (tooltipData.size() > 1) {
                var9 += 2 + (tooltipData.size() - 1) * 10;
            }
            float z = 300.0f;
            Helpers.drawGradientRect(var6 - 3, var7 - 4, 300.0f, var6 + var5 + 3, var7 - 3, color2, color2);
            Helpers.drawGradientRect(var6 - 3, var7 + var9 + 3, 300.0f, var6 + var5 + 3, var7 + var9 + 4, color2, color2);
            Helpers.drawGradientRect(var6 - 3, var7 - 3, 300.0f, var6 + var5 + 3, var7 + var9 + 3, color2, color2);
            Helpers.drawGradientRect(var6 - 4, var7 - 3, 300.0f, var6 - 3, var7 + var9 + 3, color2, color2);
            Helpers.drawGradientRect(var6 + var5 + 3, var7 - 3, 300.0f, var6 + var5 + 4, var7 + var9 + 3, color2, color2);
            int var12 = (color & 0xFFFFFF) >> 1 | color & 0xFF000000;
            Helpers.drawGradientRect(var6 - 3, var7 - 3 + 1, 300.0f, var6 - 3 + 1, var7 + var9 + 3 - 1, color, var12);
            Helpers.drawGradientRect(var6 + var5 + 2, var7 - 3 + 1, 300.0f, var6 + var5 + 3, var7 + var9 + 3 - 1, color, var12);
            Helpers.drawGradientRect(var6 - 3, var7 - 3, 300.0f, var6 + var5 + 3, var7 - 3 + 1, color, color);
            Helpers.drawGradientRect(var6 - 3, var7 + var9 + 2, 300.0f, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            for (int var13 = 0; var13 < tooltipData.size(); ++var13) {
                String var14 = tooltipData.get(var13);
                fontRenderer.func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
        }
    }

    public static void drawGradientRect(int par1, int par2, float z, int par3, int par4, int par5, int par6) {
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)par2, (double)z);
        var15.func_78377_a((double)par1, (double)par2, (double)z);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)par1, (double)par4, (double)z);
        var15.func_78377_a((double)par3, (double)par4, (double)z);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static Entity teleportEntity(Entity entity, ItemRelocator.TeleportPoint tpPoint) {
        boolean changeDim;
        boolean bl = changeDim = entity.field_70170_p.field_73011_w.field_76574_g != tpPoint.dimID;
        if (changeDim) {
            Helpers.teleportToDimensionNew(entity, tpPoint);
        } else {
            Entity mount = entity.field_70154_o;
            if (entity.field_70154_o != null) {
                entity.func_70078_a(null);
                mount = Helpers.teleportEntity(mount, tpPoint);
            }
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_70634_a(tpPoint.x, tpPoint.y, tpPoint.z);
            } else {
                entity.func_70107_b(tpPoint.x, tpPoint.y, tpPoint.z);
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            if (mount != null) {
                entity.func_70078_a(mount);
            }
        }
        return entity;
    }

    public static void teleportToDimension(Entity entity, int targetDimID, ItemRelocator.TeleportPoint tpPoint) {
        if (GraviSuite.isSimulating()) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            int currentDim = entity.field_70170_p.field_73011_w.field_76574_g;
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer currentServer = minecraftserver.func_71218_a(currentDim);
            WorldServer targetServer = minecraftserver.func_71218_a(targetDimID);
            player.field_71093_bK = targetDimID;
            player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            currentServer.func_72973_f((Entity)player);
            player.field_70128_L = false;
            player.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            targetServer.field_73059_b.func_73158_c((int)tpPoint.x >> 4, (int)tpPoint.z >> 4);
            targetServer.func_72838_d((Entity)player);
            targetServer.func_72866_a((Entity)player, false);
            player.func_70029_a((World)targetServer);
            if (currentServer != null) {
                currentServer.func_73040_p().func_72695_c(player);
            }
            targetServer.func_73040_p().func_72683_a(player);
            targetServer.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            player.field_71135_a.func_147364_a(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            player.field_71134_c.func_73080_a(targetServer);
            player.field_71133_b.func_71203_ab().func_72354_b(player, targetServer);
            player.field_71133_b.func_71203_ab().func_72385_f(player);
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, currentDim, targetDimID);
            player.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            targetServer.func_72866_a((Entity)player, true);
        }
    }

    public static Entity teleportToDimensionNew(Entity entity, ItemRelocator.TeleportPoint tpPoint) {
        if (GraviSuite.isSimulating()) {
            EntityPlayerMP player;
            Entity mount = entity.field_70154_o;
            if (entity.field_70154_o != null) {
                entity.func_70078_a(null);
                mount = Helpers.teleportToDimensionNew(mount, tpPoint);
            }
            System.out.println("Teleport entity: " + entity.toString());
            tpPoint.y += 0.5;
            int currentDim = entity.field_70170_p.field_73011_w.field_76574_g;
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer currentServer = minecraftserver.func_71218_a(currentDim);
            WorldServer targetServer = minecraftserver.func_71218_a(tpPoint.dimID);
            currentServer.func_72866_a(entity, false);
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                player.field_71093_bK = tpPoint.dimID;
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                currentServer.func_72973_f((Entity)player);
                player.field_70128_L = false;
            } else {
                entity.field_71093_bK = tpPoint.dimID;
                entity.field_70128_L = false;
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            targetServer.field_73059_b.func_73158_c((int)tpPoint.x >> 4, (int)tpPoint.z >> 4);
            targetServer.func_72838_d(entity);
            targetServer.func_72866_a(entity, false);
            entity.func_70029_a((World)targetServer);
            if (!(entity instanceof EntityPlayerMP)) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(entityNBT);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)targetServer);
                if (entity == null) {
                    return null;
                }
                entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
                targetServer.func_72838_d(entity);
                entity.func_70029_a((World)targetServer);
                entity.field_71093_bK = tpPoint.dimID;
            }
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                if (currentServer != null) {
                    currentServer.func_73040_p().func_72695_c(player);
                }
                targetServer.func_73040_p().func_72683_a(player);
                targetServer.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
                targetServer.func_72866_a(entity, false);
                player.field_71135_a.func_147364_a(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
                player.field_71134_c.func_73080_a(targetServer);
                player.field_71133_b.func_71203_ab().func_72354_b(player, targetServer);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, currentDim, tpPoint.dimID);
                player.func_70634_a(tpPoint.x, tpPoint.y, tpPoint.z);
                player.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            if (mount != null) {
                if (entity instanceof EntityPlayerMP) {
                    targetServer.func_72866_a(entity, true);
                }
                System.out.println("Mount entity");
                entity.func_70078_a(mount);
                targetServer.func_72939_s();
                Helpers.teleportEntity(entity, tpPoint);
            }
        }
        return entity;
    }

    public static ResourceLocation getParticleTexture() {
        try {
            return (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])new String[]{"particleTextures", "b", "field_110737_b"});
        }
        catch (Exception exception) {
            return null;
        }
    }
}

