/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.common;

import cpw.mods.fml.common.FMLLog;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GraviRegistry {
    private static GraviRegistry _mInstance;
    private static float _mPlasmaMedianMultip;
    private static Map<Integer, Float> _mFuelMap;

    public float getPlasmaEfficiency(FluidStack pPlasmaStack) {
        float tReturnVal = 0.0f;
        if (_mFuelMap == null) {
            this.initPlasmaFuelMap();
        }
        if (pPlasmaStack != null && _mFuelMap.containsKey(pPlasmaStack.getFluidID())) {
            tReturnVal = _mFuelMap.get(pPlasmaStack.getFluidID()).floatValue();
        }
        return tReturnVal;
    }

    public static float round(float d, int decimalPlace) {
        return BigDecimal.valueOf(d).setScale(decimalPlace, 4).floatValue();
    }

    private void initPlasmaFuelMap() {
        try {
            FluidStack tLiquid;
            _mFuelMap = new HashMap<Integer, Float>();
            int cnt = 0;
            long _mFuelMedianValue = 0L;
            Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.mRecipeList;
            if (tRecipeList != null) {
                for (GT_Recipe tFuel : tRecipeList) {
                    tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
                    if (tLiquid == null) continue;
                    _mFuelMedianValue += (long)tFuel.mSpecialValue;
                    ++cnt;
                }
            }
            if (cnt >= 1 && _mFuelMedianValue > 1L) {
                _mPlasmaMedianMultip = 100.0f / ((float)_mFuelMedianValue / (float)cnt);
                FMLLog.info((String)"_mPlasmaMedianMultip: %f", (Object[])new Object[]{Float.valueOf(_mPlasmaMedianMultip)});
                for (GT_Recipe tFuel : tRecipeList) {
                    tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
                    if (tLiquid == null) continue;
                    float fuelVal = (float)tFuel.mSpecialValue * _mPlasmaMedianMultip;
                    _mFuelMap.put(tLiquid.getFluidID(), Float.valueOf(fuelVal));
                    FMLLog.info((String)"Added Fluid ID %d (%s) with Fuel Value %f", (Object[])new Object[]{tLiquid.getFluidID(), tLiquid.getLocalizedName(), Float.valueOf(fuelVal)});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GraviRegistry getInstance() {
        if (_mInstance == null) {
            _mInstance = new GraviRegistry();
        }
        return _mInstance;
    }

    private GraviRegistry() {
    }

    static {
        _mPlasmaMedianMultip = 0.0f;
    }
}

