/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import gravisuite.GraviSuite;
import gravisuite.common.Helpers;
import gravisuite.network.PacketManagePoints;
import gravisuite.proxy.ServerProxy;
import gravisuite.tools.ItemRelocator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRelocatorDisplayMKII
extends GuiContainer {
    private static ResourceLocation tex = new ResourceLocation("gravisuite", "textures/gui/relocator_display.png");
    private int mouseX;
    private int mouseY;
    private static int itemInterval = 10;
    private static int firstItemX = 17;
    private static int firstItemY = 16;
    private static int cancelBtnX1 = 138;
    private static int cancelBtnSize;
    private static int firstSelX;
    private static int firstSelY;
    private static int selWidth;
    private static int selHeight;
    private static int firstItemBGX;
    private static int firstItemBGY;
    private static int itemBGinterval;
    private static int cancelBtnWidth;
    private static int cancelBtnHeight;
    private static int openType;
    private static int itemBGX;
    private static int itemBGY;
    private static int itemBGWidth;
    private static int itemBGHeight;
    private static int itemBGdefX;
    private static int itemBGdefY;
    private static int itemBGselX;
    private static int itemBGselY;
    private static int itemBGdelX;
    private static int itemBGdelY;
    public static final int GUI_POINT_DISPLAY_LIST = 0;
    public static final int GUI_POINT_DISPLAY_DEFSELECT = 1;
    private int _mSelected = 0;
    private int _mPageOffset = 0;
    private int _mMaxOffset = 0;
    private static int _mPageXofYTextX;
    private static int _mPageXofYTextY;
    private static int _mPrevButtonX;
    private static int _mPrevButtonY;
    private static int _mNextButtonX;
    private static int _mNextButtonY;

    public GuiRelocatorDisplayMKII(int guiType) {
        super((Container)new ContainerRelocatorDisplay());
        this.field_146999_f = 162;
        this.field_147000_g = 129;
        openType = guiType;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public SelectedItem getSelected(List<ItemRelocator.TeleportPoint> tpList) {
        SelectedItem tmpSel = new SelectedItem();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int realMouseX = this.mouseX - xStart;
        int realMouseY = this.mouseY - yStart;
        int itemsCount = tpList.size();
        if (this.isPointInRegion(firstSelX, firstSelY + 1, selWidth, Math.min(itemInterval * 10 - 2, itemInterval * itemsCount - 2), this.mouseX, this.mouseY)) {
            double newCalc = (double)(realMouseY - firstSelY + 1) / (double)itemBGinterval;
            tmpSel.guiIDX = (int)Math.ceil(newCalc);
            tmpSel.offset = this._mPageOffset;
            if (this.isPointInRegion(cancelBtnX1, firstSelY + 1, cancelBtnWidth, Math.min(itemInterval * 10 - 1, itemInterval * itemsCount - 1), this.mouseX, this.mouseY)) {
                tmpSel.delFlag = true;
            }
            if (tpList.size() <= tmpSel.getRealIDX()) {
                return null;
            }
            return tmpSel;
        }
        return null;
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        EntityClientPlayerMP tPlayer = Minecraft.func_71410_x().field_71439_g;
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int realMouseX = this.mouseX - xStart;
        int realMouseY = this.mouseY - yStart;
        if (this.isPointInRegion(_mPrevButtonX, _mPrevButtonY, 9, 9, this.mouseX, this.mouseY)) {
            if (this._mPageOffset > 0) {
                --this._mPageOffset;
            }
        } else if (this.isPointInRegion(_mNextButtonX, _mNextButtonY, 9, 9, this.mouseX, this.mouseY)) {
            if (this._mPageOffset < this._mMaxOffset) {
                ++this._mPageOffset;
            }
        } else {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentHeldItem()));
            SelectedItem selectedItem = this.getSelected(tpList);
            if (selectedItem == null) {
                return;
            }
            int tRealIDX = selectedItem.getRealIDX();
            if (tRealIDX >= tpList.size()) {
                FMLLog.bigWarning((String)"WARNING: IndexOutOfBounds catched while using Translocator", (Object[])new Object[0]);
                ServerProxy.sendPlayerMessage((EntityPlayer)tPlayer, EnumChatFormatting.RED + "Used TP Point is invalid. Please remove and add again");
                tPlayer.func_71053_j();
                return;
            }
            String tPointName = ((ItemRelocator.TeleportPoint)tpList.get((int)selectedItem.getRealIDX())).pointName;
            if (selectedItem.delFlag) {
                PacketManagePoints.issue((EntityPlayer)tPlayer, tPointName, (byte)0);
            } else {
                if (openType == 0) {
                    PacketManagePoints.issue((EntityPlayer)tPlayer, tPointName, (byte)2);
                }
                if (openType == 1) {
                    PacketManagePoints.issue((EntityPlayer)tPlayer, tPointName, (byte)3);
                }
                tPlayer.func_71053_j();
            }
        }
    }

    private boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        return this.func_146978_c(left, top, width, height, mouseX, mouseY);
    }

    private ItemStack getCurrentHeldItem() {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g();
    }

    private void closeGui() {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void func_146979_b(int x, int y) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        try {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentHeldItem()));
            this._mMaxOffset = (int)Math.floor((tpList.size() - 1) / 10);
            if (tpList.size() > 0) {
                SelectedItem selectedItem;
                ItemRelocator.TeleportPoint tmpPoint;
                for (int i = this._mPageOffset * 10; i < (this._mPageOffset + 1) * 10 && i < tpList.size(); ++i) {
                    tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(i);
                    this.field_146289_q.func_78276_b(tmpPoint.pointName, firstItemX, firstItemY + (i - this._mPageOffset * 10) * itemInterval, 0xFFFFFF);
                }
                if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74311_E) && (selectedItem = this.getSelected(tpList)) != null) {
                    ArrayList<String> toolTipData = new ArrayList<String>();
                    tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(selectedItem.getRealIDX());
                    toolTipData.add("Dimension: " + DimensionManager.getProvider((int)tmpPoint.dimID).func_80007_l());
                    toolTipData.add("Height: " + (int)tmpPoint.y);
                    toolTipData.add("X: " + (int)tmpPoint.x);
                    toolTipData.add("Y: " + (int)tmpPoint.z);
                    int realMouseX = this.mouseX - xStart;
                    int realMouseY = this.mouseY - yStart;
                    Helpers.renderTooltip(realMouseX - 2, realMouseY, toolTipData);
                }
            }
        }
        catch (Exception e) {
            GraviSuite.addLog("Error in draw relocatorGui foregroundLayer:" + e.toString());
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int x, int y, float par3) {
        super.func_73863_a(x, y, par3);
        this.mouseX = x;
        this.mouseY = y;
    }

    public void func_73876_c() {
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (keyCode > 1 && keyCode < 12) {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentHeldItem()));
            if (keyCode - 2 < tpList.size()) {
                ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(keyCode - 2);
                PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, tmpPoint.pointName, (byte)2);
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    protected void func_146976_a(float opacity, int x, int y) {
        try {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(tex);
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
            GL11.glDisable((int)3042);
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentHeldItem()));
            if (this.prevButtonAvailable()) {
                this.func_73729_b(xStart + _mPrevButtonX, yStart + _mPrevButtonY, 0, 182, 9, 9);
            } else {
                this.func_73729_b(xStart + _mPrevButtonX, yStart + _mPrevButtonY, 0, 192, 9, 9);
            }
            if (this.nextButtonAvailable()) {
                this.func_73729_b(xStart + _mNextButtonX, yStart + _mNextButtonY, 17, 182, 9, 9);
            } else {
                this.func_73729_b(xStart + _mNextButtonX, yStart + _mNextButtonY, 17, 192, 9, 9);
            }
            if (tpList.size() > 0) {
                for (int i = this._mPageOffset * 10; i < (this._mPageOffset + 1) * 10 && i < tpList.size(); ++i) {
                    this.func_73729_b(xStart + firstItemBGX, yStart + firstItemBGY + (i - this._mPageOffset * 10) * itemInterval, itemBGX, itemBGY, itemBGWidth, itemBGHeight);
                    ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(i);
                    if (!tmpPoint.defPoint) continue;
                    this.func_73729_b(xStart + firstItemBGX, yStart + firstItemBGY + (i - this._mPageOffset * 10) * itemInterval, itemBGdefX, itemBGdefY, itemBGWidth, itemBGHeight);
                }
                SelectedItem selectedItem = this.getSelected(tpList);
                if (selectedItem != null) {
                    if (!selectedItem.delFlag) {
                        this.func_73729_b(xStart + firstItemBGX, yStart + firstItemBGY + (selectedItem.guiIDX - 1) * itemInterval, itemBGselX, itemBGselY, itemBGWidth, itemBGHeight);
                    } else {
                        this.func_73729_b(xStart + firstItemBGX, yStart + firstItemBGY + (selectedItem.guiIDX - 1) * itemInterval, itemBGdelX, itemBGdelY, itemBGWidth, itemBGHeight);
                    }
                }
            }
            this.field_146289_q.func_78276_b(String.format("%d / %d", this._mPageOffset + 1, this._mMaxOffset + 1), xStart + _mPageXofYTextX, yStart + _mPageXofYTextY, 0xFFFFFF);
        }
        catch (Exception e) {
            GraviSuite.addLog("Error in drawGuiContainerBackgroundLayer: " + e.toString());
        }
    }

    private boolean prevButtonAvailable() {
        return this._mPageOffset > 0;
    }

    private boolean nextButtonAvailable() {
        return this._mPageOffset < this._mMaxOffset;
    }

    static {
        firstSelX = 15;
        firstSelY = 15;
        selWidth = 132;
        selHeight = 9;
        firstItemBGX = 14;
        firstItemBGY = 14;
        itemBGinterval = 10;
        cancelBtnWidth = 9;
        cancelBtnHeight = 9;
        itemBGX = 0;
        itemBGY = 131;
        itemBGWidth = 134;
        itemBGHeight = 11;
        itemBGdefX = 0;
        itemBGdefY = 170;
        itemBGselX = 0;
        itemBGselY = 144;
        itemBGdelX = 0;
        itemBGdelY = 157;
        _mPageXofYTextX = 23;
        _mPageXofYTextY = 120;
        _mPrevButtonX = 117;
        _mPrevButtonY = 119;
        _mNextButtonX = 136;
        _mNextButtonY = 119;
    }

    public static class SelectedItem {
        public int guiIDX = -1;
        public int offset = 0;
        public boolean delFlag = false;

        public int getRealIDX() {
            return this.guiIDX + this.offset * 10 - 1;
        }
    }

    public static class ContainerRelocatorDisplay
    extends Container {
        public boolean func_75145_c(EntityPlayer var1) {
            return true;
        }

        public Slot func_75139_a(int p_75139_1_) {
            return new Slot(new IInventory(){

                public int func_70302_i_() {
                    return 0;
                }

                public ItemStack func_70301_a(int p_70301_1_) {
                    return null;
                }

                public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
                    return null;
                }

                public ItemStack func_70304_b(int p_70304_1_) {
                    return null;
                }

                public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
                }

                public String func_145825_b() {
                    return null;
                }

                public boolean isInventoryNameLocalized() {
                    return false;
                }

                public int func_70297_j_() {
                    return 0;
                }

                public void onInventoryChanged() {
                }

                public boolean func_70300_a(EntityPlayer p_70300_1_) {
                    return false;
                }

                public void func_70295_k_() {
                }

                public void func_70305_f() {
                }

                public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
                    return false;
                }

                public boolean func_145818_k_() {
                    return false;
                }

                public void func_70296_d() {
                }
            }, 0, 0, 0);
        }
    }
}

