/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.EntityPlasmaBall;
import gravisuite.common.Helpers;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPlasmaBall
extends Render {
    private float field_77002_a;
    private static final ResourceLocation plazmaTextloc = new ResourceLocation("gravisuite", "textures/models/plazma.png");
    private static final ResourceLocation particlesTextloc = new ResourceLocation("gravisuite", "textures/models/particles.png");
    private static Map textureSizeCache = new HashMap();
    public int ticker;
    private int _mImpactFadeStartTicks = -1;
    private float _mSizeFadeValue = 1.0f;

    public RenderPlasmaBall(float p_i1254_1_) {
        this.field_77002_a = p_i1254_1_;
    }

    public static int getTextureSize(String s, int dv) {
        if (textureSizeCache.get(Arrays.asList(s, dv)) != null) {
            return (Integer)textureSizeCache.get(Arrays.asList(s, dv));
        }
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("gravisuite", s)).func_110527_b();
            if (inputstream == null) {
                throw new Exception("Image not found: " + s);
            }
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put(Arrays.asList(s, dv), size);
            return size;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 16;
        }
    }

    public void renderCore(EntityPlasmaBall entity, double x, double y, double z, float fq, float pticks) {
        int size1 = 0;
        int size2 = 0;
        size1 = RenderPlasmaBall.getTextureSize("textures/models/plazma.png", 64);
        size2 = RenderPlasmaBall.getTextureSize("textures/models/particles.png", 32);
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74589_e;
        float f3 = ActiveRenderInfo.field_74586_f;
        float f4 = ActiveRenderInfo.field_74587_g;
        float f5 = ActiveRenderInfo.field_74596_h;
        float scaleCore = 1.0f;
        double posX = x;
        double posY = (float)y;
        double posZ = (float)z;
        Tessellator tessellator = Tessellator.field_78398_a;
        Color color = Helpers.convertRGBtoColor(226, 88, 255);
        byte actionType = entity.getActionType();
        if (actionType == 0) {
            color = Helpers.convertRGBtoColor(254, 255, 131);
        } else if (actionType == 2 || actionType == 3) {
            float tCharge = entity.getCharge();
            tCharge = Math.min(1.0f, tCharge);
            tCharge = Math.max(0.1f, tCharge);
            int tGColorValueOffset = (int)((tCharge - 0.2f) * 161.0f);
            color = Helpers.convertRGBtoColor(252, 161 - tGColorValueOffset, 3);
            if (actionType == 2) {
                this._mImpactFadeStartTicks = -1;
                scaleCore += tCharge * 2.0f;
            } else {
                int tTicksRemainingToDeath;
                scaleCore += 24.0f;
                if (this._mImpactFadeStartTicks == -1) {
                    this._mImpactFadeStartTicks = entity.field_70173_aa;
                }
                if ((tTicksRemainingToDeath = this._mImpactFadeStartTicks + 10 - entity.field_70173_aa) <= 0) {
                    return;
                }
                this._mSizeFadeValue = 10.0f * (float)tTicksRemainingToDeath / 100.0f;
                if ((scaleCore *= this._mSizeFadeValue) == 0.0f) {
                    return;
                }
            }
        }
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(plazmaTextloc);
        int i = entity.field_70173_aa % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float float_texNudge = 1.0f / ((float)(size1 * size1) * 2.0f);
        float float_reciprocal = 1.0f / (float)size1;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)(i / 4 * size1) + 0.0f) / size4;
        float x3 = ((float)(i / 4 * size1) + float_sizeMinus0_01) / size4;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78369_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        tessellator.func_78374_a(posX - (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x1, (double)x3);
        tessellator.func_78374_a(posX - (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x1, (double)x2);
        tessellator.func_78374_a(posX + (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x0, (double)x2);
        tessellator.func_78374_a(posX + (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x0, (double)x3);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(particlesTextloc);
        int qq = entity.field_70173_aa % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        float_texNudge = 1.0f / ((float)(size2 * size2) * 2.0f);
        float_reciprocal = 1.0f / (float)size2;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)(i / 8 * size2) + 0.0f) / size8;
        x3 = ((float)(i / 8 * size2) + float_sizeMinus0_01) / size8;
        float var11 = MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + pticks) / 10.0f)) * 0.1f;
        scaleCore = 0.4f + var11;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a(posX - (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x1, (double)x3);
        tessellator.func_78374_a(posX - (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ - (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x1, (double)x2);
        tessellator.func_78374_a(posX + (double)(f1 * scaleCore) + (double)(f4 * scaleCore), posY + (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) + (double)(f5 * scaleCore), (double)x0, (double)x2);
        tessellator.func_78374_a(posX + (double)(f1 * scaleCore) - (double)(f4 * scaleCore), posY - (double)(f2 * scaleCore), posZ + (double)(f3 * scaleCore) - (double)(f5 * scaleCore), (double)x0, (double)x3);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float fq, float ticks) {
        this.renderCore((EntityPlasmaBall)entity, x, y, z, fq, ticks);
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return plazmaTextloc;
    }
}

