/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.art;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gravisuite.art.MCRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;

public class ART {
    private ArrayList<MCRecipe> _mRecipeBuffer = null;
    private int _mCntr = 0;
    private final boolean _mCfg_RemoveRecipe;
    private final boolean _mCfg_ReAddRecipe;

    public ART(boolean pRemoveInvalidRecipe, boolean pReAddBufferedRecipe) {
        this._mCfg_RemoveRecipe = pRemoveInvalidRecipe;
        this._mCfg_ReAddRecipe = pReAddBufferedRecipe;
        this._mRecipeBuffer = new ArrayList();
    }

    public void addRecipe(ItemStack output, Object ... params) {
        this._mRecipeBuffer.add(new MCRecipe(CraftingManager.func_77594_a().func_92103_a(output, params), params));
    }

    public void onCraftingEvent(PlayerEvent.ItemCraftedEvent pEvent) {
        ItemStack pResultStack = pEvent.crafting;
        GameRegistry.UniqueIdentifier pResultItemID = GameRegistry.findUniqueIdentifierFor((Item)pResultStack.func_77973_b());
        boolean tTamperDetected = false;
        for (int i = 0; i < this._mRecipeBuffer.size(); ++i) {
            MCRecipe tExpectedRecipe = this._mRecipeBuffer.get(i);
            if (!tExpectedRecipe.recipeOutputIdentifier.toString().equals(pResultItemID.toString()) || tExpectedRecipe.recipeOutput.func_77960_j() != pResultStack.func_77960_j()) continue;
            List tCurrentActiveRecipes = CraftingManager.func_77594_a().func_77592_b();
            for (int j = 0; j < tCurrentActiveRecipes.size(); ++j) {
                IRecipe tLoopedRecipe = (IRecipe)tCurrentActiveRecipes.get(j);
                ItemStack tLoopedRecipeStack = tLoopedRecipe.func_77571_b();
                if (tLoopedRecipeStack == null) continue;
                String tLoopedRecipeItemID = tLoopedRecipeStack.func_82833_r();
                if (tLoopedRecipeStack.func_77969_a(tExpectedRecipe.recipeOutput)) {
                    if (tLoopedRecipeStack.field_77994_a != tExpectedRecipe.recipeOutput.field_77994_a) {
                        FMLLog.warning((String)"[AntiRecipeTamper] Found possible recipe tamper for item [%s]; Stacksize differs (Expected %d found %d)", (Object[])new Object[]{tLoopedRecipeItemID, tExpectedRecipe.recipeOutput.field_77994_a, tLoopedRecipeStack.field_77994_a});
                        tTamperDetected = true;
                    } else if (tLoopedRecipe instanceof ShapedRecipes) {
                        ItemStack[] tCompareStack = ((ShapedRecipes)tLoopedRecipe).field_77574_d;
                        ItemStack[] tExpectedStack = tExpectedRecipe.recipeItems;
                        if (tCompareStack.length != tExpectedStack.length) {
                            FMLLog.warning((String)"[AntiRecipeTamper] Found possible recipe tamper for item [%s]; Recipe size differs (Expected %d found %d)", (Object[])new Object[]{tLoopedRecipeItemID, tExpectedStack.length, tCompareStack.length});
                            tTamperDetected = true;
                        } else {
                            for (int k = 0; k < tCompareStack.length; ++k) {
                                if (tCompareStack[k] == null && tExpectedStack[k] == null) continue;
                                if (tCompareStack[k] == null || tExpectedStack[k] == null) {
                                    FMLLog.warning((String)"[AntiRecipeTamper] Found possible recipe tamper for item [%s]; Recipe is different at pos %d (Expected %s found %s)", (Object[])new Object[]{tLoopedRecipeItemID, k, this.SafeItemName(tExpectedStack[k]), this.SafeItemName(tCompareStack[k])});
                                    tTamperDetected = true;
                                    break;
                                }
                                if (tCompareStack[k].func_77969_a(tExpectedStack[k])) continue;
                                FMLLog.warning((String)"[AntiRecipeTamper] Found possible recipe tamper for item [%s]; Recipe is different at pos %d (Expected %s found %s)", (Object[])new Object[]{tLoopedRecipeItemID, k, tExpectedStack[k].toString(), tCompareStack[k].toString()});
                                tTamperDetected = true;
                                break;
                            }
                        }
                    }
                }
                if (!tTamperDetected) continue;
                FMLLog.warning((String)"[AntiRecipeTamper] Recipe for item [%s] was tampered", (Object[])new Object[]{tLoopedRecipeItemID});
                if (this._mCfg_RemoveRecipe) {
                    FMLLog.warning((String)"[AntiRecipeTamper] Removing invalid recipe", (Object[])new Object[0]);
                    CraftingManager.func_77594_a().func_77592_b().remove(j);
                }
                if (!this._mCfg_ReAddRecipe) continue;
                FMLLog.warning((String)"[AntiRecipeTamper] Re-Adding initial recipe", (Object[])new Object[0]);
                CraftingManager.func_77594_a().func_92103_a(tExpectedRecipe.recipeOutput, tExpectedRecipe.assembleRecipeObject());
            }
        }
    }

    private Object SafeItemName(ItemStack itemStack) {
        if (itemStack == null) {
            return "NULL";
        }
        if (itemStack.func_77973_b() == null) {
            return "NULL";
        }
        return itemStack.func_77973_b().toString();
    }
}

