/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.armor;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.achievements.GraviAchievement;
import gravisuite.common.DamageSources;
import gravisuite.common.Helpers;
import gravisuite.items.ItemSimpleItems;
import gravisuite.keyboard.Keyboard;
import gravisuite.network.PacketQuantumShield;
import gravisuite.proxy.ServerProxy;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemGraviChestPlate
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    public static int _mMaxCharge;
    public static int _mMinCharge;
    public static int _mTransferLimit;
    public static int _mTier;
    public static int _mDischargeInFlight;
    public static int _mDischargeIdleMode;
    public static int _mDischargeShieldIdle;
    public static float _mBoostSpeed;
    public static int _mBoostMultiplier;
    private static double _HoverModeFallSpeed;
    private static final int _mDischargeCurative = 4000;
    private static final int _mDischargeExtinguish = 1000;
    private static final int _mDischargeMedkit = 4000;
    private static String[] _mAllowedHelmets;
    private static String[] _mAllowedLeggins;
    private static String[] _mAllowedBoots;
    private Map<String, CLastHealthElement> _mPlayerHealthMap = new HashMap<String, CLastHealthElement>();

    public ItemGraviChestPlate(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
        _mMaxCharge = GraviProperties.ElectricPreSets.GraviChestPlate.MaxCharge;
        _mTransferLimit = GraviProperties.ElectricPreSets.GraviChestPlate.TransferLimit;
        _mTier = GraviProperties.ElectricPreSets.GraviChestPlate.Tier;
        _mMinCharge = 10000;
        _mDischargeInFlight = GraviProperties.ElectricPreSets.GraviChestPlate.EnergyPerOperation;
        _mDischargeShieldIdle = 5000;
        _mDischargeIdleMode = 1;
        _mBoostSpeed = 0.2f;
        _mBoostMultiplier = 3;
        this.func_77637_a(GraviSuite._mGraviCreativeTab);
        this.func_77656_e(27);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathEvent(LivingDeathEvent pEvent) {
        if (!(pEvent.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer tEP = (EntityPlayer)pEvent.entity;
        ItemStack chest = tEP.func_71124_b(3);
        if (chest != null && chest.func_77973_b() instanceof ItemGraviChestPlate && ItemGraviChestPlate.readShieldMode(chest) && ItemGraviChestPlate.hasValidShieldEquipment(tEP)) {
            try {
                tEP.func_70606_j(tEP.func_110138_aP());
                tEP.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 200, 4));
                pEvent.setCanceled(true);
                PacketQuantumShield.issue(tEP.func_145782_y(), -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent pEvent) {
        if (!(pEvent.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer tEP = (EntityPlayer)pEvent.entity;
        ItemStack chest = tEP.func_71124_b(3);
        double tEnergyRequired = pEvent.ammount / 2.0f * (float)this.getEnergyPerDamage();
        if (chest != null && chest.func_77973_b() instanceof ItemGraviChestPlate && ItemGraviChestPlate.readShieldMode(chest)) {
            if (ItemGraviChestPlate.hasValidShieldEquipment(tEP)) {
                if (ElectricItem.manager.canUse(chest, tEnergyRequired)) {
                    if (pEvent.source instanceof DamageSources.EntityDamageSourcePlazma) {
                        GraviAchievement.QSHIELD_PLASMAIMPACT.triggerAchievement(tEP);
                    }
                    ElectricItem.manager.discharge(chest, tEnergyRequired, GraviProperties.ElectricPreSets.GraviChestPlate.Tier, true, false, false);
                    tEP.field_70172_ad = 20;
                    tEP.field_70737_aN = 0;
                    pEvent.ammount = 0.0f;
                    if (pEvent.isCancelable()) {
                        pEvent.setCanceled(true);
                    } else {
                        tEP.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 20, 4));
                    }
                    int tID = tEP.func_145782_y();
                    int tTarget = -1;
                    if (pEvent.source.func_76346_g() != null) {
                        tTarget = pEvent.source.func_76346_g().func_145782_y();
                    }
                    if (pEvent.source == DamageSource.field_76379_h) {
                        tTarget = -2;
                    }
                    if (pEvent.source == DamageSource.field_82729_p) {
                        tTarget = -3;
                    }
                    ItemGraviChestPlate.notifyWorldShieldImpact(tEP);
                    PacketQuantumShield.issue(tID, tTarget);
                } else {
                    ItemGraviChestPlate.saveShieldMode(chest, false);
                    ServerProxy.sendPlayerMessage(tEP, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.lowpowerShieldBreak"));
                    ItemGraviChestPlate.notifyWorldShieldDown(tEP);
                }
            } else {
                ItemGraviChestPlate.saveShieldMode(chest, false);
                ServerProxy.sendPlayerMessage(tEP, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.invalidSetupShieldBreak"));
                ItemGraviChestPlate.notifyWorldShieldDown(tEP);
            }
        }
    }

    private static boolean hasValidShieldEquipment(EntityPlayer player) {
        try {
            ItemStack helmet = player.func_71124_b(4);
            ItemStack chest = player.func_71124_b(3);
            ItemStack leggings = player.func_71124_b(2);
            ItemStack boots = player.func_71124_b(1);
            boolean pass = false;
            if (chest != null && chest.func_77973_b() instanceof ItemGraviChestPlate && helmet != null && ItemGraviChestPlate.checkHelmetItem(helmet.func_77973_b()) && leggings != null && ItemGraviChestPlate.checkLegItem(leggings.func_77973_b()) && boots != null && ItemGraviChestPlate.checkBootsItem(boots.func_77973_b())) {
                pass = true;
            }
            return pass;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkHelmetItem(Item pItem) {
        boolean tRet = false;
        GameRegistry.UniqueIdentifier tUid = GameRegistry.findUniqueIdentifierFor((Item)pItem);
        if (pItem instanceof ItemArmorQuantumSuit) {
            tRet = true;
        }
        for (int i = 0; i < _mAllowedHelmets.length; ++i) {
            if (!_mAllowedHelmets[i].equals(tUid.toString())) continue;
            tRet = true;
            break;
        }
        return tRet;
    }

    private static boolean checkLegItem(Item pItem) {
        boolean tRet = false;
        GameRegistry.UniqueIdentifier tUid = GameRegistry.findUniqueIdentifierFor((Item)pItem);
        if (pItem instanceof ItemArmorQuantumSuit) {
            tRet = true;
        }
        for (int i = 0; i < _mAllowedLeggins.length; ++i) {
            if (!_mAllowedLeggins[i].equals(tUid.toString())) continue;
            tRet = true;
            break;
        }
        return tRet;
    }

    private static boolean checkBootsItem(Item pItem) {
        boolean tRet = false;
        GameRegistry.UniqueIdentifier tUid = GameRegistry.findUniqueIdentifierFor((Item)pItem);
        if (pItem instanceof ItemArmorQuantumSuit) {
            tRet = true;
        }
        for (int i = 0; i < _mAllowedBoots.length; ++i) {
            if (!_mAllowedBoots[i].equals(tUid.toString())) continue;
            tRet = true;
            break;
        }
        return tRet;
    }

    public static int switchShieldMode(EntityPlayer player, ItemStack itemstack) {
        if (!ItemGraviChestPlate.hasValidShieldEquipment(player)) {
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.invalidshieldSetup"));
            return 0;
        }
        if (!ElectricItem.manager.canUse(itemstack, (double)(_mDischargeShieldIdle * 10))) {
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.ShieldUpNotEnoughPower"));
            return 0;
        }
        if (ItemGraviChestPlate.readShieldMode(itemstack)) {
            ItemGraviChestPlate.saveShieldMode(itemstack, false);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + Helpers.formatMessage("message.graviChestPlate.shieldMode") + " " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
            ItemGraviChestPlate.notifyWorldShieldDown(player);
        } else {
            ItemGraviChestPlate.saveShieldMode(itemstack, true);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + Helpers.formatMessage("message.graviChestPlate.shieldMode") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
            ItemGraviChestPlate.notifyWorldShieldUp(player);
            GraviAchievement.QSHIELD.triggerAchievement(player);
        }
        return 0;
    }

    private static void notifyWorldShieldImpact(EntityPlayer pEp) {
        pEp.field_70170_p.func_72956_a((Entity)pEp, "gravisuite:qshieldimpact", 1.25f, 1.0f);
    }

    private static void notifyWorldMedKit(EntityPlayer pEp) {
        pEp.field_70170_p.func_72956_a((Entity)pEp, "gravisuite:medkit", 1.25f, 1.0f);
    }

    private static void notifyWorldShieldUp(EntityPlayer pEp) {
        pEp.field_70170_p.func_72956_a((Entity)pEp, "gravisuite:qshieldon", 1.25f, 1.0f);
        PacketQuantumShield.issue(pEp.func_145782_y(), -4);
    }

    private static void notifyWorldShieldDown(EntityPlayer pEp) {
        pEp.field_70170_p.func_72956_a((Entity)pEp, "gravisuite:qshieldoff", 1.25f, 1.0f);
        PacketQuantumShield.issue(pEp.func_145782_y(), -5);
    }

    public static int switchWorkMode(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readWorkMode(itemstack)) {
            ItemGraviChestPlate.saveWorkMode(itemstack, false);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + Helpers.formatMessage("message.graviChestPlate.levitationMode") + " " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
        } else {
            ItemGraviChestPlate.saveWorkMode(itemstack, true);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + Helpers.formatMessage("message.graviChestPlate.levitationMode") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
        }
        return 0;
    }

    public static int switchFlyState(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readFlyStatus(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            ItemGraviChestPlate.saveFlyStatus(itemstack, false);
            ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + " " + Helpers.formatMessage("message.text.disabled"));
        } else {
            int currCharge = ItemGraviChestPlate.getCharge(itemstack);
            if (currCharge >= _mMinCharge || player.field_71075_bZ.field_75098_d) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + " " + Helpers.formatMessage("message.text.enabled"));
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75100_b = true;
                ItemGraviChestPlate.saveFlyStatus(itemstack, true);
            } else {
                ServerProxy.sendPlayerMessage(player, Helpers.formatMessage("message.graviChestPlate.lowEnergy"));
            }
        }
        return 0;
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        int currCharge;
        if (GraviSuite.proxy.checkLastUndressed(player)) {
            GraviSuite.proxy.SetLastUndressed(player, false);
        }
        if (ItemGraviChestPlate.readFlyStatus(itemStack)) {
            if (!GraviSuite.proxy.checkFlyActiveByMod(player)) {
                GraviSuite.proxy.SetFlyActiveByMod(player, true);
            }
            if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                if (!player.field_70122_E) {
                    player.field_71075_bZ.field_75100_b = true;
                }
            }
            if (ItemGraviChestPlate.readWorkMode(itemStack) && (Keyboard.isJumpKeyDown(player) || player.field_70181_x < -_HoverModeFallSpeed && !player.field_70122_E) && !player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = true;
            }
            GraviSuite.getOrCreateNbtData(itemStack);
            currCharge = ItemGraviChestPlate.getCharge(itemStack);
            if (!player.field_71075_bZ.field_75098_d) {
                if (currCharge < _mDischargeInFlight) {
                    ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.shutdown"));
                    ItemGraviChestPlate.switchFlyState(player, itemStack);
                } else if (!player.field_70122_E) {
                    ElectricItem.manager.discharge(itemStack, (double)_mDischargeInFlight, 4, false, false, false);
                } else {
                    ElectricItem.manager.discharge(itemStack, (double)_mDischargeIdleMode, 4, false, false, false);
                }
            }
            player.field_70143_R = 0.0f;
            if (!player.field_70122_E && player.field_71075_bZ.field_75100_b && Keyboard.isBoostKeyDown(player)) {
                this.boostMode(player, itemStack);
                if (currCharge > _mDischargeInFlight * _mBoostMultiplier || player.field_71075_bZ.field_75098_d) {
                    if (Keyboard.isJumpKeyDown(player)) {
                        player.field_70181_x += (double)(_mBoostSpeed + 0.1f);
                    }
                    if (Keyboard.isSneakKeyDown(player)) {
                        player.field_70181_x -= (double)(_mBoostSpeed + 0.1f);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.discharge(itemStack, (double)(_mDischargeInFlight * _mBoostMultiplier), 3, true, false, false);
                    }
                } else {
                    ServerProxy.sendPlayerMessage(player, Helpers.formatMessage("message.graviChestPlate.noEnergyToBoost"));
                }
            }
        } else if (GraviSuite.proxy.checkFlyActiveByMod(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            if (GraviSuite.isSimulating()) {
                GraviSuite.proxy.SetFlyActiveByMod(player, false);
            }
        }
        if (ItemGraviChestPlate.readShieldMode(itemStack)) {
            currCharge = ItemGraviChestPlate.getCharge(itemStack);
            if (!ItemGraviChestPlate.hasValidShieldEquipment(player)) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.invalidSetupShieldBreak"));
                ItemGraviChestPlate.saveShieldMode(itemStack, false);
                ItemGraviChestPlate.notifyWorldShieldDown(player);
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (currCharge < _mDischargeShieldIdle) {
                    ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.lowpowerShieldBreak"));
                    ItemGraviChestPlate.saveShieldMode(itemStack, false);
                    ItemGraviChestPlate.notifyWorldShieldDown(player);
                    return;
                }
                ElectricItem.manager.discharge(itemStack, (double)_mDischargeShieldIdle, 4, false, false, false);
            }
            this.runHealthMonitor(worldObj, player, itemStack);
        }
        if (player.func_70027_ad() && ElectricItem.manager.canUse(itemStack, 1000.0)) {
            ElectricItem.manager.discharge(itemStack, 1000.0, 4, true, false, false);
            player.func_70066_B();
        }
        ItemGraviChestPlate.curePotions(itemStack, player, false);
    }

    private void runHealthMonitor(World worldObj, EntityPlayer player, ItemStack itemStack) {
        float tCurrHealth = player.func_110143_aJ();
        CLastHealthElement tLastHealthElement = null;
        String tPlayerID = player.func_110124_au().toString();
        if (this._mPlayerHealthMap.containsKey(tPlayerID)) {
            tLastHealthElement = this._mPlayerHealthMap.get(tPlayerID);
        }
        if (tLastHealthElement == null || tLastHealthElement != null && tLastHealthElement.Time - System.currentTimeMillis() < -5000L) {
            tLastHealthElement = new CLastHealthElement(0.0f, System.currentTimeMillis());
        }
        if (tCurrHealth > tLastHealthElement.HP) {
            this._mPlayerHealthMap.put(tPlayerID, new CLastHealthElement(tCurrHealth, System.currentTimeMillis()));
        } else if (tCurrHealth + 2.0f < tLastHealthElement.HP) {
            player.func_70606_j(tLastHealthElement.HP);
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 40, 4));
            ElectricItem.manager.discharge(itemStack, 4000.0, 4, false, false, false);
            ItemGraviChestPlate.notifyWorldShieldImpact(player);
            PacketQuantumShield.issue(player.func_145782_y(), -1);
            if (tLastHealthElement.Time - System.currentTimeMillis() < -2000L) {
                this._mPlayerHealthMap.put(tPlayerID, new CLastHealthElement(tCurrHealth, System.currentTimeMillis()));
            }
        }
    }

    public static void performMedkitAction(EntityPlayer pPlayer, ItemStack pItemstack) {
        if (pPlayer == null || pItemstack == null) {
            return;
        }
        if (!(pItemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return;
        }
        if (ElectricItem.manager.canUse(pItemstack, 4000.0)) {
            boolean tNanobotsUsed = false;
            for (int i = 0; i < 36; ++i) {
                ItemStack is = pPlayer.field_71071_by.field_70462_a[i];
                if (is == null || !(is.func_77973_b() instanceof ItemSimpleItems) || !is.func_77977_a().equals("item.itemAntidote")) continue;
                if (is.field_77994_a == 1) {
                    pPlayer.field_71071_by.field_70462_a[i] = null;
                } else {
                    --is.field_77994_a;
                }
                tNanobotsUsed = true;
                break;
            }
            if (tNanobotsUsed) {
                ElectricItem.manager.discharge(pItemstack, 4000.0, 4, true, false, false);
                ItemGraviChestPlate.curePotions(pItemstack, pPlayer, true);
                ItemGraviChestPlate.notifyWorldMedKit(pPlayer);
                ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.GREEN + Helpers.formatMessage("message.graviChestPlate.MedkitInjected"));
            } else {
                ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.MedkitNoNanoBots"));
            }
        } else {
            ServerProxy.sendPlayerMessage(pPlayer, EnumChatFormatting.RED + Helpers.formatMessage("message.graviChestPlate.MedkitNoPower"));
        }
    }

    private static void curePotions(ItemStack pIS, EntityPlayer pEP, boolean pMedkitCure) {
        ArrayList<Potion> tPotions = new ArrayList<Potion>();
        tPotions.add(Potion.field_82731_v);
        if (pMedkitCure) {
            tPotions.add(Potion.field_76440_q);
            tPotions.add(Potion.field_76431_k);
            tPotions.add(Potion.field_76419_f);
            tPotions.add(Potion.field_76433_i);
            tPotions.add(Potion.field_76438_s);
            tPotions.add(Potion.field_76421_d);
            tPotions.add(Potion.field_76436_u);
            tPotions.add(Potion.field_76437_t);
        }
        for (Potion tP : tPotions) {
            if (!pEP.func_70644_a(tP) || !ElectricItem.manager.canUse(pIS, 4000.0)) continue;
            pEP.func_82170_o(tP.field_76415_H);
            if (pMedkitCure) continue;
            ElectricItem.manager.discharge(pIS, 4000.0, 4, true, false, false);
        }
        if (pMedkitCure) {
            Iterator iterator = pEP.func_70651_bq().iterator();
            ArrayList<Integer> tIDsToRemove = new ArrayList<Integer>();
            while (iterator.hasNext()) {
                PotionEffect potioneffect = (PotionEffect)iterator.next();
                if (!Potion.field_76425_a[potioneffect.func_76456_a()].func_76398_f()) continue;
                tIDsToRemove.add(potioneffect.func_76456_a());
            }
            for (Integer tI : tIDsToRemove) {
                if (!ElectricItem.manager.canUse(pIS, 4000.0)) continue;
                pEP.func_82170_o(tI.intValue());
            }
        }
    }

    public boolean boostMode(EntityPlayer player, ItemStack itemstack) {
        int currCharge;
        if (ItemGraviChestPlate.readFlyStatus(itemstack) && !player.field_70122_E && player.field_71075_bZ.field_75100_b && !player.func_70090_H() && ((currCharge = ItemGraviChestPlate.getCharge(itemstack)) > _mDischargeInFlight * _mBoostMultiplier || player.field_71075_bZ.field_75098_d)) {
            player.func_70060_a(player.field_70702_br, player.field_70701_bs, _mBoostSpeed);
            if (!player.field_71075_bZ.field_75098_d) {
                ElectricItem.manager.discharge(itemstack, (double)(_mDischargeInFlight * _mBoostMultiplier), 3, true, false, false);
            }
        }
        return true;
    }

    public static boolean firstLoadServer(EntityPlayer player, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String gravitationEngine = ItemGraviChestPlate.readFlyStatus(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.RED + Helpers.formatMessage("message.text.off");
        String shieldStatus = ItemGraviChestPlate.readShieldMode(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.RED + Helpers.formatMessage("message.text.off");
        String leviatitonModeStatus = ItemGraviChestPlate.readWorkMode(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.RED + Helpers.formatMessage("message.text.off");
        list.add(EnumChatFormatting.AQUA + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + ": " + gravitationEngine);
        list.add(EnumChatFormatting.AQUA + Helpers.formatMessage("message.graviChestPlate.levitationMode") + ": " + leviatitonModeStatus);
        list.add(EnumChatFormatting.AQUA + Helpers.formatMessage("message.graviChestPlate.shieldMode") + ": " + shieldStatus);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public static int getCharge(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        int k = nbttagcompound.func_74762_e("charge");
        return k;
    }

    public static void setCharge(ItemStack itemstack, int newCharge) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("charge", newCharge);
        System.out.println(newCharge);
    }

    public int getEnergyPerDamage() {
        return 3000;
    }

    public double getDamageAbsorptionRatio() {
        return GraviProperties.ArmorPresets.GraviChestPlate.mDamageAbsorptionRatio;
    }

    private double getBaseAbsorptionRatio() {
        return GraviProperties.ArmorPresets.GraviChestPlate.mBaseAbsorptionRatio;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemGraviChestPlate");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_graviChestPlate.png";
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return _mMaxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return _mTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return _mTransferLimit;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public static boolean readShieldMode(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isShieldActive");
    }

    public static boolean readWorkMode(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isLevitationActive");
    }

    public static boolean saveWorkMode(ItemStack itemstack, boolean workMode) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isLevitationActive", workMode);
        return true;
    }

    public static boolean saveShieldMode(ItemStack itemstack, boolean workMode) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isShieldActive", workMode);
        return true;
    }

    public static boolean readFlyStatus(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isFlyActive");
    }

    public static boolean saveFlyStatus(ItemStack itemstack, boolean flyMode) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActive", flyMode);
        return true;
    }

    public static boolean readActiveByModStatus(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isFlyActiveByMod");
    }

    public static boolean saveActiveByModStatus(ItemStack itemstack, boolean activeByMod) {
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return false;
        }
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActiveByMod", activeByMod);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    static {
        _mAllowedHelmets = new String[]{"AdvancedSolarPanel:hybrid_solar_helmet", "AdvancedSolarPanel:ultimate_solar_helmet"};
        _mAllowedLeggins = new String[0];
        _mAllowedBoots = new String[0];
    }

    private static class CLastHealthElement {
        public float HP;
        public long Time;

        public CLastHealthElement(float pHP, long pTimeVal) {
            this.HP = pHP;
            this.Time = pTimeVal;
        }
    }
}

