/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviProperties;
import gravisuite.GraviSuite;
import gravisuite.armor.ItemAdvancedJetPack;
import gravisuite.audio.AudioSource;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedNanoChestPlate
extends ItemAdvancedJetPack {
    public static int _mMaxCharge;
    public static int _mEnergyPerTick;
    public static int _mBoostMultiplier;
    private static byte _mTickRate;
    private static byte _mTicker;
    private final int _mEnergyForExtinguish = 50000;
    public AudioSource _mAudioSource;

    public ItemAdvancedNanoChestPlate(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
        this.func_77637_a(GraviSuite._mGraviCreativeTab);
        this.func_77656_e(27);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(EntityPlayer var1, ItemStack var2, int var3) {
        return ElectricItem.manager.discharge(var2, 2.147483647E9, Integer.MAX_VALUE, true, false, true) >= (double)this.getEnergyPerDamage() ? (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio()) : 0;
    }

    @Override
    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(worldObj, player, itemStack);
        byte by = _mTicker;
        _mTicker = (byte)(by + 1);
        if (by % _mTickRate == 0 && player.func_70027_ad() && ElectricItem.manager.canUse(itemStack, 50000.0)) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack mainItem;
                if (player.field_71071_by.field_70462_a[i] == null || (mainItem = player.field_71071_by.field_70462_a[i].func_77946_l()).func_77973_b() != IC2Items.getItem((String)"waterCell").func_77973_b()) continue;
                if (player.field_71071_by.field_70462_a[i].field_77994_a > 1) {
                    --player.field_71071_by.field_70462_a[i].field_77994_a;
                } else {
                    player.field_71071_by.field_70462_a[i] = null;
                }
                ItemAdvancedNanoChestPlate.use(itemStack, 50000);
                player.func_70066_B();
                break;
            }
        }
    }

    @Override
    public int getEnergyPerDamage() {
        return 800;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return GraviProperties.ArmorPresets.AdvNanoChestPlate.mDamageAbsorptionRatio;
    }

    @Override
    public double getBaseAbsorptionRatio() {
        return GraviProperties.ArmorPresets.AdvNanoChestPlate.mBaseAbsorptionRatio;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedNanoChestPlate");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_advNanoChestPlate.png";
    }

    static {
        _mTickRate = (byte)20;
    }
}

