/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.BlockRelocatorPortal;
import gravisuite.GraviSuite;
import gravisuite.TileEntityRelocatorPortal;
import gravisuite.achievements.GraviAchievement;
import gravisuite.common.DamageSources;
import gravisuite.common.Helpers;
import gravisuite.proxy.ServerProxy;
import gravisuite.tools.ItemRelocator;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityPlasmaBall
extends EntityThrowable {
    private EntityLivingBase ownerEntity;
    private double startX;
    private double startY;
    private double startZ;
    private double maxRange;
    private double speedPerTick;
    private double dischargeArmorValue;
    private byte actionType;
    private float _mCharge = 0.0f;
    private ItemRelocator.TeleportPoint targetTpPoint;
    public static final byte RELOCATOR_TELEPORT = 0;
    public static final byte RELOCATOR_PORTAL = 1;
    public static final byte PLAZMABALL_WEAPON = 2;
    public static final float PLASMA_DAMAGE = 100.0f;
    private int _mFinalTicksForDestruction = -1;

    public EntityPlasmaBall(World world, EntityPlasmaBall pOrigin, float pCharge) {
        this(world, pOrigin.ownerEntity, null, 3);
        this._mCharge = pCharge;
        this.maxRange = 512.0;
        this.speedPerTick = 1.0;
        this.actionType = (byte)3;
        this._mFinalTicksForDestruction = this.field_70173_aa + 10;
        this.func_70016_h(0.0, 0.0, 0.0);
        this.field_70165_t = pOrigin.field_70165_t;
        this.field_70163_u = pOrigin.field_70163_u;
        this.field_70161_v = pOrigin.field_70161_v;
    }

    public EntityPlasmaBall(World world, EntityLivingBase entityLiving, float pCharge, byte entityType) {
        this(world, entityLiving, null, entityType);
        this._mCharge = pCharge;
        this.field_70180_af.func_75692_b(29, (Object)Float.valueOf(this._mCharge));
        this.maxRange = 512.0;
        this.speedPerTick = 1.33;
        if (entityType == 2) {
            this.changeEntitySpeed(3.0f);
        }
    }

    private void changeEntitySpeed(float pNewSpeed) {
        float magnitude = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        this.field_70159_w /= (double)magnitude;
        this.field_70181_x /= (double)magnitude;
        this.field_70179_y /= (double)magnitude;
        this.field_70159_w *= (double)pNewSpeed;
        this.field_70181_x *= (double)pNewSpeed;
        this.field_70179_y *= (double)pNewSpeed;
        this.speedPerTick *= (double)pNewSpeed;
    }

    public EntityPlasmaBall(World world, EntityLivingBase entityLiving, ItemRelocator.TeleportPoint tpPoint, byte entityType) {
        super(world, entityLiving);
        this.ownerEntity = entityLiving;
        this.startX = this.field_70165_t;
        this.startY = this.field_70163_u;
        this.startZ = this.field_70161_v;
        this.maxRange = 32.0;
        this.speedPerTick = 1.33;
        this.targetTpPoint = tpPoint;
        this.actionType = entityType;
        this.dischargeArmorValue = 500000.0;
        this.field_70180_af.func_75692_b(30, (Object)this.actionType);
    }

    public EntityPlasmaBall(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)Float.valueOf(this._mCharge));
        this.field_70180_af.func_75682_a(30, (Object)this.actionType);
        this.field_70180_af.func_82708_h(29);
        this.field_70180_af.func_82708_h(30);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            double distance = this.func_70011_f(this.startX, this.startY, this.startZ);
            if (distance >= this.maxRange || (double)this.field_70173_aa > this.maxRange / this.speedPerTick) {
                this.func_70106_y();
            }
            if (this._mFinalTicksForDestruction > -1 && this.field_70173_aa >= this._mFinalTicksForDestruction) {
                this.func_70106_y();
            }
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74774_a("actionType", this.actionType);
        nbt.func_74776_a("charge", this._mCharge);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.actionType = nbt.func_74771_c("actionType");
        this._mCharge = nbt.func_74760_g("charge");
    }

    public float getCharge() {
        return this.field_70180_af.func_111145_d(29);
    }

    public byte getActionType() {
        return this.field_70180_af.func_75683_a(30);
    }

    public static double getImpactRadius(float pPlasmaEfficiency) {
        double nominalRadius = 6.0;
        return (double)pPlasmaEfficiency * nominalRadius;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (this._mFinalTicksForDestruction != -1) {
            return;
        }
        if (this.actionType == 2) {
            double calculatedRadius;
            double tImpactRadius = calculatedRadius = EntityPlasmaBall.getImpactRadius(this._mCharge);
            boolean tTerrainDamage = this._mCharge >= 2.0f;
            tImpactRadius = Math.min(15.0, tImpactRadius);
            tImpactRadius = Math.max(1.0, tImpactRadius);
            List e = mop.field_72308_g != null ? this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(mop.field_72308_g.field_70165_t - tImpactRadius), (double)(mop.field_72308_g.field_70163_u - tImpactRadius), (double)(mop.field_72308_g.field_70161_v - tImpactRadius), (double)(mop.field_72308_g.field_70165_t + tImpactRadius), (double)(mop.field_72308_g.field_70163_u + tImpactRadius), (double)(mop.field_72308_g.field_70161_v + tImpactRadius))) : this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)mop.field_72311_b - tImpactRadius), (double)((double)mop.field_72312_c - tImpactRadius), (double)((double)mop.field_72309_d - tImpactRadius), (double)((double)mop.field_72311_b + tImpactRadius), (double)((double)mop.field_72312_c + tImpactRadius), (double)((double)mop.field_72309_d + tImpactRadius)));
            float tFinalDamage = this._mCharge * 100.0f;
            if (tTerrainDamage) {
                this.field_70170_p.func_72876_a((Entity)null, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, this._mCharge, true);
            }
            long tDamageDealt = 0L;
            long tEntitiesHitDeadly = 0L;
            for (EntityLivingBase el : e) {
                if (el.func_110143_aJ() < tFinalDamage) {
                    ++tEntitiesHitDeadly;
                }
                el.func_70097_a(DamageSources.causePlayerPlazmaDamage((EntityPlayer)this.ownerEntity), tFinalDamage);
                tDamageDealt = (long)((float)tDamageDealt + tFinalDamage);
            }
            if (tDamageDealt > 9000L) {
                GraviAchievement.OVER9000.triggerAchievement((EntityPlayer)this.ownerEntity);
            }
            if (tEntitiesHitDeadly > 100L) {
                GraviAchievement.ULTRAKILL.triggerAchievement((EntityPlayer)this.ownerEntity);
            }
            EntityPlasmaBall explosionBall = new EntityPlasmaBall(this.field_70170_p, this, this._mCharge);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72908_a((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, "gravisuite:plasmaImpact", 1.25f, 1.0f);
                this.field_70170_p.func_72838_d((Entity)explosionBall);
                this.func_70106_y();
            }
            return;
        }
        if (mop.field_72308_g != null) {
            if (this.actionType == 0) {
                if (mop.field_72308_g instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)mop.field_72308_g;
                    ItemStack itemstack = player.field_71071_by.field_70460_b[2];
                    if (itemstack != null && itemstack.func_77973_b() == GraviSuite.graviChestPlate) {
                        if (ElectricItem.manager.getCharge(itemstack) < this.dischargeArmorValue) {
                            Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                        } else if (GraviSuite.isSimulating()) {
                            ServerProxy.sendPlayerMessage(player, this.ownerEntity.func_70005_c_() + " " + Helpers.formatMessage("message.relocator.text.messageToTarget"));
                            ElectricItem.manager.discharge(itemstack, this.dischargeArmorValue, Integer.MAX_VALUE, true, false, false);
                        }
                    } else {
                        Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                    }
                } else {
                    Helpers.teleportEntity(mop.field_72308_g, this.targetTpPoint);
                }
            }
        } else if (this.actionType == 1) {
            int curPosX = mop.field_72311_b;
            int curPosY = mop.field_72312_c;
            int curPosZ = mop.field_72309_d;
            switch (mop.field_72310_e) {
                case 0: {
                    --curPosY;
                    break;
                }
                case 1: {
                    ++curPosY;
                    break;
                }
                case 2: {
                    --curPosZ;
                    break;
                }
                case 3: {
                    ++curPosZ;
                    break;
                }
                case 4: {
                    --curPosX;
                    break;
                }
                case 5: {
                    ++curPosX;
                }
            }
            if (GraviSuite.isSimulating()) {
                try {
                    TileEntity tileEntity;
                    this.field_70170_p.func_147468_f(curPosX, curPosY, curPosZ);
                    this.field_70170_p.func_147449_b(curPosX, curPosY, curPosZ, GraviSuite.blockRelocatorPortal);
                    this.field_70170_p.func_147471_g(curPosX, curPosY, curPosZ);
                    MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
                    WorldServer targetServer = minecraftserver.func_71218_a(this.targetTpPoint.dimID);
                    targetServer.field_73059_b.func_73158_c((int)this.targetTpPoint.x >> 4, (int)this.targetTpPoint.z >> 4);
                    Block block = targetServer.func_147439_a((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z);
                    if (!(block instanceof BlockRelocatorPortal)) {
                        targetServer.func_147449_b((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z, GraviSuite.blockRelocatorPortal);
                        targetServer.func_147471_g((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z);
                    }
                    if ((tileEntity = targetServer.func_147438_o((int)this.targetTpPoint.x, (int)this.targetTpPoint.y, (int)this.targetTpPoint.z)) instanceof TileEntityRelocatorPortal) {
                        ItemRelocator.TeleportPoint tmpPoint = new ItemRelocator.TeleportPoint();
                        tmpPoint.dimID = this.field_70170_p.field_73011_w.field_76574_g;
                        tmpPoint.x = curPosX;
                        tmpPoint.y = curPosY;
                        tmpPoint.z = curPosZ;
                        ((TileEntityRelocatorPortal)tileEntity).setParentPortal(tmpPoint);
                    }
                    TileEntity currentTileEntity = this.field_70170_p.func_147438_o(curPosX, curPosY, curPosZ);
                    if (tileEntity instanceof TileEntityRelocatorPortal) {
                        ((TileEntityRelocatorPortal)currentTileEntity).setParentPortal(this.targetTpPoint);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

