/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.network;

import com.github.technus.tectech.TecTech;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public abstract class MessageMTEBase
implements IMessage {
    protected int w;
    protected int x;
    protected short y;
    protected int z;

    public MessageMTEBase() {
    }

    public MessageMTEBase(IGregTechTileEntity tile) {
        this.w = tile.getWorld().field_73011_w.field_76574_g;
        this.x = tile.getXCoord();
        this.y = tile.getYCoord();
        this.z = tile.getZCoord();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readShort();
        this.z = buf.readInt();
        this.w = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort((int)this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.w);
    }

    public static abstract class Handler<REQ extends MessageMTEBase, REPLY extends IMessage>
    implements IMessageHandler<REQ, REPLY> {
        protected abstract REPLY onError(REQ var1, MessageContext var2);

        protected abstract REPLY onSuccess(REQ var1, MessageContext var2, IMetaTileEntity var3);

        public REPLY onMessage(REQ message, MessageContext ctx) {
            IMetaTileEntity mte;
            TileEntity te;
            World world;
            if (ctx.side == Side.SERVER) {
                world = DimensionManager.getWorld((int)((MessageMTEBase)message).w);
            } else {
                world = TecTech.proxy.getClientWorld();
                if (world.field_73011_w.field_76574_g != ((MessageMTEBase)message).w) {
                    return this.onError(message, ctx);
                }
            }
            if (world == null) {
                return this.onError(message, ctx);
            }
            if (world.func_72899_e(((MessageMTEBase)message).x, (int)((MessageMTEBase)message).y, ((MessageMTEBase)message).z) && (te = world.func_147438_o(((MessageMTEBase)message).x, (int)((MessageMTEBase)message).y, ((MessageMTEBase)message).z)) instanceof IGregTechTileEntity && !((IGregTechTileEntity)te).isInvalidTileEntity() && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) != null) {
                return this.onSuccess(message, ctx, mte);
            }
            return this.onError(message, ctx);
        }
    }
}

