/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.base;

import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.client.GUI.LargeFusionComputerGUIClient;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class LargeFusionComputer
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable {
    public static final String MAIN_NAME = "largeFusion";
    private boolean isLoadedChunk;
    public GT_Recipe mLastRecipe;
    public int para;
    public int mEUStore;
    private static final ClassValue<IStructureDefinition<LargeFusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<LargeFusionComputer>>(){

        @Override
        protected IStructureDefinition<LargeFusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(LargeFusionComputer.MAIN_NAME, StructureUtility.transpose((String[][])new String[][]{L0, L1, L2, L3, L2, L1, L0})).addElement('H', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(), (int)x.getCoilMeta()))).addElement('C', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(), (int)x.getCasingMeta()))).addElement('B', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('I', (IStructureElement)StructureUtility.lazy(x -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((LargeFusionComputer)((Object)((Object)((Object)rec$)))).addInjector(x$0, x$1), (int)x.textureIndex(), (int)1, (Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('O', (IStructureElement)StructureUtility.lazy(x -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((LargeFusionComputer)((Object)((Object)((Object)rec$)))).addExtractor(x$0, x$1), (int)x.textureIndex(), (int)2, (Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('E', (IStructureElement)StructureUtility.lazy(x -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((LargeFusionComputer)((Object)((Object)((Object)rec$)))).addEnergyInjector(x$0, x$1), (int)x.textureIndex(), (int)3, (Block)x.getCasingBlock(), (int)x.getCasingMeta()))).addElement('F', (IStructureElement)StructureUtility.lazy(x -> GT_StructureUtility.ofFrame((Materials)x.getFrameBox()))).build();
        }
    };
    public static final String[] L0;
    public static final String[] L1;
    public static final String[] L2;
    public static final String[] L3;

    public LargeFusionComputer(String name) {
        super(name);
    }

    public LargeFusionComputer(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new LargeFusionComputerGUIClient(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "EMDisplay.png");
    }

    public abstract long maxEUStore();

    public abstract Block getCasingBlock();

    public abstract int getCasingMeta();

    public abstract Block getCoilBlock();

    public abstract int getCoilMeta();

    public abstract Block getGlassBlock();

    public abstract int getGlassMeta();

    public abstract int hatchTier();

    public abstract Materials getFrameBox();

    public abstract int getMaxPara();

    public abstract int extraPara(int var1);

    public int textureIndex() {
        return 53;
    }

    public abstract ITexture getTextureOverlay();

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.eEnergyMulti.clear();
        if (this.structureCheck_EM(MAIN_NAME, 23, 3, 40) && this.mInputHatches.size() > 1 && !this.mOutputHatches.isEmpty() && this.mEnergyHatches.size() + this.eEnergyMulti.size() != 0) {
            this.fixAllIssue();
            return true;
        }
        return false;
    }

    public void fixAllIssue() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM(MAIN_NAME, 23, 3, 40, itemStack, b);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && !aBaseMetaTileEntity.isAllowedToWork()) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            this.isLoadedChunk = false;
        } else if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && !this.isLoadedChunk) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            int offX = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()).offsetX;
            int offZ = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()).offsetZ;
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() - 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() - 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + 1 + offZ));
            GT_ChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() - 1 + offZ));
            this.isLoadedChunk = true;
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick % 400L == 0L) {
                this.fixAllIssue();
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                this.checkRecipe(this.mInventory[1]);
            }
            if (this.mUpdated) {
                this.mUpdate = 50;
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0 || this.cyclicUpdate_EM() || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) {
                if (this.mUpdate <= -1000) {
                    this.mUpdate = 5000;
                }
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (this.mEnergyHatches != null) {
                        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
                            if (!LargeFusionComputer.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                            if (aBaseMetaTileEntity.getStoredEU() + 2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100) < this.maxEUStore() && tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), false)) {
                                aBaseMetaTileEntity.increaseStoredEnergyUnits(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), true);
                                continue;
                            }
                            if (aBaseMetaTileEntity.getStoredEU() + 2048L * (long)this.tierOverclock() >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048L * (long)this.tierOverclock(), false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(2048L * (long)this.tierOverclock(), true);
                        }
                    }
                    if (this.eEnergyMulti != null) {
                        for (GT_MetaTileEntity_Hatch_EnergyMulti tHatch : this.eEnergyMulti) {
                            if (!LargeFusionComputer.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                            if (aBaseMetaTileEntity.getStoredEU() + 2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100) < this.maxEUStore() && tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), false)) {
                                aBaseMetaTileEntity.increaseStoredEnergyUnits(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), true);
                                continue;
                            }
                            if (aBaseMetaTileEntity.getStoredEU() + 2048L * (long)this.tierOverclock() >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048L * (long)this.tierOverclock(), false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(2048L * (long)this.tierOverclock(), true);
                        }
                    }
                    if (this.mEUStore <= 0 && this.mMaxProgresstime > 0) {
                        this.stopMachine();
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)this.mEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (FluidStack fluidStack : this.mOutputFluids) {
                                    if (fluidStack == null) continue;
                                    this.addOutput(fluidStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            this.mEUStore = (int)this.getBaseMetaTileEntity().getStoredEU();
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe(this.mInventory[1]);
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork()) {
                            this.mEUStore = (int)this.getBaseMetaTileEntity().getStoredEU();
                            if (this.checkRecipe(this.mInventory[1])) {
                                if (this.mEUStore < this.mLastRecipe.mSpecialValue - this.mEUt) {
                                    this.mMaxProgresstime = 0;
                                    this.turnCasingActive(false);
                                }
                                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)(this.mLastRecipe.mSpecialValue - this.mEUt), false);
                            }
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else {
                    this.turnCasingActive(false);
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.eEnergyMulti != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.eEnergyMulti) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Energy hatch : this.mInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS}).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS}).extFacing().build()};
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public void onMachineBlockUpdate() {
        this.mUpdate = 100;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.mLastRecipe = null;
            this.para = 0;
            this.stopMachine();
            return false;
        }
        if (this.mEUStore <= 0) {
            this.mLastRecipe = null;
            this.para = 0;
            this.stopMachine();
            return false;
        }
        return true;
    }

    public abstract int tierOverclock();

    public int overclock(int mStartEnergy) {
        if (this.tierOverclock() == 1) {
            return 1;
        }
        if (this.tierOverclock() == 2) {
            return mStartEnergy < 160000000 ? 2 : 1;
        }
        if (this.tierOverclock() == 4) {
            return mStartEnergy < 160000000 ? 4 : (mStartEnergy < 320000000 ? 2 : 1);
        }
        if (this.tierOverclock() == 8) {
            return mStartEnergy < 160000000 ? 8 : (mStartEnergy < 320000000 ? 4 : (mStartEnergy < 640000000 ? 2 : 1));
        }
        return mStartEnergy < 160000000 ? 16 : (mStartEnergy < 320000000 ? 8 : (mStartEnergy < 640000000 ? 4 : (mStartEnergy < 1280000000 ? 2 : 1)));
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList tFluidList = this.getStoredFluids();
        if (tFluidList.size() > 1) {
            int pall;
            FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sFusionRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, Integer.MAX_VALUE, tFluids, new ItemStack[0]);
            if (tRecipe == null && !this.mRunningOnLoad || this.maxEUStore() < (long)tRecipe.mSpecialValue) {
                this.turnCasingActive(false);
                this.mLastRecipe = null;
                return false;
            }
            this.para = pall = RecipeFinderForParallel.handleParallelRecipe((GT_Recipe)tRecipe, (FluidStack[])tFluids, null, (int)Math.min(this.getMaxPara() * this.extraPara(tRecipe.mSpecialValue), (int)(this.getMaxEUInput() / (long)tRecipe.mEUt / (long)this.overclock(tRecipe.mSpecialValue))));
            if (this.mRunningOnLoad || pall > 0) {
                this.mLastRecipe = tRecipe;
                this.mEUt = this.mLastRecipe.mEUt * this.overclock(this.mLastRecipe.mSpecialValue) * pall;
                this.mMaxProgresstime = Math.max(this.mLastRecipe.mDuration / this.overclock(this.mLastRecipe.mSpecialValue), 1);
                this.mEfficiencyIncrease = 10000;
                this.mOutputFluids = ((ArrayList)RecipeFinderForParallel.getMultiOutput((GT_Recipe)this.mLastRecipe, (int)pall).getKey()).toArray(new FluidStack[0]);
                this.turnCasingActive(true);
                this.mRunningOnLoad = false;
                return true;
            }
        }
        return false;
    }

    public long getMaxEUInput() {
        long sum = 0L;
        for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
            if (!LargeFusionComputer.isValidMetaTileEntity((MetaTileEntity)hatch)) continue;
            sum += Math.min(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), hatch.maxEUInput() * hatch.maxAmperesIn());
        }
        for (GT_MetaTileEntity_Hatch_Energy hatch : this.eEnergyMulti) {
            if (!LargeFusionComputer.isValidMetaTileEntity((MetaTileEntity)hatch)) continue;
            sum += Math.min(2048L * (long)this.tierOverclock() * (long)this.getMaxPara() * (long)this.extraPara(100), hatch.maxEUInput() * hatch.maxAmperesIn());
        }
        return sum;
    }

    public void onRemoval() {
        if (this.isLoadedChunk) {
            GT_ChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public int getChunkX() {
        return this.getBaseMetaTileEntity().getXCoord() >> 4;
    }

    public int getChunkZ() {
        return this.getBaseMetaTileEntity().getZCoord() >> 4;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
            if (tHatch.mTier < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            GT_MetaTileEntity_Hatch_EnergyMulti tHatch = (GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity;
            if (tHatch.mTier < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add(tHatch);
        }
        return false;
    }

    private boolean addInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
        if (tHatch.mTier < this.hatchTier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        tHatch.mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add(tHatch);
    }

    private boolean addExtractor(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
        if (tHatch.mTier < this.hatchTier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add(tHatch);
    }

    public IStructureDefinition<LargeFusionComputer> getStructure_EM() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        String tier = this.hatchTier() == 6 ? EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET : (this.hatchTier() == 7 ? EnumChatFormatting.YELLOW + "II" + EnumChatFormatting.RESET : (this.hatchTier() == 8 ? EnumChatFormatting.GRAY + "III" + EnumChatFormatting.RESET : "IV"));
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt * this.para;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration * (float)this.para;
            }
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"scanner.info.UX.0") + ": " + EnumChatFormatting.LIGHT_PURPLE + GT_Utility.formatNumbers((long)this.para) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)powerRequired) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.mEUStore) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    static {
        Textures.BlockIcons.setCasingTextureForId((int)52, (ITexture)TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW}).extFacing().glow().build()}));
        L0 = new String[]{"                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "  FFF                                     FFF  ", "  CCC                                     CCC  ", "  CIC                                     CIC  ", "  CBC                                     CBC  ", "  CIC                                     CIC  ", "  CCC                                     CCC  ", "  FFF                                     FFF  ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               "};
        L1 = new String[]{"                                               ", "                    FCBBBCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCCC     CCCCCCC              ", "            CCCCCCC FCBBBCF CCCCCCC            ", "           CCCCC               CCCCC           ", "          CCCC                   CCCC          ", "         CCC                       CCC         ", "        CCC                         CCC        ", "       CCC                           CCC       ", "      CCC                             CCC      ", "     CCC                               CCC     ", "     CCC                               CCC     ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "  CCC                                     CCC  ", " FCCCF                                   FCCCF ", " C   C                                   C   C ", " B   B                                   B   B ", " B   B                                   B   B ", " B   B                                   B   B ", " C   C                                   C   C ", " FCCCF                                   FCCCF ", "  CCC                                     CCC  ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "     CCC                               CCC     ", "     CCC                               CCC     ", "      CCC                             CCC      ", "       CCC                           CCC       ", "        CCC                         CCC        ", "         CCC                       CCC         ", "          CCCC                   CCCC          ", "           CCCCC               CCCCC           ", "            CCCCCCC FCBBBCF CCCCCCC            ", "              CCCCCCC     CCCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCBBBCF                    ", "                                               "};
        L2 = new String[]{"                    FCCCCCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCHHHHHHHHHCCCCC              ", "            CCCCHHHCC     CCHHHCCCC            ", "           CCCHHCCCCC     CCCCCHHCCC           ", "          ECHHCCCCC FCCCCCF CCCCCHHCE          ", "         CCHCCCC               CCCCHCC         ", "        CCHCCC                   CCCHCC        ", "       CCHCE                       ECHCC       ", "      ECHCC                         CCHCE      ", "     CCHCE                           ECHCC     ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", " CCHCC                                   CCHCC ", "FCCHCCF                                 FCCHCCF", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "FCCHCCF                                 FCCHCCF", " CCHCC                                   CCHCC ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "     CCHCE                           ECHCC     ", "      ECHCC                         CCHCE      ", "       CCHCE                       ECHCC       ", "        CCHCCC                   CCCHCC        ", "         CCHCCCC               CCCCHCC         ", "          ECHHCCCCC FCCCCCF CCCCCHHCE          ", "           CCCHHCCCCC     CCCCCHHCCC           ", "            CCCCHHHCC     CCHHHCCCC            ", "              CCCCCHHHHHHHHHCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCCCCCF                    "};
        L3 = new String[]{"                    FCOBOCF                    ", "                   CC     CC                   ", "                CCCHHHHHHHHHCCC                ", "              CCHHHHHHHHHHHHHHHCC              ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "           CHHHHHHHCC     CCHHHHHHHC           ", "          CHHHHHCCC FCOBOCF CCCHHHHHC          ", "         CHHHHCC               CCHHHHC         ", "        CHHHCC                   CCHHHC        ", "       CHHHC                       CHHHC       ", "      CHHHC                         CHHHC      ", "     CHHHC                           CHHHC     ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", " CHHHC                                   CHHHC ", "FCHHHCF                                 FCHHHCF", "C HHH C                                 C HHH C", "O HHH O                                 O HHH O", "B HHH B                                 B HHH B", "O HHH O                                 O HHH O", "C HHH C                                 C HHH C", "FCHHHCF                                 FCHHHCF", " CHHHC                                   CHHHC ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "     CHHHC                           CHHHC     ", "      CHHHC                         CHHHC      ", "       CHHHC                       CHHHC       ", "        CHHHCC                   CCHHHC        ", "         CHHHHCC               CCHHHHC         ", "          CHHHHHCCC FCO~OCF CCCHHHHHC          ", "           CHHHHHHHCC     CCHHHHHHHC           ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "              CCHHHHHHHHHHHHHHHCC              ", "                CCCHHHHHHHHHCCC                ", "                   CC     CC                   ", "                    FCOBOCF                    "};
    }
}

