/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.loader.Loaders;
import goodgenerator.main.GoodGenerator;
import goodgenerator.network.MessageResetTileTexture;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.MyRecipeAdder;
import goodgenerator.util.StructureHelper;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class PreciseAssembler
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<PreciseAssembler> multiDefinition = null;
    protected int casingAmount;
    protected int casingTier;
    protected int machineTier;
    protected int mode;
    protected int energyHatchTier;

    public PreciseAssembler(String name) {
        super(name);
    }

    public PreciseAssembler(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IStructureDefinition<PreciseAssembler> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"CCCC~CCCC", "CMMMMMMMC", "CMMMMMMMC", "CMMMMMMMC", "CCCCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(PreciseAssembler::addToPAssList, (int)0, (int)1), StructureUtility.onElementPass(x -> ++x.casingAmount, StructureHelper.addTieredBlock(Loaders.preciseUnitCasing, PreciseAssembler::setCasingTier, PreciseAssembler::getCasingTier, 3))})).addElement('F', GT_StructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('G', StructureUtility.ofBlock((Block)Block.func_149634_a((Item)Ic2Items.reinforcedGlass.func_77973_b()), (int)0)).addElement('M', StructureHelper.addTieredBlock(GregTech_API.sBlockCasings1, PreciseAssembler::setMachineTier, PreciseAssembler::getMachineTier, 10)).build();
        }
        return this.multiDefinition;
    }

    public boolean addToPAssList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.casingTier = aNBT.func_74762_e("casingTier");
        this.machineTier = aNBT.func_74762_e("machineTier");
        this.mode = aNBT.func_74762_e("RunningMode");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("casingTier", this.casingTier);
        aNBT.func_74768_a("machineTier", this.machineTier);
        aNBT.func_74768_a("RunningMode", this.mode);
        super.saveNBTData(aNBT);
    }

    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mode = (this.mode + 1) % 2;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)));
        }
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    protected void calculateOverclockedNessMultiPara(long aEUt, int aDuration, int mAmperage, long maxInputPower) {
        maxInputPower = Math.min(maxInputPower, 0x7FFFFFFEL);
        while (aEUt <= maxInputPower && aDuration >= 1) {
            aEUt <<= 2;
            aDuration >>= 1;
        }
        aEUt >>= 2;
        if ((aDuration <<= 1) <= 0) {
            aDuration = 1;
        }
        if (aEUt == maxInputPower) {
            aEUt = (long)((double)maxInputPower * 0.9);
        }
        this.mEUt = GT_Utility.safeInt((long)aEUt);
        this.mMaxProgresstime = aDuration;
    }

    public boolean checkRecipe_EM(ItemStack itemStack) {
        if (this.casingTier <= 0 || this.machineTier <= 0) {
            return false;
        }
        FluidStack[] inputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        if (this.mode == 0) {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                GT_Recipe tRecipe;
                if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)bus) || (tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Math.min(this.getMachineVoltageLimit(), this.getMaxInputEnergyPA()), inputFluids, this.getStoredItemFromHatch(bus))) == null || tRecipe.mSpecialValue > this.casingTier) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                tRecipe.isRecipeInputEqual(true, inputFluids, this.getStoredItemFromHatch(bus));
                this.mOutputItems = tRecipe.mOutputs;
                this.calculateOverclockedNessMultiPara(tRecipe.mEUt, tRecipe.mDuration, 1, Math.min(this.getMachineVoltageLimit(), this.getMaxInputEnergyPA()));
                this.updateSlots();
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                return true;
            }
        } else {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                GT_Recipe tRecipe;
                if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)bus) || this.getStoredItemFromHatch(bus).length < 1 || (tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Math.min(this.getMachineVoltageLimit(), this.getMaxInputEnergyPA()), inputFluids, this.getStoredItemFromHatch(bus))) == null) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                long fullInput = this.getMaxInputEnergy_EM();
                int pall = RecipeFinderForParallel.handleParallelRecipe((GT_Recipe)tRecipe, (FluidStack[])inputFluids, (ItemStack[])this.getStoredItemFromHatch(bus), (int)((int)Math.min((long)Math.pow(2.0, 4 + this.casingTier), fullInput / (long)tRecipe.mEUt)));
                if (pall <= 0) continue;
                Pair Outputs = RecipeFinderForParallel.getMultiOutput((GT_Recipe)tRecipe, (int)pall);
                long lEUt = (long)tRecipe.mEUt * (long)pall;
                int time = tRecipe.mDuration / 2;
                int modifier = 1;
                while (lEUt >= 0x7FFFFFFEL) {
                    lEUt = (long)tRecipe.mEUt * (long)pall / (long)modifier;
                    time = tRecipe.mDuration / 2 * modifier;
                    ++modifier;
                }
                this.mOutputItems = ((ArrayList)Outputs.getValue()).toArray(new ItemStack[0]);
                this.calculateOverclockedNessMultiPara((int)lEUt, time, 1, Math.min(0x7FFFFFFEL, this.getMaxInputEnergy_EM()));
                this.updateSlots();
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                return true;
            }
        }
        return false;
    }

    private long getMaxInputEnergyPA() {
        long rEnergy = 0L;
        if (this.mEnergyHatches.size() == 1) {
            return ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEnergy += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.eEnergyMulti) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEnergy += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rEnergy;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public long getMachineVoltageLimit() {
        if (this.machineTier <= 0) {
            return 0L;
        }
        if (this.machineTier >= 10) {
            return GT_Values.V[this.energyHatchTier];
        }
        return GT_Values.V[Math.min(this.machineTier - 1, this.energyHatchTier)];
    }

    public ItemStack[] getStoredItemFromHatch(GT_MetaTileEntity_Hatch_InputBus tHatch) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
            if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
            rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
        }
        return rList.toArray(new ItemStack[0]);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.mode == 0) {
            return MyRecipeAdder.instance.PA;
        }
        return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
    }

    public boolean drainEnergyInput_EM(long EUtTierVoltage, long EUtEffective, long Amperes) {
        long tDrain;
        long EUuse = EUtEffective * Amperes;
        if (EUuse < 0L) {
            EUuse = -EUuse;
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mEnergyHatches) {
            tDrain = Math.min(tHatch.getBaseMetaTileEntity().getStoredEU(), EUuse);
            tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            EUuse -= tDrain;
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.eEnergyMulti) {
            tDrain = Math.min(tHatch.getBaseMetaTileEntity().getStoredEU(), EUuse);
            tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            EUuse -= tDrain;
        }
        return EUuse <= 0L;
    }

    public boolean drainEnergyInput(long EUtEffective, long Amperes) {
        long tDrain;
        long EUuse = EUtEffective * Amperes;
        if (EUuse < 0L) {
            EUuse = -EUuse;
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mEnergyHatches) {
            tDrain = Math.min(tHatch.getBaseMetaTileEntity().getStoredEU(), EUuse);
            tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            EUuse -= tDrain;
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.eEnergyMulti) {
            tDrain = Math.min(tHatch.getBaseMetaTileEntity().getStoredEU(), EUuse);
            tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            EUuse -= tDrain;
        }
        return EUuse <= 0L;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 4, 4, 0, stackSize, hintsOnly);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.machineTier = 0;
        this.casingAmount = 0;
        this.casingTier = 0;
        this.energyHatchTier = 0;
        if (this.structureCheck_EM(this.mName, 4, 4, 0)) {
            this.energyHatchTier = this.checkEnergyHatchTier();
            if (this.casingTier != 0) {
                this.reUpdate(1538 + this.casingTier);
            }
            GoodGenerator.CHANNEL.sendToAllAround((IMessage)new MessageResetTileTexture(aBaseMetaTileEntity, this.casingTier), new NetworkRegistry.TargetPoint(aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, (double)aBaseMetaTileEntity.getXCoord(), (double)aBaseMetaTileEntity.getYCoord(), (double)aBaseMetaTileEntity.getZCoord(), 16.0));
            return this.casingAmount >= 42 && this.machineTier != 0 && this.casingTier != 0 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
        }
        return false;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Precise Assembler/Assembler").addInfo("Controller block for the Precise Assembler").addInfo("The error is no more than 0.03mm.").addInfo("Can assemble precise component in Precise Mode.").addInfo("Can work like a normal assembler in Normal Mode.").addInfo("Use screwdriver to change mode.").addInfo("Machine Casing and Energy Hatch limits the voltage tier the machine can work on.").addInfo("UHV Machine Casing will unlock all voltage, but you still need good Energy Hatch.").addInfo("Precise Electronic Unit Casing won't limit recipe in Normal Mode.").addInfo("But gives more parallel with more advanced one.").addInfo("It is 100% faster in Normal Mode.").addInfo("MK-I = 32x, MK-II = 64x, MK-III = 128x").addPollutionAmount(this.getPollutionPerSecond(null)).addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Any Casing").addInputBus("Any Casing").addOutputHatch("Any Casing").addOutputBus("Any Casing").addEnergyHatch("Any Casing").addMufflerHatch("Any Casing").addMaintenanceHatch("Any Casing").toolTipFinisher("Good Generator");
        return tt;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 780;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("PreciseAssembler.hint", 6);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new PreciseAssembler(this.mName);
    }

    private int checkEnergyHatchTier() {
        int tier = 0;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tier = Math.max(tHatch.mTier, tier);
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.eEnergyMulti) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tier = Math.max(tHatch.mTier, tier);
        }
        return tier;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public int getMachineTier() {
        return this.machineTier;
    }

    public void setMachineTier(int i) {
        this.machineTier = i;
    }

    public void reUpdate(int texture) {
        for (GT_MetaTileEntity_Hatch hatch : this.mInputHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mInputBusses) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mOutputHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mOutputBusses) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mEnergyHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mMaintenanceHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mMufflerHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.eEnergyMulti) {
            hatch.updateTexture(texture);
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        int t = 1;
        if (this.getCasingTier() != 0) {
            t = this.getCasingTier();
        }
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1538 + t)), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1538 + t)), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1538 + t))};
    }
}

